/*
 * cptape - copy tape files of unknown record length
 */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/file.h>

#define NBUF	    1

#if NBUF > 1
#include <sys/ioctl.h>
#endif

int getopt ();
extern char *optarg;
extern int optind, opterr;

#define BUFSIZE	    16384	/* According to mtio(4), max tape block size
				 * for SCSI tapes on the VAX is 16K.
				 */

int
docopy(fromfd, logfile)
int fromfd;
FILE *logfile;
{
    static unsigned char buffer[BUFSIZE];
    unsigned long recordno;
    int fileopen = 0;
    unsigned filecnt = 1;
    int tofd;
    char tofilename[8];
    unsigned long currecsize;

    for (;; recordno++) {
	long bytesread;

	errno = 0;
	bytesread = read(fromfd, buffer, BUFSIZE);
	if (bytesread < 0) {
	    perror("tape read");
	    return 1;	    /* this is an error */
	} else if (bytesread == 0) {
	    if (fileopen)
	    {
		if (close(tofd))
		{
		    perror("output file: close");
		    exit(1);
		}
		printf("Tapemark, end of file #%02u\n", filecnt);
		filecnt++;
		fileopen = 0;
	    }
	    else
	    {
		puts("Tapemark, end of tape");
		return 0;
	    }
	} else {
	    /* read some data - copy it */
	    unsigned long byteswritten;

	    if (!fileopen)
	    {
		printf("Starting file #%02u, record size: %lu\n", filecnt,
		       bytesread);
		if (logfile)
		    fprintf(logfile, "File #%02u, record size: %lu\n", filecnt,
		            bytesread);
		sprintf(tofilename, "file.%02u", filecnt);
		tofd = creat(tofilename, 0666);
		if (tofd == -1)
		{
		    perror("output file: creat");
		    exit(1);
		}
		fileopen = 1;
		recordno = 0;
		currecsize = bytesread;
	    }
	    else
		if (bytesread != currecsize)
		{
		    printf("Warning: record #%lu of file #%02u is %lu bytes\n",
		           recordno, filecnt, bytesread);
		    if (logfile)
			fprintf(logfile, "Warning: record #%lu of file #%02u is %lu bytes\n", recordno, filecnt, bytesread);
		}

	    errno = 0;
	    byteswritten = write(tofd, buffer, bytesread);
	    if (byteswritten != bytesread) {
		perror("output file: write");
		return 1;   /* error */
	    }
	}
    } /* for */

    /* NOTREACHED */
}

	  
int
main(argc, argv)
int argc;
char **argv;
{
    int c;
    char *logfilename = NULL;
    FILE *logfile = NULL;
    char *fromfilename = NULL;
    int fromfd = -1;
    int errflg = 0;

    while ((c = getopt(argc, argv, "l:")) != EOF) {
	switch (c) {
	case 'l':
	    logfilename = optarg;
	    break;
	default:
	case '?':
	    errflg++;
	    break;
	}
    }

    if (errflg || optind != argc - 1) {
	fprintf(stderr, "usage: cptape [-l logfile] from\n");
	exit(2);
    }

    if (logfilename) {
	logfile = fopen(logfilename, "w");
	if (!logfile)
	{
	    perror(logfilename);
	    exit(1);
	}
    }

    fromfilename = argv[optind];

    fromfd = open(fromfilename, O_RDONLY, 0);
    if (fromfd == -1) {
	perror("opening tape input file");
	exit(1);
    }

    return docopy(fromfd, logfile);
}
