/* Copyright (c)1994-1999 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */

# if defined(INS_I386)

/************************************************************
 *
 * processor emulation - I386
 */

/*
 * fast block move, addresses are aligned on 16bit boundaries
 * It turns out that this isn't faster than bcopy!
# define CopyW(T,F,C)	asm("cld; 			\
			     movl %2, %%ecx;		\
			     andl $1, %2;		\
			     shrl $1, %%ecx;		\
			     rep; movsl;		\
			     movl %2, %%ecx;		\
			     rep; movsw"		\
			   : : "D"(T), "S"(F), "r"(C) : "ecx")
 */
# define CopyW(T,F,C)	bcopy((F), (T), (C) << 1)

/*
 * Test word/byte and set N and Z
 */
# define TestW(V)	asm("testw %2, %2; setz %0; sets %1" 		\
			   : "=g"(proc.z), "=g"(proc.n) 		\
			   : "r"((short)V) : "cc")
# define TestB(V)	asm("testb %2, %2; setz %0; sets %1" 		\
			   : "=g"(proc.z), "=g"(proc.n) 		\
			   : "q"(V) : "cc")

/*
 * compare words/bytes and set NZCV
 */
# define CmpW(D,S)	asm("subw %4, %5; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v) \
			   : "r"((short)D), "r"((short)S) : "cc")
# define CmpB(D,S)	asm("subb %4, %5; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=q"(proc.v) \
			   : "q"(D), "q"(S) : "cc")

/*
 * sub/add words/bytes and set NZCV
 */
# define SubWC(D,S)	asm("subw %6, %5; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v), "=r"(D) \
			   : "4"((short)D), "g"((short)S) : "cc")
# define AddWC(D,S)	asm("addw %6, %5; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v), "=r"(D) \
			   : "4"((short)D), "g"((short)S) : "cc")
# define SubBC(D,S)	asm("subb %%dl, %%al; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=q"(proc.n), "=g"(proc.c), "=q"(proc.v), "=a"(D) \
			   : "4"(D), "d"(S) : "cc")
# define AddBC(D,S)	asm("addb %%dl, %%al; setz %0; sets %1; setb %2; seto %3" \
			   : "=g"(proc.z), "=q"(proc.n), "=g"(proc.c), "=q"(proc.v), "=a"(D) \
			   : "4"(D), "d"(S) : "cc")

/*
 * sub/add words/bytes and set NZV
 */
# define SubW(D,S)	asm("subw %5, %4; setz %0; sets %1; seto %2" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=g"(D) \
			   : "3"((short)D), "r"((short)S) : "cc")
# define AddW(D,S)	asm("addw %5, %4; setz %0; sets %1; seto %2" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=g"(D) \
			   : "3"((short)D), "r"((short)S) : "cc")
# define SubB(D,S)	asm("subb %%dl, %%al; setz %0; sets %1; seto %2" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=a"(D) \
			   : "3"(D), "d"(S) : "cc")
# define AddB(D,S)	asm("addb %%dl, %%al; setz %0; sets %1; seto %2" \
			   : "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=a"(D) \
			   : "3"(D), "d"(S) : "cc")

# define SwabB(D)	asm("xchgb %%al, %%ah" : "=a"(D) : "0"((short)D) : "cc");

/*
 * this is a workaround for a bug in cc1
# define SCHAR(S)	({ ushort _tm1 = (S); (sshort)(schar)_tm1; })
*/
# define SCHAR(S)	((sshort)(schar)(S))


/* v/d -> v1
 * v%d -> v2
 * idivl: %eax / %e?x -> %eax
 *        %eax % %e?x -> %edx
 * ==> v1==a v2==d
 *     v==v1
 * Force d into %cx - gcc may put it into %edx and this will fail!
 */
# define Div(v1,v2,v,d)	asm("cltd; idivl %3"		\
		   	   : "=a"(v1), "=d"(v2)		\
		   	   : "0"(v), "c"(d))

# elif defined(INS_SPARC)

/************************************************************
 *
 * processor emulation - SPARC
 */

/*
 * fast block move, addresses are aligned on 16bit boundaries
 */
# define CopyW(T,F,C)	bcopy((F), (T), (C) << 1)

/*
 * Test word/byte and set N and Z
 */
# define TestW(V)	asm("	sll	%2,16,%%g1			;\
				tst	%%g1				;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1"			\
			: "=m"(proc.z), "=m"(proc.n)			\
			: "r"((short)V) : "g1", "cc")

# define TestB(V)	asm("	sll	%2,24,%%g1			;\
				tst	%%g1				;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1"			\
			: "=m"(proc.z), "=m"(proc.n)			\
			: "r"(V) : "g1", "cc")

/*
 * compare words/bytes and set NZCV
 */
# define CmpW(D,S)	asm("	sll	%4,16,%4			;\
				sll	%5,16,%5			;\
				cmp	%5,%4				;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=m"(proc.z), "=m"(proc.n), "=m"(proc.c), "=m"(proc.v) \
			: "r"((short)D), "r"((short)S) : "g1", "cc" )

# define CmpB(D,S)	asm("	sll	%4,24,%4			;\
				sll	%5,24,%5			;\
				cmp	%5,%4				;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=m"(proc.z), "=m"(proc.n), "=m"(proc.c), "=m"(proc.v) \
			: "r"((short)D), "r"((short)S) : "g1", "cc" )

/*
 * sub/add words/bytes and set NZCV
 */
# define SubWC(D,S)	asm("	sll	%6,16,%6			;\
				sll	%5,16,%5			;\
				subcc	%5,%6,%4			;\
				sra	%4,16,%4			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=m"(proc.z), "=m"(proc.n), "=m"(proc.c), "=m"(proc.v), "=r"(D) \
			: "4"((short)D), "r"((short)S) : "g1", "cc" )

# define AddWC(D,S)	asm("	sll	%6,16,%6			;\
				sll	%5,16,%5			;\
				addcc	%6,%5,%4			;\
				sra	%4,16,%4			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=m"(proc.z), "=m"(proc.n), "=m"(proc.c), "=m"(proc.v), "=r"(D) \
			: "4"((short)D), "r"((short)S) : "g1", "cc" )

# define SubBC(D,S)	asm("	sll	%6,24,%6			;\
				sll	%5,24,%5			;\
				subcc	%5,%6,%4			;\
				sra	%4,24,%4			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=m"(proc.z), "=m"(proc.n), "=m"(proc.c), "=m"(proc.v), "=r"(D) \
			: "4"((short)D), "r"((short)S) : "g1", "cc" )

# define AddBC(D,S)	asm("	sll	%6,24,%6			;\
				sll	%5,24,%5			;\
				addcc	%6,%5,%4			;\
				sra	%4,24,%4			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=m"(proc.z), "=m"(proc.n), "=m"(proc.c), "=m"(proc.v), "=r"(D) \
			: "4"((short)D), "r"((short)S) : "g1", "cc" )

/*
 * sub/add words/bytes and set NZV
 */
# define SubW(D,S)	asm("	sll	%5,16,%5			;\
				sll	%4,16,%4			;\
				subcc	%4,%5,%3			;\
				sra	%3,16,%3			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%2"			\
			: "=m"(proc.z), "=m"(proc.n), "=m"(proc.v), "=r"(D) \
			: "3"((short)D), "r"((short)S) : "g1", "cc" )

# define AddW(D,S)	asm("	sll	%5,16,%5			;\
				sll	%4,16,%4			;\
				addcc	%5,%4,%3			;\
				sra	%3,16,%3			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%2"			\
			: "=m"(proc.z), "=m"(proc.n), "=m"(proc.v), "=r"(D) \
			: "3"((short)D), "r"((short)S) : "g1", "cc" )

# define SubB(D,S)	asm("	sll	%5,24,%5			;\
				sll	%4,24,%4			;\
				subcc	%4,%5,%3			;\
				sra	%3,24,%3			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%2"			\
			: "=m"(proc.z), "=m"(proc.n), "=m"(proc.v), "=r"(D) \
			: "3"((short)D), "r"((short)S) : "g1", "cc" )

# define AddB(D,S)	asm("	sll	%5,24,%5			;\
				sll	%4,24,%4			;\
				addcc	%5,%4,%3			;\
				sra	%3,24,%3			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%2"			\
			: "=m"(proc.z), "=m"(proc.n), "=m"(proc.v), "=r"(D) \
			: "3"((short)D), "r"((short)S) : "g1", "cc" )


# define SwabB(D)	(D)=((((D)<<8)&0xff00)|(((D)>>8)&0xff))

# define SCHAR(S)	((sshort)(schar)(S))

# define Div(v1,v2,v,d)	(v1 = v/d, v2 = v%d)


# else
/************************************************************
 *
 * processor emulation - GENERIC
 */
/*
 * fast block move, addresses are aligned on 16bit boundaries
 */
# define CopyW(T,F,C)	bcopy((F), (T), (C) << 1)


# define SCHAR(S)	((sshort)(schar)(S))

# define WTEST(R)	(void)((proc.n = ((sshort)(R) < 0)),	\
			       (proc.z = ((ushort)(R) == 0)))
# define BTEST(R)	(void)((proc.n = ((schar)(R) < 0)),	\
			       (proc.z = ((uchar)(R) == 0)))
# define WC(R)		(void)(proc.c = ((R) >> 16) & 1)
# define BC(R)		(void)(proc.c = ((R) >> 8) & 1)
# define WV_SUB(D,S,R)	(void)(proc.v = (((D) ^ (S)) & ((S) ^ (ushort)(R)) & 0x8000) != 0)
# define BV_SUB(D,S,R)	(void)(proc.v = (((D) ^ (S)) & ((S) ^ (ushort)(R)) & 0x80) != 0)
# define WV_ADD(D,S,R)	(void)(proc.v = (~((D) ^ (S)) & ((S) ^ (ushort)(R)) & 0x8000) != 0)
# define BV_ADD(D,S,R)	(void)(proc.v = (~((D) ^ (S)) & ((S) ^ (ushort)(R)) & 0x80) != 0)

/*
 * Test word/byte set NZ
 */
# define TestW(S)	WTEST((S))
# define TestB(S)	BTEST((S))

/*
 * Compare word/byte set NZVC
 */
# define CmpW(D,S) 	(void)({ ulong _r = (ulong)(S) - (ulong)(D);	\
				 WTEST(_r); WC(_r); WV_SUB((D),(S),_r); })
# define CmpB(D,S) 	(void)({ ulong _r = (ulong)(S) - (ulong)(D);	\
				 BTEST(_r); BC(_r); BV_SUB((D),(S),_r); })

/*
 * Subtract/add word/byte and set NZVC
 */
# define SubWC(D,S)	(void)({ ulong _r = (ulong)(D) - (ulong)(S);	\
				 WTEST(_r); WC(_r); WV_SUB((S),(D),_r); (D)=_r; })
# define AddWC(D,S)	(void)({ ulong _r = (ulong)(D) + (ulong)(S);	\
				 WTEST(_r); WC(_r); WV_ADD((D),(S),_r); (D)=_r; })
# define SubBC(D,S)	(void)({ ulong _r = (ulong)(D) - (ulong)(S);	\
				 BTEST(_r); BC(_r); BV_SUB((S),(D),_r); (D)=_r; })
# define AddBC(D,S)	(void)({ ulong _r = (ulong)(D) + (ulong)(S);	\
				 BTEST(_r); BC(_r); BV_ADD((D),(S),_r); (D)=_r; })

/*
 * Subtract/add word/byte and set NZV
 */
# define SubW(D,S)	(void)({ ulong _r = (ulong)(D) - (ulong)(S);	\
				 WTEST(_r); WV_SUB((S),(D),_r); (D)=_r; })
# define AddW(D,S)	(void)({ ulong _r = (ulong)(D) + (ulong)(S);	\
				 WTEST(_r); WV_ADD((D),(S),_r); (D)=_r; })
# define SubB(D,S)	(void)({ ulong _r = (ulong)(D) - (ulong)(S);	\
				 BTEST(_r); BV_SUB((S),(D),_r); (D)=_r; })
# define AddB(D,S)	(void)({ ulong _r = (ulong)(D) + (ulong)(S);	\
				 BTEST(_r); BV_ADD((D),(S),_r); (D)=_r; })

/*
 * swap bytes no flags
 */
# define SwabB(D)	(void)((D) = ((((D)<<8)&0xff00)|(((D)>>8)&0xff)))

/*
 * divide et impera, no flags
 */
# define Div(v1,v2,v,d)	(void)(v1 = v/d, v2 = v%d)
# endif
