/* trap.c - Deal with trap instructions */

/* This is very ugly code. */

#include "defines.h"
#include <sys/stat.h>
#include <sys/time.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/wait.h>
#include <signal.h>
#include <termios.h>
#include <utime.h>
#include "trap.h"

extern char realfilename[], *rfn, *progname;
#ifdef DEBUG
extern int trap_debug;
extern FILE *dbg_file;
#endif

#ifdef STREAM_BUFFERING
/* The following array holds the FILE pointers that correspond to open file
 * descriptors. Only fds which are not ttys have FILE * pointers
 */
FILE *stream[40];
#endif

void
trap()
{
    int i, pid, pfd[2];
    char *buf, *buf2, *buf3;
    char *fmode;		/* used with fdopen only */
    int16_t scnt, scnt2;

    struct stat stbuf;		/* used in STAT */
    struct tr_stat *t;		/* used in STAT */
    struct tr_timeb *tb;	/* used in FTIME */
    struct timezone tz;		/* used in FTIME */
    struct timeval tv;		/* used in FTIME */
    struct timeval utv[2];	/* used in UTIME */

    long tim;
    uint16_t ucnt, ucnt2;
    uint16_t oldpc;
    uint16_t newpc;

#ifdef DEBUG
    if (trap_debug && (ir & 077))
	fprintf(dbg_file, "%s %s ", progname, trap_name[ir & 077]);
#endif
    switch (ir & 077) {
    case S_INDIR:
	oldpc = regs[PC];
	lli_word(oldpc, newpc);
	ll_word(newpc, ir);
	regs[PC] = newpc + 2;
	trap();
	regs[PC] = oldpc + 2;
	return;
			/* These syscalls are not implemented, and */
			/* always return EPERM to the caller */
    case S_PHYS:
	regs[PC] += 6;
	SET_CC_C();
	regs[0] = EPERM;
	return;
    case S_PROF:
	regs[PC] += 8;
	SET_CC_C();
	regs[0] = EPERM;
	return;
    case S_PTRACE:
	regs[PC] += 6;
	SET_CC_C();
	regs[0] = EPERM;
	return;
    case S_ACCT:
	regs[PC] += 2;
	SET_CC_C();
	regs[0] = EPERM;
	return;
    case S_MOUNT:
	regs[PC] += 6;
	SET_CC_C();
	regs[0] = EPERM;
	return;
    case S_UMOUNT:
	regs[PC] += 2;
	SET_CC_C();
	regs[0] = EPERM;
	return;
    case S_TIMES:
	regs[PC] += 2;
	SET_CC_C();
	regs[0] = EPERM;
	return;
    case S_PAUSE:
	i = pause();
	goto if_i;
    case S_DUP:
				/* STREAM code needed here */
	if (regs[0] > 0100) {
	    scnt = regs[0] - 0100;
	    scnt2 = regs[1];
	    i = dup2(scnt, scnt2);
	} else
	    i = dup(regs[0]);
	goto if_i;
    case S_SYNC:
	sync();
	goto ok_zero;
    case S_EXIT:
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%d\n", regs[0]);
#endif
	exit(regs[0]);
	goto err_errno;
    case S_NICE:
	nice(regs[0]);
	goto ok_zero;
    case S_TIME:
	i = time(&tim);
	if (i == -1) {
	    goto err_errno;
	} else {
	    CLR_CC_C();
	    regs[1] = tim & 0xffff;
	    regs[0] = tim >> 16;
	}
	return;
    case S_ALARM:
	i = alarm(regs[0]);
	goto if_i;
    case S_UMASK:
	ll_word(regs[PC], scnt);
	i = umask(scnt);
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%o   ", scnt);
#endif
	regs[PC] += 2;
	goto if_i;
    case S_LSEEK:
	ll_word(regs[PC], ucnt);
	ll_word(regs[PC] + 2, ucnt2);
	tim = (ucnt << 16) | ucnt2;
	ll_word(regs[PC] + 4, scnt);
#ifdef STREAM_BUFFERING
	if (stream[regs[0]]) {
	    i = fseek(stream[regs[0]], tim, scnt);
	    if (i == 0)
		i = ftell(stream[regs[0]]);
	} else
#endif
	    i = lseek(regs[0], tim, scnt);
#ifdef DEBUG
	if (trap_debug)
	    fprintf(dbg_file, "fd %d offset %ld how %d    rtn %d\n",
		    regs[0], tim, scnt, i);
#endif
	regs[PC] += 6;
	if (i == -1) {
	    goto err_errno;
	} else {
	    regs[1] = i & 0xffff;
	    regs[0] = (i >> 16) & 0xffff;
	    CLR_CC_C();
	    return;
	}
    case S_READ:
	ll_word(regs[PC], ucnt);
	buf = &dspace[ucnt];
	ll_word(regs[PC] + 2, scnt);
#ifdef STREAM_BUFFERING
	if (stream[regs[0]])
	    i = fread(buf, 1, scnt, stream[regs[0]]);
	else
#endif
	    i = read(regs[0], buf, scnt);
#ifdef DEBUG
	if (trap_debug)
	    fprintf(dbg_file, "%d bytes from fd %d    ", scnt, regs[0]);
#endif
	regs[PC] += 4;
	goto if_i;
    case S_LINK:
	ll_word(regs[PC], ucnt);
	buf3 = &dspace[ucnt];
	buf = xlate_filename(buf3);
	buf3 = &dspace[ucnt];
	buf2 = xlate_filename(buf3);
	i = link(buf, buf2);
	regs[PC] += 4;
	goto if_i;
    case S_ACCESS:
	ll_word(regs[PC], ucnt);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);
	ll_word(regs[PC] + 2, scnt);
	i = access(buf, scnt);
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%s mode %o   ", buf, scnt);
#endif
	regs[PC] += 4;
	goto if_zero;
    case S_WRITE:
	ll_word(regs[PC], ucnt);
	buf = &dspace[ucnt];
	ll_word(regs[PC] + 2, scnt);
#ifdef STREAM_BUFFERING
	if (stream[regs[0]])
	    i = fwrite(buf, 1, scnt, stream[regs[0]]);
	else
#endif
	    i = write(regs[0], buf, scnt);
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%d bytes to fd %d    ",scnt,regs[0]);
#endif
	regs[PC] += 4;
	goto if_i;
    case S_CLOSE:
#ifdef STREAM_BUFFERING
	if (stream[regs[0]]) {
	    i = fclose(stream[regs[0]]);
	    stream[regs[0]] = NULL;
	} else
#endif
	    i = close(regs[0]);
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "fd %d    ", regs[0]);
#endif
	goto if_zero;
			/* These syscalls are ignored, and */
			/* always return C=0 to the caller */
    case S_SIGNAL:
	regs[PC] += 4;
	goto ok_zero;
    case S_LOCK:
	regs[PC] += 2;
	goto ok_zero;
    case S_BREAK:
	ll_word(regs[PC] + 2, ucnt);
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%u  SP %u   ", ucnt, regs[SP]);
#endif
	regs[PC] += 2;
	goto ok_zero;
    case S_STIME:
	goto ok_zero;
    case S_GTTY:
	ll_word(regs[PC] + 2, ucnt);
	i = trap_gtty(regs[0], ucnt);
	regs[PC] += 2;
	goto if_i;
    case S_STTY:
	ll_word(regs[PC] + 2, ucnt);
	i = trap_stty(regs[0], ucnt);
	regs[PC] += 2;
	goto if_i;
    case S_IOCTL:
	ll_word(regs[PC] + 2, ucnt);
	switch (ucnt) {
	case (('t' << 8) + 8):	/* GTTY */
	    ll_word(regs[PC], ucnt);
	    ll_word(regs[PC] + 4, ucnt2);
	    i = trap_gtty(ucnt, ucnt2);
	    regs[PC] += 6;
	    goto if_zero;
	case (('t' << 8) + 9):	/* STTY */
	    ll_word(regs[PC], ucnt);
	    ll_word(regs[PC] + 4, ucnt2);
	    i = trap_stty(ucnt, ucnt2);
	    regs[PC] += 6;
	    goto if_zero;
	default:
	    regs[PC] += 6;
	    goto ok_zero;
	}
    case S_FTIME:
	ll_word(regs[PC], ucnt);
	buf = &dspace[ucnt];
	tb = (struct tr_timeb *) buf;
	i = gettimeofday(&tv, &tz);
	if (i == -1) {
	    goto err_errno;
	} else {
	    CLR_CC_C();
	    buf = (char *) &(tb->time);
	    buf2 = (char *) &(tv.tv_sec);
	    buf[0] = buf2[2];
	    buf[1] = buf2[3];
	    buf[2] = buf2[0];
	    buf[3] = buf2[1];
	    tb->millitm = tv.tv_usec / 1000;
	    tb->timezone = tz.tz_minuteswest;
	    tb->dstflag = tz.tz_dsttime;
	}
	regs[PC] += 2;
	return;
    case S_STAT:
	ll_word(regs[PC], ucnt);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);
	ll_word(regs[PC] + 2, ucnt);
	buf2 = &dspace[ucnt];
	t = (struct tr_stat *) buf2;
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%s    ", buf);
#endif
	i = stat(buf, &stbuf);
	regs[PC] += 4;
	goto dostat;
    case S_FSTAT:
	ll_word(regs[PC], ucnt);
	buf = &dspace[ucnt];
	t = (struct tr_stat *) buf;
	i = fstat(regs[0], &stbuf);
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%d    ", regs[0]);
#endif
	regs[PC] += 2;
dostat:
	if (i == -1) {
	    goto err_errno;
	} else {
	    CLR_CC_C();
	    t->st_dev = stbuf.st_dev;
	    t->st_ino = stbuf.st_ino;
	    t->st_mode = stbuf.st_mode;
	    t->st_nlink = stbuf.st_nlink;
	    t->st_uid = stbuf.st_uid;
	    t->st_gid = stbuf.st_gid;
	    t->st_rdev = stbuf.st_rdev;
	    buf = (char *) &(t->st_size);
	    buf2 = (char *) &(stbuf.st_size);
	    buf[0]= buf2[2]; buf[1]= buf2[3]; buf[2]= buf2[0]; buf[3]= buf2[1];
	    buf = (char *) &(t->st_atim);
	    buf2 = (char *) &(stbuf.st_atime);
	    buf[0]= buf2[2]; buf[1]= buf2[3]; buf[2]= buf2[0]; buf[3]= buf2[1];
	    buf = (char *) &(t->st_mtim);
	    buf2 = (char *) &(stbuf.st_mtime);
	    buf[0]= buf2[2]; buf[1]= buf2[3]; buf[2]= buf2[0]; buf[3]= buf2[1];
	    buf = (char *) &(t->st_ctim);
	    buf2 = (char *) &(stbuf.st_ctime);
	    buf[0]= buf2[2]; buf[1]= buf2[3]; buf[2]= buf2[0]; buf[3]= buf2[1];
	}
	goto ok_zero;
    case S_UTIME:
	ll_word(regs[PC], ucnt);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);
	ll_word(regs[PC] + 2, ucnt);
	utv[0].tv_usec = utv[1].tv_usec = 0;

	buf2 = &dspace[ucnt];
	buf3 = (char *) &(utv[0].tv_sec);
	buf3[0]= buf2[2]; buf3[1]= buf2[3]; buf3[2]= buf2[0]; buf3[3]= buf2[1];

	buf2 += 4;
	buf3 = (char *) &(utv[1].tv_sec);
	buf3[0]= buf2[2]; buf3[1]= buf2[3]; buf3[2]= buf2[0]; buf3[3]= buf2[1];

	i = utimes(buf, utv);
	regs[PC] += 4;
	goto if_i;
    case S_UNLINK:
	ll_word(regs[PC], ucnt);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);
	i = unlink(buf);
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%s    ", buf);
#endif
	regs[PC] += 2;
	goto if_zero;
    case S_OPEN:
	ll_word(regs[PC], ucnt);
	ll_word(regs[PC] + 2, scnt);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);

	i = stat(buf, &stbuf);	/* If file is a directory */
	if (i == 0 && (stbuf.st_mode & S_IFDIR)) {
	    i = open_dir(buf);
	    fmode = "rw";
	} else {
	    switch (scnt) {
	    case 0: scnt = O_RDONLY; fmode = "r"; break;
	    case 1: scnt = O_WRONLY; fmode = "w"; break;
	    default: scnt = O_RDWR; fmode = "rw"; break;
	    }
	    i = open(buf, scnt);
	}
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%s %d  ", buf, scnt);
#endif

#ifdef STREAM_BUFFERING
	/* Now get its stream pointer if possible */
	if (!isatty(i))
	    stream[i] = fdopen(i, fmode);
#endif
	regs[PC] += 4;
	goto if_i;
    case S_MKNOD:
	ll_word(regs[PC], ucnt);
	ll_word(regs[PC] + 2, scnt);
	ll_word(regs[PC] + 4, scnt2);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);
	i = mknod(buf, scnt, scnt2);
	regs[PC] += 6;
	goto if_i;
    case S_CHMOD:
	ll_word(regs[PC], ucnt);
	ll_word(regs[PC] + 2, scnt);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);
	i = chmod(buf, scnt);
	regs[PC] += 4;
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%s %o    ", buf, scnt);
#endif
	goto if_zero;
    case S_KILL:
	ll_word(regs[PC], scnt);
	i = kill(regs[0], scnt);
	regs[PC] += 2;
	goto if_i;
    case S_CHOWN:
	ll_word(regs[PC], ucnt);
	ll_word(regs[PC] + 2, scnt);
	ll_word(regs[PC] + 4, scnt2);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);
	i = chown(buf, scnt, scnt2);
	regs[PC] += 6;
	goto if_zero;
    case S_PIPE:
	i = pipe(pfd);
	if (i == -1)
	    goto err_errno;
#ifdef STREAM_BUFFERING
	stream[pfd[0]] = fdopen(pfd[0], "r");
	stream[pfd[1]] = fdopen(pfd[1], "w");
#endif
	regs[0] = pfd[0];
	regs[1] = pfd[1];
	CLR_CC_C();
	return;
    case S_CHROOT:
	ll_word(regs[PC], ucnt);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);
	if (buf == NULL) {
	    SET_CC_C();
	    regs[0] = ENOENT;
	    return;
	}
	strcpy(rfn, buf);
	rfn += strlen(buf) + 1;
	regs[PC] += 2;
	goto ok_zero;
    case S_CHDIR:
	ll_word(regs[PC], ucnt);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);
	i = chdir(buf);
	regs[PC] += 2;
	goto if_i;
    case S_CREAT:
	ll_word(regs[PC], ucnt);
	buf2 = &dspace[ucnt];
	buf = xlate_filename(buf2);
	ll_word(regs[PC] + 2, scnt);
	i = creat(buf, scnt);
#ifdef STREAM_BUFFERING
	stream[i] = fdopen(i, "w");
#endif
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%s %o    ", buf, scnt);
#endif
	regs[PC] += 4;
	goto if_i;
    case S_EXECE:
	trap_exec(0);
	regs[PC] += 6;
	SET_CC_C();
	return;
    case S_EXEC:
	trap_exec(1);
	regs[PC] += 4;
	SET_CC_C();
	return;
    case S_WAIT:
	i = wait(&pid);
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "got status %d   ", pid);
#endif
	if (i == -1)
	    goto err_errno;
	regs[1] = pid;
	goto ok_i;
    case S_FORK:
	pid = getpid();
	i = fork();
	switch (i) {
	    /* Error, inform the parent */
	case -1:
	    goto err_errno;
	    /* Child gets ppid in r0 */
	case 0:
	    regs[0] = pid;
	    CLR_CC_C();
	    return;
	    /* Parent: Skip child `bf', pid into r0 */
	default:
	    regs[PC] += 2;
	    goto ok_i;
	}
    case S_GETUID:
	CLR_CC_C();
	i = getuid();
	regs[0] = i;
	i = geteuid();
	regs[1] = i;
	return;
    case S_GETPID:
	CLR_CC_C();
	i = getpid();
#ifdef DEBUG
	/* fprintf(dbg_file, "%s getpid rtn %d\n", progname, i); */
#endif
	regs[0] = i;
	return;
    case S_GETGID:
	CLR_CC_C();
	i = getgid();
	regs[0] = i;
	i = getegid();
	regs[1] = i;
	return;
    case S_SETUID:
	i = setuid(regs[0]);
	goto if_i;
    case S_SETGID:
	i = setgid(regs[0]);
	goto if_i;
    }
    fprintf(stderr,"Apout - unknown syscall %d at PC 0x%x\n",ir & 077,regs[PC]);
    exit(1);

if_zero:
    		/* Do this for now, must map errno properly later */
    if (i == -1) { SET_CC_C(); regs[0] = errno;
    } else { CLR_CC_C(); }
#ifdef DEBUG
    if (trap_debug) {
	fprintf(dbg_file, "if_i: i is %d", i);
	if (i == -1)
	    fprintf(dbg_file, ", errno is %d\n", errno);
	fprintf(dbg_file, "\n");
    }
#endif
    return;

if_i:
    		/* Do this for now, must map errno properly later */
    if (i == -1) { SET_CC_C(); regs[0] = errno;
    } else { CLR_CC_C(); regs[0] = i; }
#ifdef DEBUG
    if (trap_debug) {
	fprintf(dbg_file, "if_i: i is %d", i);
	if (i == -1)
	    fprintf(dbg_file, ", errno is %d\n", errno);
	fprintf(dbg_file, "\n");
    }
#endif
    return;

ok_zero:
    CLR_CC_C();
#ifdef DEBUG
    if (trap_debug) fprintf(dbg_file, "ok_zero\n");
#endif
    return;

ok_i:
    CLR_CC_C();
    regs[0] = i;
#ifdef DEBUG
    if (trap_debug) {
	fprintf(dbg_file, "ok_i: i is %d", i);
	if (i == -1)
	    fprintf(dbg_file, ", errno is %d\n", errno);
	fprintf(dbg_file, "\n");
    }
#endif
    return;

err_errno:
    SET_CC_C();
    regs[0] = errno;
#ifdef DEBUG
    if (trap_debug) {
	fprintf(dbg_file, "err_errno: i is %d", i);
	if (i == -1)
	    fprintf(dbg_file, ", errno is %d\n", errno);
	fprintf(dbg_file, "\n");
    }
#endif
    return;
}


char *
xlate_filename(char *name)
{

    if (name == NULL) return (NULL);
    if (name[0] != '/') return (name);
    strcpy(rfn, name);
    return (realfilename);
}

void
trap_exec(int oldexec)
{
    char *argv[MAX_ARGS], *envp[MAX_ARGS];
    int argc = 0, envc = 0;
    uint16_t cptr, cptr2;
    char *buf, *name;

    ll_word(regs[PC], cptr);
    buf = strdup(&dspace[cptr]);
    name = xlate_filename(buf);
#ifdef DEBUG
    if (trap_debug) fprintf(dbg_file, "%s Execing %s ", progname, name);
#endif

    ll_word(regs[PC] + 2, cptr);
    while (argc < MAX_ARGS) {
	ll_word(cptr, cptr2);
	if (cptr2 == NULL)
	    break;
	buf = &dspace[cptr2];
	argv[argc++] = strdup(buf);
	cptr += 2;
#ifdef DEBUG
	if (trap_debug) fprintf(dbg_file, "%s ", buf);
#endif
    }
    argv[argc] = NULL;
#ifdef DEBUG
    if (trap_debug) fprintf(dbg_file, "\n");
#endif

    if (!oldexec) {
	ll_word(regs[PC] + 4, cptr);
	while (envc < MAX_ARGS) {
	    ll_word(cptr, cptr2);
	    if (cptr2 == NULL)
		break;
	    buf = &dspace[cptr2];
	    envp[envc++] = strdup(buf);
	    cptr += 2;
	}
    }
    envp[envc] = NULL;

    if (load_a_out(name) == -1) {
	SET_CC_C();
	regs[0] = ENOENT;
	for (argc--; argc >= 0; argc--)
	    free(argv[argc]);
	for (envc--; envc >= 0; envc--)
	    free(envp[envc]);
	free(name);
	return;
    }
    sim_init();
    set_arg_env(argc, argv, envc, envp, oldexec);
    for (argc--; argc >= 0; argc--)
	free(argv[argc]);
    for (envc--; envc >= 0; envc--)
	free(envp[envc]);
    free(name);
    run();			/* Ok, so it's recursive, I dislike setjmp */
}

int
open_dir(char *name)
{
    DIR *d;
    int i;
    struct dirent *dent;

    struct old_direct {
	int16_t d_ino;
	int8_t d_name[14];
    } odent;

    d = opendir(name);
    if (d == NULL) return (-1);
    i = open("/usr/tmp/apout_dir", O_CREAT | O_TRUNC | O_RDWR, 0600);
    if (i == -1) {
	fprintf(stderr, "Couldn't open /usr/tmp/apout_dir\n");
	exit(1);
    }
    unlink("/usr/tmp/apout_dir");

    while ((dent = readdir(d)) != NULL) {
	odent.d_ino = dent->d_fileno;
	strncpy(odent.d_name, dent->d_name, 14);
	write(i, &odent, 16);
    }
    closedir(d);
    lseek(i, 0, SEEK_SET);
    return (i);
}

int
trap_gtty(uint16_t fd, uint16_t ucnt)
{
    struct tr_sgttyb *sgtb;	/* used in GTTY/STTY */
    struct termios tios;	/* used in GTTY/STTY */
    int i;

    i = tcgetattr(fd, &tios);
    if (i == -1)
	return i;
    CLR_CC_C();
    sgtb = (struct tr_sgttyb *) & dspace[ucnt];
    sgtb->sg_ispeed = tios.c_ispeed;
    sgtb->sg_ospeed = tios.c_ospeed;
    sgtb->sg_erase = tios.c_cc[VERASE];
    sgtb->sg_kill = tios.c_cc[VKILL];
    sgtb->sg_flags = 0;
    if (tios.c_oflag & OXTABS)
	sgtb->sg_flags |= TR_XTABS;
    if (tios.c_cflag & PARENB) {
	if (tios.c_cflag & PARODD)
	    sgtb->sg_flags |= TR_ODDP;
	else
	    sgtb->sg_flags |= TR_EVENP;
    } else
	sgtb->sg_flags |= TR_ANYP;
    if (tios.c_oflag & ONLCR)
	sgtb->sg_flags |= TR_CRMOD;
    if (tios.c_lflag & ECHO)
	sgtb->sg_flags |= TR_ECHO;
    if (!(tios.c_lflag & ICANON)) {
	if (!(tios.c_lflag & ECHO))
	    sgtb->sg_flags |= TR_CBREAK;
	else
	    sgtb->sg_flags |= TR_RAW;
    }
    return 0;
}
int
trap_stty(uint16_t fd, uint16_t ucnt)
{
    struct tr_sgttyb *sgtb;	/* used in GTTY/STTY */
    struct termios tios;	/* used in GTTY/STTY */
    int i;

    if (ucnt != 0) {
	sgtb = (struct tr_sgttyb *) & dspace[ucnt];
	tios.c_ispeed = sgtb->sg_ispeed;
	tios.c_ospeed = sgtb->sg_ospeed;
	tios.c_cc[VERASE] = sgtb->sg_erase;
	tios.c_cc[VKILL] = sgtb->sg_kill;
	if (sgtb->sg_flags & TR_XTABS)
	    tios.c_oflag |= OXTABS;
	if (sgtb->sg_flags & TR_ODDP) {
	    tios.c_cflag |= PARENB;
	    tios.c_cflag &= ~PARODD;
	}
	if (sgtb->sg_flags & TR_EVENP)
	    tios.c_cflag |= PARENB | PARODD;
	if (sgtb->sg_flags & TR_ANYP)
	    tios.c_cflag &= ~PARENB;
	if (sgtb->sg_flags & TR_CRMOD)
	    tios.c_oflag |= ONLCR;
	if (sgtb->sg_flags & TR_ECHO)
	    tios.c_lflag |= ECHO;
	if (sgtb->sg_flags & TR_RAW) {
	    tios.c_lflag &= (~ICANON) & (~ECHO);
	    for (i = 0; i < NCCS; i++)
		tios.c_cc[i] = 0;
	    tios.c_cc[VMIN] = 1;
	}
	if (sgtb->sg_flags & TR_CBREAK) {
	    tios.c_lflag &= (~ICANON);
	    tios.c_lflag |= ECHO;
	    for (i = 0; i < NCCS; i++)
		tios.c_cc[i] = 0;
	    tios.c_cc[VMIN] = 1;
	}
	i = tcsetattr(fd, TCSANOW, &tios);
	return (i);
    } else
	return (-1);
}
