/* rx50in.c - a simple program to deinterleave RX50 disks
   stdin should be device or image, output to stdout
   Note: assumes RQDX3 interleave; pads output with nulls */

#include <unistd.h>
#include <stdio.h>
#include <sys/errno.h>

char out[409600];
char buf[512];
int l,n = 0;

int rxoffset(int secno);

int main (int argc, char * argv[]) {
memset(out,0,409600);
while (1) {
	memset(buf,0,512);
	l = read (STDIN_FILENO,buf,512);
	if (l == -1) {
		fprintf(stderr,"%s: read error (%s)\n",argv[0],strerror(errno));
		exit(-1);
	}
	if (l == 0) goto OUTPUT;
	memcpy(out+rxoffset(n),buf,512);
	++n;
}	

OUTPUT:
write(STDOUT_FILENO,out,409600);
}

int rxoffset(int secno) {
	int ps,ls,pt,lt;
	if (secno > 799) {
		fprintf(stderr,"Input too large for RX50. No output.\n");
		exit(-1);
	}
	pt = secno / 10;
	ps = secno % 10;
	lt = pt?(pt-1):79;
	ps = ((ps+10)-((lt*2)%10))%10; /* deskew */
	if (ps%2) {
		ls = ((ps-1)/2)+5;
	} else {
		ls = ps/2;
	}

	return ((lt*10 + ls)*512);
}
