/ low core

br4 = 200
br5 = 240
br6 = 300
br7 = 340

. = 0^.
	br	1f
	4

/ trap vectors
	trap; br7+0.		/ bus error
	trap; br7+1.		/ illegal instruction
	trap; br7+2.		/ bpt-trace trap
	trap; br7+3.		/ iot trap
	trap; br7+4.		/ power fail
	trap; br7+5.		/ emulator trap
	trap; br7+6.		/ system entry

. = 40^.
.globl	start, dump
1:	jmp	start
	jmp	dump

. = 50^.
.global	boots, bootldr
	jmp	boots
	jmp	bootldr

. = 60^.
	klin; br4
	klou; br4

. = 70^.
	pcin; br4
	pcout; br4

. = 100^.
	kwlp; br6
	kwlp; br6

. = 204^.
	lpin; br4

. = 224^.
	tmio; br5

. = 240^.
	trap; br7+7.		/ programmed interrupt
	trap; br7+8.		/ floating point
	trap; br7+9.		/ segmentation violation

. = 254^.
	dvio; br5

/ floating vectors
. = 300^.
	drou; br5+0.
	drin; br5+0.

. = 320^.
	dhin; br5+0
	dhou; br5+0

. = 330^.
	dmintr; br4+0.

//////////////////////////////////////////////////////
/		interface code to C
//////////////////////////////////////////////////////

.globl	call, trap

.globl	_klrint
klin:	jsr	r0,call; _klrint
.globl	_klxint
klou:	jsr	r0,call; _klxint

.globl	_clock
kwlp:	jsr	r0,call; _clock

.globl	_tmintr
tmio:	jsr	r0,call; _tmintr

.globl	_dhrint
dhin:	jsr	r0,call; _dhrint

.globl	_dhxint
dhou:	jsr	r0,call; _dhxint

.globl	_dvintr
dvio:	jsr	r0,call; _dvintr

.globl	_lpint
lpin:	jsr	r0,call; _lpint

.globl	_drrint
drin:	jsr	r0,call; _drrint
.globl	_drwint
drou:	jsr	r0,call; _drwint

.globl	_dmint
dmintr:	jsr	r0,call; _dmint

.globl	_pcrint, _pcpint
pcin:	jsr	r0,call; _pcrint
pcout:	jsr	r0,call; _pcpint
