/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */

# include <stdio.h>
# include <stdlib.h>
# include <sys/types.h>
# include <sys/socket.h>
# include <errno.h>
# include <termios.h>
# include <signal.h>
# include <fcntl.h>
# include <unistd.h>
# include <string.h>

# include "cdefs.h"
# include "util.h"
# include "tty.h"


RCSID("$Id: tty_tty.c,v 1.7 2000/03/04 08:04:04 hbb Exp $")


int		cs7;
struct termios	saved;
int		issaved;
int		fd;



volatile void
Exit(int ex)
{
	if(issaved)
		tcsetattr(fd, TCSANOW | TCSASOFT, &saved);
	exit(ex);
}

/*
 * fd 0 is socket to parent
 */
int
main(int argc, char *argv[])
{
	struct termios t;
	int	opt;

	while((opt = getopt(argc, argv, "7")) != EOF)
		switch(opt) {

		case '7':
			cs7 = 1;
			break;
		}
	argc -= optind;
	argv += optind;

	tty_init();

	if((fd = open(argv[0], 2)) < 0)
		return errno;
	if(setsid() < 0)
		return errno;
	if(fcntl(fd, F_SETFL, O_NONBLOCK))
		return errno;

	catch_signal(SIGPIPE, onsig);

	tcgetattr(fd, &t);
	saved = t;
	issaved = 1;
	cfmakeraw(&t);
	tcsetattr(fd, TCSANOW | TCSASOFT, &t);

	tty_loop(fd);

	Exit(0);
}

void
process_output()
{
	if(cs7)
		makecs7();
}

void
process_input()
{
}
