/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: xrealloc.c,v 1.3 1998/07/17 20:34:17 hbb Exp $
 */
# include <stdio.h>
# include <stdlib.h>
# include "begemot.h"

/*
 * Do a sensible thing:
 *	xrealloc(NULL, 0)	-> malloc(0) or malloc(1)
 *	xrealloc(NULL, s)	-> malloc(s)
 *	xrealloc(p,    0)	-> free(p), malloc(0) or malloc(1)
 *	xrealloc(p,    s)	-> realloc(p, s)
 * The Solaris man page says: 'when realloc returns NULL, the block pointed
 * to by ptr is left intact.' It's not clear whether this means, the block
 * is freed, but you can still read it or it is not touched is not clear.
 * That's why we have to check the boundary cases BEFORE calling realloc.
 */
void *
xrealloc(void *p, size_t s)
{
	void *ptr;

	if(p == NULL) {
		if((ptr=malloc(s)) == NULL && (s!=0 || (ptr=malloc(1)) == NULL))
			panic("out of memory: xrealloc(%lx, %lu)",
				(unsigned long)p, (unsigned long)s);
	} else if(s == 0) {
		free(p);
		if((ptr=malloc(s)) == NULL && (ptr=malloc(1)) == NULL)
			panic("out of memory: xrealloc(%lx, %lu)",
				(unsigned long)p, (unsigned long)s);
	} else {
		if((ptr = realloc(p, s)) == NULL)
			panic("out of memory: xrealloc(%lx, %lu)",
				(unsigned long)p, (unsigned long)s);
	}

	return ptr;
}
