MODULE example;

(****************************************************************************

  Note: This test program assumes a KW11-L clock.
        Users with a KW11-P clock must modify the DEVICE
        MODULE timing accordingly.

****************************************************************************)


DEVICE MODULE timing[6];
DEFINE delay;
  VAR csr[177546B]: bits;    { control/status reg. }
      tick: signal;

  PROCEDURE delay(n: integer);
    VAR left: integer;
  BEGIN
    left := n;
    REPEAT
      wait(tick); dec(left)
    UNTIL left<=0
  END delay;

  PROCESS clock[100B];      { KW11-L handler }
  BEGIN
    LOOP
      csr[6] := true;       { enable interrupt }
      doio;                 { wait for clock tick }
      csr[6] := false;
      WHILE awaited(tick) DO send(tick) END
    END
  END clock;

BEGIN { timing }
  clock
END timing;

DEVICE MODULE la30[4];
DEFINE putc;
  VAR	xstat[177564B]: bits;	{ DL-11 status register }
	xbuf[177566B]: integer;	{ DL-11 transmitter buffer}
	charwaiting, xmitavail: signal;

    PROCEDURE putc(c: char);
    BEGIN
      send(charwaiting);
      wait(xmitavail);
      xbuf := integer(c)
    END putc;

    PROCESS driver[64B];
    BEGIN
      LOOP
	wait(charwaiting);
	xstat[6] := true;
	doio;
	xstat[6] := false;
	{ now allow one process to service interrupt }
	send(xmitavail)
      END
   END driver;

BEGIN
  driver
END la30;


DEVICE MODULE kbd[4];
  DEFINE getc;
  VAR	kbstat[177560B]: bits;		{ keyboard status register }
	kbdata[177562B]: integer;	{ keyboard data register  }
	reader, kbready: signal;

  PROCEDURE getc(VAR c: char);
  BEGIN
      send(reader);
      wait(kbready);
      c := char(kbdata)
  END getc;

  PROCESS driver[60B];
  BEGIN
    LOOP
      wait(reader);
      kbstat[6] := true;
      doio;
      kbstat[6] := false;
      { allow one reader to get char }
      send(kbready)
    END
  END driver;


BEGIN
  driver
END kbd;


PROCESS testxmit;
BEGIN
  LOOP delay(50); putc('.') END
END testxmit;




PROCESS echo;
  VAR c: char;
BEGIN
  LOOP
    getc(c);
    putc(c)
  END
END echo;


BEGIN
  testxmit;
  echo
END example.
{
.bp
}
