MODULE example;

(****************************************************************************

  Note: This test program assumes a KW11-L clock.
        Users with a KW11-P clock must modify the DEVICE
        MODULE timing accordingly.

****************************************************************************)


DEVICE MODULE timing[6];
DEFINE delay;
  VAR csr[177546B]: bits;    { control/status reg. }
      tick: signal;

  PROCEDURE delay(n: integer);
    VAR left: integer;
  BEGIN
    left := n;
    REPEAT
      wait(tick); dec(left)
    UNTIL left<=0
  END delay;

  PROCESS clock[100B];      { KW11-L handler }
  BEGIN
    LOOP
      csr[6] := true;       { enable interrupt }
      doio;                 { wait for clock tick }
      csr[6] := false;
      WHILE awaited(tick) DO send(tick) END
    END
  END clock;

BEGIN { timing }
  clock
END timing;

DEVICE MODULE la30[4];
DEFINE ring;
USE delay;
  VAR xbuf[177566B]: integer; { DL-11 transmitter buffer}

  PROCEDURE ring;
  BEGIN
    xbuf := 7
  END ring;

END la30;


PROCESS ringing;
BEGIN
  LOOP delay(50); ring END
END ringing;


BEGIN
  ringing
END example.
{
.bp
}
