MODULE race;

CONST n = 2;    { no. of cars }

{ x-y positions of cars: x, y<[0:1024) }
VAR xpos, ypos: ARRAY 0:1 OF integer;

{ car cos, sin }
    carc, cars: ARRAY 0:1 OF integer;

{ car lap counts }
    lap: ARRAY 0:1 OF integer;

{ car speeds }
    vel: ARRAY 0:1 OF integer;

{ lap records }
    rec: ARRAY 0:1 OF
         RECORD min, sec, tic: integer END;

{ timer }
    min, sec: integer;


{ trig functions: theta < [0:255] }

MODULE trig;
DEFINE sin, cos, pi;

CONST s = (0,   3,   6,   9,   13,  16,  19,  22,
           25,  28,  31,  34,  37,  40,  43,  46,
           49,  52,  55,  58,  60,  63,  66,  68,
           71,  74,  76,  79,  81,  84,  86,  88,
           91,  93,  95,  97,  99,  101, 103, 105,
           106, 108, 110, 111, 113, 114, 116, 117,
           118, 119, 121, 122, 122, 123, 124, 125,
           126, 126, 127, 127, 127, 128, 128, 128,
           128);
      pi = 128;

PROCEDURE sin(theta: integer): integer;
BEGIN
  CASE theta DIV 64 OF
  0: BEGIN sin :=  s[theta+1]      END;
  1: BEGIN sin :=  s[pi-theta+1]   END;
  2: BEGIN sin := -s[theta-pi+1]   END;
  3: BEGIN sin := -s[2*pi-theta+1] END;
  4: BEGIN sin :=  s[theta-2*pi+1] END;
  5: BEGIN sin :=  s[3*pi-theta+1] END
  END
END sin;

PROCEDURE cos(theta: integer): integer;
BEGIN
  cos := sin(5*pi/2-theta)
END cos;

END trig;

DEVICE MODULE display[4];
DEFINE screen, ring, offroad, ch, cw, lapx;
USE xpos, ypos, carc, cars, lap, vel, rec, min, sec, n;

{ display file for cars }
VAR d: ARRAY 1:17 OF integer;

{ display file for track }
    t: RECORD
       head: ARRAY 1:4 OF integer;
       road: ARRAY 1:32, 1:74 OF char;
       tail: ARRAY 1:7 OF integer
       END;

{ display file for meters }
    m: RECORD
       head: ARRAY 1:4 OF integer;
       digs: ARRAY 1:36, 1:2 OF char;
       tail: integer
       END;
{ 
Sundry variables }
VAR x, y, p: integer;
    c: char;

{ Track picture }
CONST pic =
('************************************************************************',
'*******************               ***************             **********',
'****************                    ***********                 ********',
'**************        ******                                      ******',
'************       *************                    ********        ****',
'***********      *******************            ***************       **',
'***********     *************************************************     **',
'**********     ***************************************************    **',
'**********     ************************          *****************    **',
'*********     **********************               ***************    **',
'********     **********************       ***         ************    **',
'*******     **********************    *********        ***********    **',
'******      *********************    ************       **********    **',
'******     *********************     *************        ********    **',
'*****      *********************    ****************        ******    **',
'****      *********************     ******************       ****     **',
'***       *********************      *******************             ***',
'***       *********************       *******************            ***',
'**        *********************         ********************       *****',
'**        ***********************           ****************************',
'**        *************************              ***********************',
'**        *****************************                 ****************',
'**         **********************************                 **********',
'***         ***************************************                 ****',
'****         *********************************************            **',
'*****          ***************************************************    **',
'*******                                                               **',
'*********                                                            ***',
'***********                                                         ****',
'************************************************************************',
'******                    ******        ******                    ******',
'******  LAP SPEED RECORD  ******  TIME  ******  LAP SPEED RECORD  ******');

{ Numbers in ascii }
CONST num = ('00', '01', '02', '03', '04', '05', '06', '07', '08', '09',
             '10', '11', '12', '13', '14', '15', '16', '17', '18', '19',
             '20', '21', '22', '23', '24', '25', '26', '27', '28', '29',
             '30', '31', '32', '33', '34', '35', '36', '37', '38', '39',
             '40', '41', '42', '43', '44', '45', '46', '47', '48', '49',
             '50', '51', '52', '53', '54', '55', '56', '57', '58', '59',
             '60', '61', '62', '63', '64', '65', '66', '67', '68', '69',
             '70', '71', '72', '73', '74', '75', '76', '77', '78', '79',
             '80', '81', '82', '83', '84', '85', '86', '87', '88', '89',
             '90', '91', '92', '93', '94', '95', '96', '97', '98', '99');

{ Sundry constants }
CONST cw = 14;    { char width }
      ch = 24;    { char height }
      lapx = 388; { lap position }

PROCEDURE ring;
  VAR dsr[172002B]: integer;
BEGIN
  dsr := 1
END ring;

PROCEDURE offroad(x, y: integer): boolean;
BEGIN
  offroad := t.road[y,x]<>' '
END offroad;

PROCESS screen[320B];
  VAR dpc[172000B]: integer;
  VAR i, c, s: integer;
  PROCEDURE draw(x: integer);
  BEGIN
    IF x>=0
    THEN d[p] :=  x MOD 2000B+40000B
    ELSE d[p] := -x MOD 2000B+60000B
    END;
    inc(p)
  END draw;
  PROCEDURE dran(n: integer);
  BEGIN
    IF (n<0) OR (n>99)
    THEN m.digs[p] := '**'
    ELSE m.digs[p] := num[n+1]
    END; inc(p)
  END dran;
BEGIN { screen process }
  LOOP
    { draw the track }
    dpc := adr(t.head[1]); doio;
    { draw the cars }
    i := 0; 
    REPEAT
      d[2] := xpos[i];
      d[3] := ypos[i];
      c := carc[i]; s := cars[i];
      p := 5;
      draw(2*c);  draw(2*s);
      draw(-s);   draw(c);
      draw(-4*c); draw(-4*s);
      draw(2*s);  draw(-2*c);
      draw(4*c);  draw(4*s);
      draw(-s);   draw(c);
      dpc := adr(d[1]); doio;
      inc(i)
    UNTIL i=n;
    { draw meters }
    i := 0; p := 5;
    REPEAT
      dran(lap[i]); inc(p);
      IF vel[i]>99
      THEN dran(1); dran(vel[i]-100)
      ELSE dran(0); dran(vel[i])
      END; inc(p);
      WITH rec[i] DO
      dran(min); dran(sec); dran(tic)
      END; inc(p, 12);
      inc(i)
    UNTIL i=n;
    p := 18; dran(min); dran(sec);
    dpc := adr(m.head[1]); doio
  END
END screen;

BEGIN { display }
  d := (117324B, 0, 0, 110004B, 0, 0,
        0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 173400B);
  WITH t DO
    head := (116724B, 0, 31*ch, 100000B);
    y := 1;
    REPEAT
      x := 1;
      REPEAT
        c := pic[y,x];
        IF c='*' THEN c := 177C END;
        road[y,x] := c;
        inc(x)
      UNTIL x>72;
      road[y,73] := 15C;
      road[y,74] := 12C;
      inc(y)
    UNTIL y>32;
    tail := (117124B, lapx, 3*ch,
             110006B, 40000B, 3*ch, 173400B);
  END;
  WITH m DO
    head := (117324B, 0, ch, 100000B);
    x := 1;
    REPEAT digs[x] := '  '; inc(x) UNTIL x>36;
    tail := 173400B
  END
END display;


DEVICE MODULE timing[6];
DEFINE tick, delay, time, startclock, stopclock;
USE min, sec;

VAR tick: signal;
    time, hz: integer;
    on: boolean;

PROCEDURE startclock;
BEGIN
  time := 0; hz := 0;
  min := 0; sec := 0;
  on := true
END startclock;

PROCEDURE stopclock;
BEGIN
  on := false
END stopclock;

PROCEDURE delay(n: integer);
  VAR count: integer;
BEGIN
  count := n;
  REPEAT wait(tick); dec(count) UNTIL count<=0
END delay;

PROCESS clock[100B];
  VAR csr[177546B]: bits;
BEGIN
  LOOP
    csr[6] := true; doio;
    inc(time); send(tick); send(tick);
    IF on
    THEN inc(hz);
      IF hz=50
      THEN hz := 0; inc(sec);
        IF sec=60 THEN sec := 0; inc(min) END
      END
    END
  END
END clock;

BEGIN { timing }
  clock
END timing;


DEVICE MODULE control[4];
DEFINE left, right, fast, slow;

VAR str[160000B]: integer; { station register }
    csr[160002B]: bits;    { control/status register }
    xcr[160004B]: bits;    { executive register }
    swr[162040B]: bits;    { switch module }
    switch: bits;
    r, l, s, f: ARRAY 0:1 OF integer;

PROCEDURE left(i: integer): boolean;
BEGIN
  switch := swr;
  left := switch[l[i]]
END left;

PROCEDURE right(i: integer): boolean;
BEGIN
  right := switch[r[i]]
END right;

PROCEDURE fast(i: integer): boolean;
BEGIN
  fast := switch[f[i]]
END fast;

PROCEDURE slow(i: integer): boolean;
BEGIN
  slow := switch[s[i]]
END slow;

BEGIN
  r[0] := 0; r[1] := 8;
  l[0] := 1; l[1] := 9;
  s[0] := 2; s[1] := 10;
  f[0] := 3; f[1] := 11;
  csr := [];
  xcr := [0,7,8,14];
  str := 5
END control;

PROCESS car(i: integer);
  VAR a: integer;          { a < [0,twopi) }
      v: integer;          { v < [0,vmax) }
      x, y: integer;       { pos < [0,16K) }
      xnew, ynew: integer; { new positions }
      xchr, ychr: integer; { char position }
      c, s: integer;       { trig values < [-128,128] }
      lapt: integer;       { this lap time }
      laps: integer;       { lap start time }
      lapr: integer;       { current lap record }
      last: integer;       { time at last tick }
      delt: integer;       { ticks since last time }
  CONST sa = 64;           { a scale factor }
        sx = 16;           { x scale factor }
        sy = 16;           { y scale factor }
        sv = 512;          { v scale factor }
        da = 128;          { a increment }
        dv = 128;          { v increment }
        twopi = 2*pi*sa;
        vmax = 16383;
BEGIN
  LOOP
    x := lapx*sx; y := (7*ch/2+ch*i)*sy; last := 0;
    a := pi*sa; v := 0; lap[i] := 0; laps := 0;
    WITH rec[i] DO
      min := 0; sec := 0; tic := 0
    END;
    startclock;
    REPEAT
      delt := time-last; last := time;
      IF left(i)  THEN inc(a, da) END;
      IF right(i) THEN dec(a, da) END;
      a := a MOD twopi;
      IF fast(i)
      THEN inc(v, dv); IF v>vmax THEN v := vmax END
      END;
      IF slow(i)
      THEN dec(v, dv); IF v<0 THEN v := 0 END
      END;
      c := cos(a DIV sa);
      s := sin(a DIV sa);
      xnew := x; ynew := y;
      REPEAT
        inc(xnew, v DIV sv*c DIV 32);
        inc(ynew, v DIV sv*s DIV 32);
        dec(delt)
      UNTIL delt<=0;
      xchr := xnew DIV sx/cw+1;
      ychr := 32-ynew DIV sy/ch;
      IF offroad(xchr, ychr)
      THEN
        ring;
        delay(v DIV 256);
        v := 0
      ELSE
        IF (x>lapx*sx) AND (xnew<=lapx*sx) AND (y<7*ch*sy)
        THEN inc(lap[i]);
          lapt := time-laps;
          laps := time;
          IF (lap[i]=1) OR (lapt<lapr)
          THEN lapr := lapt;
            WITH rec[i] DO
            tic := lapr MOD 50*2;
            sec := lapr DIV 50 MOD 60;
            min := lapr DIV 3000
            END
          END
        END;
        x := xnew; y := ynew
      END;
      xpos[i] := x DIV sx;
      ypos[i] := y DIV sy;
      carc[i] := (c+16) DIV 32;
      cars[i] := (s+16) DIV 32;
      vel[i] := v DIV 128;
      wait(tick)
    UNTIL (lap[0]=6) OR (lap[1]=6) OR (min=10);
    stopclock;
    delay(250)
  END
END car;



BEGIN { race }
  car(0); car(1); screen
END race.
{
.bp
}
