#
/*
 *	mods by andrew hume 17/08/77
 *
 *	MODAH1:
 *
 *	to implement expressions in ifdef's.
 *
 *	debugged by ian johnstone 18/8 -> 22/8
 */
#define	MODAH1

/* C command */

# define SBSIZE 10000
# define MAXINC 10
char	sbf[SBSIZE];
char	*tmp0;
char	*tmp1;
char	*tmp2;
char	*tmp3;
char	*tmp4;
char	*tmp5;
char	*outfile;
# define CHSPACE 1000
char	ts[CHSPACE+50];
# define EXPSIZE 500
char	*tsa ts;
char	*tsp ts;
char	*av[50];
char	*clist[50];
char	*llist[50];
int	instring;
int	pflag;
int	sflag;
int	cflag;
int	eflag;
int	exflag;
int	oflag;
int	proflag;
int	depth;
int	*ibuf;
int	*ibufs[MAXINC];
int	ifno;
int	*obuf;
extern int	fout;
char	*lp;
char	*line;
char *predef;
char *sprefix "/usr/include";
int	lineno[MAXINC];
int	exfail;
struct symtab {
	char	name[8];
	char	*value;
} *symtab;
# define symsiz 400
struct symtab *defloc;
struct symtab *incloc;
struct symtab *eifloc;
struct symtab *ifdloc;
struct symtab *ifnloc;
struct symtab *unxloc;
struct symtab *lneloc;
struct symtab *prdloc;
int	trulvl;
int	flslvl;
char	*stringbuf;
char	*pass0 "/lib/c0";
char	*pass1 "/lib/c1";
char	*pass2 "/lib/c2";
char	*pref "/lib/crt0.o";

main(argc, argv)
char *argv[]; {
	char *t;
	char *savetsp;
	char *assource;
	int nc, nl, i, j, c, f20, nxo;
	int dexit();

	i = nc = nl = f20 = nxo = 0;
	while(++i < argc) {
		if(*argv[i] == '-') switch (argv[i][1]) {
			default:
				goto passa;
			case 'S':
				sflag++;
				cflag++;
				break;
			case 'o':
				if (++i < argc) {
					outfile = argv[i];
					if ((t=getsuf(outfile))=='c'||t=='o') {
						error("Would overwrite %s", outfile);
						exit(8);
					}
				}
				break;
			case 'O':
				oflag++;
				break;
			case 'p':
				proflag++;
				pref = "/lib/mcrt0.o";
				break;
			case 'E':
				exflag++;
			case 'P':
				pflag++;
			case 'c':
				cflag++;
				break;

			case 'f':
				pref = "/lib/fcrt0.o";
				pass0 = "/lib/fc0";
				pass1 = "/lib/fc1";
				break;

			case '2':
				if(argv[i][2] == '\0')
					pref = "/lib/crt2.o";
				else {
					pref = "/lib/crt20.o";
					f20 = 1;
				}
				break;
			case 'D':
				predef = argv[i]+2;
				break;
			case 'I':
				sprefix=argv[i]+2;
				break;
			case 't':
				if (argv[i][2]=='0')
					pass0 = "/sys/c/c0";
				if (argv[i][2]=='1')
					pass1 = "/sys/c/c1";
				if (argv[i][2]=='2')
					pass2 = "/sys/c/c2";
				break;

			case 'B':
				pass0 = "/sys/c/oc0";
				pass1 = "/sys/c/oc1";
				break;
		} else {
		passa:
			t = argv[i];
			if((c=getsuf(t))=='c' || c=='s'|| exflag) {
				clist[nc++] = t;
				t = setsuf(t, 'o');
			}
			if (nodup(llist, t)) {
				llist[nl++] = t;
				if (getsuf(t)=='o')
					nxo++;
			}
		}
	}
	if(nc==0)
		goto nocom;
	if (pflag==0) {
		tmp0 = copy("/tmp/ctm0a");
		while((c=open(tmp0, 0))>=0) {
			close(c);
			tmp0[9]++;
		}
		while((creat(tmp0, 0400))<0)
			tmp0[9]++;
	}
	if ((signal(2, 1) & 01) == 0)	/* interrupt */
		signal(2, dexit);
	if ((signal(15, 1) & 01) == 0)	/* terminate */
		signal(15, dexit);
	(tmp1 = copy(tmp0))[8] = '1';
	(tmp2 = copy(tmp0))[8] = '2';
	(tmp3 = copy(tmp0))[8] = '3';
	if (oflag)
		(tmp5 = copy(tmp0))[8] = '5';
	if (pflag==0)
		(tmp4 = copy(tmp0))[8] = '4';
	for (i=0; i<nc; i++) {
		if (nc>1)
			printf("%s:\n", clist[i]);
		if (getsuf(clist[i])=='s') {
			assource = clist[i];
			goto assemble;
		} else
			assource = tmp3;
		av[0] = "c0";
		if (pflag)
			tmp4 = setsuf(clist[i], 'i');
		savetsp = tsp;
		av[1] = expand(clist[i]);
		tsp = savetsp;
		if (pflag || exfail)
			continue;
		if (av[1] == 0) {
			cflag++;
			eflag++;
			continue;
		}
		av[2] = tmp1;
		av[3] = tmp2;
		if (proflag) {
			av[4] = "-P";
			av[5] = 0;
		} else
			av[4] = 0;
		if (callsys(pass0, av)) {
			cflag++;
			eflag++;
			continue;
		}
		av[0] = "c1";
		av[1] = tmp1;
		av[2] = tmp2;
		if (sflag)
			assource = tmp3 = setsuf(clist[i], 's');
		av[3] = tmp3;
		if (oflag)
			av[3] = tmp5;
		av[4] = 0;
		if(callsys(pass1, av)) {
			cflag++;
			eflag++;
			continue;
		}
		if (oflag) {
			av[0] = "c2";
			av[1] = tmp5;
			av[2] = tmp3;
			av[3] = 0;
			if (callsys(pass2, av)) {
				cflag++;
				eflag++;
				continue;
			}
			unlink(tmp5);
		}
		if (sflag)
			continue;
	assemble:
		av[0] = "as";
		av[1] = "-u";
		av[2] = "-o";
		av[3] = setsuf(clist[i], 'o');
		av[4] = assource;
		av[5] = 0;
		cunlink(tmp1);
		cunlink(tmp2);
		cunlink(tmp4);
		if (callsys("/bin/as", av) > 1) {
			cflag++;
			eflag++;
			continue;
		}
	}
nocom:
	if (cflag==0 && nl!=0) {
		i = 0;
		av[0] = "ld";
		av[1] = "-X";
		av[2] = pref;
		j = 3;
		if (outfile) {
			av[j++] = "-o";
			av[j++] = outfile;
		}
		while(i<nl)
			av[j++] = llist[i++];
		if(f20)
			av[j++] = "-l2";
		else {
			av[j++] = "-lc";
			av[j++] = "-l";
		}
		av[j++] = 0;
		eflag =| callsys("/bin/ld", av);
		if (nc==1 && nxo==1 && eflag==0)
			cunlink(setsuf(clist[0], 'o'));
	}
	dexit();
}

dexit()
{
	if (!pflag) {
		cunlink(tmp1);
		cunlink(tmp2);
		if (sflag==0)
			cunlink(tmp3);
		cunlink(tmp4);
		cunlink(tmp5);
		cunlink(tmp0);
	}
	exit(eflag);
}

char *fnames[MAXINC];
# define LINELEN 500
expand(file)
char *file;
{
	int ob[259];
	struct symtab stab[symsiz];
	char ln[LINELEN];
	register int c;
	register char *rlp;

	exfail = 0;
	ifno=0;
	if (ibufs[0]==0)
		ibufs[0] = sbrk(518);
	ibuf=ibufs[0];
	fnames[ifno] = file;
	if (fopen(file, ibuf)<0) {
		error("No file %s", file);
		return(file);
		}
	obuf = ob;
	symtab = stab;
	for (c=0; c<symsiz; c++) {
		stab[c].name[0] = '\0';
		stab[c].value = 0;
	}
	insym(&defloc, "define");
	insym(&incloc, "include");
	insym(&eifloc, "endif");
	insym(&ifdloc, "ifdef");
	insym(&ifnloc, "ifndef");
	insym(&unxloc, "unix");
	insym(&lneloc, "line");
	if (predef)
	insym(&prdloc, predef);
	stringbuf = sbf;
	trulvl = 0;
	flslvl = 0;
	line  = ln;
	lineno[0] = 1;
	if (exflag==0)
		{
		if (fcreat(tmp4, obuf) < 0) {
			printf("Can't creat %s\n", tmp4);
			dexit();
			}
	}
	else
		{
		obuf = &fout;
		fout = dup(1);
		}
	puts("# 1 \"");
	puts(file);
	puts("\"\n");
	while(getline()) {
		if (ln[0] != '#' && flslvl==0)
			for (rlp = line; c = *rlp++;)
				putc(c, obuf);
		putc('\n', obuf);
	}
	for(rlp=line; c = *rlp++;)
			putc(c,obuf);
#ifdef	MODAH1
	if( flslvl || trulvl ) errexit("missing endif");
#endif
	fflush(obuf);
	if (obuf != &fout)
	close(obuf[0]);
	close(ibuf[0]);
	return(tmp4);
}

getline()
{
	register int c, sc, state;
	struct symtab *np;
	char *namep, *filname, *cp;
#ifdef MODAH1
	int ifval[40];
	char ifop[40];
	int *ifv;
	char *ifo;

	ifv = ifval;
	*(ifo = ifop) = 0;
#endif

	lp = line;
	*lp = '\0';
	state = 0;
	if ((c=getch()) == '#')
		state = 1;
	while (c!='\n' && c!='\0') {
		if ('a'<=c && c<='z' || 'A'<=c && c<='Z' || c=='_') {
			namep = lp;
			sch(c);
			while ('a'<=(c=getch()) && c<='z'
			      ||'A'<=c && c<='Z'
			      ||'0'<=c && c<='9' 
			      ||c=='_')
				sch(c);
			sch('\0');
			lp--;
			if (state>3) {
#ifndef MODAH1
				if (flslvl==0 &&(state+!lookup(namep,-1)->name[0])==5)
					trulvl++;
				else
					flslvl++;
		out:
				while (c!='\n' && c!= '\0')
					c = getch();
				return(c);
#endif
#ifdef MODAH1
				*++ifv = lookup(namep,-1)->name[0] ? 1 : 0 ;
				if(*ifo == '!') {
					*ifv = !*ifv;
					ifo--;
				}
				if(*ifo == '&') {
					ifv--;	*ifv =& ifv[1];
					ifo--;
				}
				continue;
#endif
			}
			if (state==3) /* include */
				if (*namep != '"' && *namep != '<')
					{
					error("Bad include syntax", 0);
					state=1;
					}
			if (state!=2 || flslvl==0)
				{
				ungetc(c);
				np = lookup(namep, state);
				c = getch();
				}
			if (state==1) {
				if (np==defloc)
					state = 2;
				else if (np==incloc)
					state = 3;
				else if (np==ifnloc)
					state = 4;
				else if (np==ifdloc)
					state = 5;
				else if (np==eifloc) {
					if (flslvl)
						--flslvl;
					else if (trulvl)
						--trulvl;
					else errback("If-less endif");
					goto out;
				}
				else if (np==lneloc)
					{
					puts("# ");
					lp=line;
					for(; c !='\n' && c != '\0'; c=getch())
						if (!pflag || exflag)
							sch(c);
					sch('\0');
					return(c);
					}
				else {
					errback("Undefined control");
#ifdef MODAH1
			out:
#endif
					while (c!='\n' && c!='\0')
						c = getch();
					return(c);
				}
			} else if (state==2) {
				if (flslvl)
					goto out;
				np->value = stringbuf;
				if (c != '\n' && c != 0)
					{
					savch(c);
					while ((c=getch())!='\n' && c!='\0')
						savch(c);
					}
				savch('\0');
				return(1);
			}
			continue;
		} else if ((sc=c) == '\'' || sc== '"' || (state==3 && sc== '<')) {
			sch(sc);
			filname = lp;
			if (sc== '<')
				{
				sc= '>';
				for(cp=sprefix; *cp; cp++)
					*lp++ = *cp;
				*lp++= '/';
				}
			instring++;
			while ((c=getch())!=sc && c!='\n' && c!='\0') {
				sch(c);
				if (c=='\\')
					sch(getch());
			}
			instring = 0;
			if (flslvl)
				goto out;
			if (state==3) {
				if (flslvl)
					goto out;
				*lp = '\0';
				while ((c=getch())!='\n' && c!='\0');
				if (ifno+1 >=MAXINC)
					error("Unreasonable include nesting",0);
				if(ibufs[++ifno]==0)
					ibufs[ifno]=sbrk(518);
				if (fopen(filname, ibufs[ifno])<0) {
					ifno--;
					errback("Missing file %s", filname);
					dexit();
				} else
					ibuf = ibufs[ifno];
				puts("\n# 1 \"");
				puts(filname);
				puts("\"");
				lineno[ifno]=1;
				fnames[ifno] = copy(filname);
				return(c);
			}
		}
#ifdef MODAH1
			else if(state > 3) switch(c)
				{
				case '(':
				case '|':
				case '&':
				case '!':
						*++ifo = c;
						break;
				case ' ':
				case '\t':
						break;
				case ')':
						for(;*ifo == '|'; ifo--) {
							ifv--;	*ifv =| ifv[1];
						}
						if(*ifo == '(')
							ifo--;
						else errexit("'(' expected");
						if(*ifo == '!') {
							*ifv = !*ifv;
							ifo--;
						}
						if(*ifo == '&') {
							ifv--;	*ifv =& ifv[1];
							ifo--;
						}
						break;
				default:

						errexit("illegal char '%o' oct",c);
						break;
				}
#endif
		sch(c);
		c = getch();
	}
	sch('\0');
#ifdef MODAH1
	for(;*ifo == '|'; ifo--) {
		ifv--;	*ifv =| ifv[1];
	}
	if(state == 4 || state == 5)
	if( flslvl==0 & ((state +  !(*ifv--))==5) )
		trulvl++;
	else
		flslvl++;
	if((ifv != ifval) || (ifo != ifop))
		{
		errexit("if%cdef expression error",state==4 ? 'n' : 0);
		}
	state = 0;
#endif
	if (state>1)
		errback("Control syntax");
	return(c);
}
#ifdef MODAH1
errexit(s,x)
{
	lineno[ifno]--;
	error(s,x);
	dexit();
}
#endif

insym(sp, namep)
struct symtab **sp;
char *namep;
{
	register struct symtab *np;

	*sp = np = lookup(namep, 1);
	np->value = np->name;
}

error(s, x)
{
	int olfout;
	olfout = fout;
	flush();
	if (exflag)
		fout=2;
	if (fnames[ifno])
		printf("%s: %d: ", fnames[ifno], lineno[ifno]);
	printf(s, x);
	putchar('\n');
	flush();
	fout=olfout;
	exfail++;
	cflag++;
	eflag++;
}
errback(s,x)
{
	lineno[ifno]--;
	error(s,x);
	lineno[ifno]++;
}

sch(c)
{
	register char *rlp;

	rlp = lp;
	if (rlp==line+LINELEN-2)
		error("Line overflow");
	*rlp++ = c;
	if (rlp>line+LINELEN-1)
		rlp = line+LINELEN-1;
	lp = rlp;
}

savch(c)
{
	*stringbuf++ = c;
	if (stringbuf-sbf < SBSIZE)
		return;
	error("Too much defining");
	dexit();
}

getch()
{
	register int c;

loop:
	if ((c=getc1())=='/' && !instring) {
		if ((c=getc1())!='*')
			{
			ungetc(c);
			return('/');
			}
		for(;;) {
			c = getc1();
		cloop:
			switch (c) {

			case '\0':
				return('\0');

			case '*':
				if ((c=getc1())=='/')
					goto loop;
				goto cloop;

			case '\n':
				putc('\n', obuf);
				continue;
			}
		}
	}
	return(c);
}
char pushbuff[EXPSIZE];
char *pushp pushbuff;
ungetc(c)
	{
	*++pushp = c;
	if (pushp>pushbuff+EXPSIZE) {
		error("too much backup");
		dexit(8);
		}
	}

getc1()
{
	register c;

	if (*pushp !=0)
		return(*pushp--);
	depth=0;
	if ((c = getc(ibuf)) < 0 && ifno>0) {
		close(ibuf[0]);
		ibuf = ibufs[--ifno];
		puts("\n# ");
		puts(itoa(lineno[ifno]));
		puts(" \"");
		puts(fnames[ifno]);
		puts("\"\n");
		c = getc1();
		if (c=='\n') lineno[ifno]--;
	}
	if (c<0)
		return(0);
	if (c=='\n' )
		lineno[ifno]++;
	return(c);
}

lookup(namep, enterf)
char *namep;
{
	register char *np, *snp;
	register struct symtab *sp;
	int i, c, around;
	np = namep;
	around = i = 0;
	while (c = *np++)
		i =+ c;
	i =% symsiz;
	sp = &symtab[i];
	while (sp->name[0]) {
		snp = sp;
		np = namep;
		while (*snp++ == *np)
			if (*np++ == '\0' || np==namep+8) {
				if (!enterf)
					subst(namep, sp);
				return(sp);
			}
		if (++sp >= &symtab[symsiz])
			if (around++)
				{
				error("too many defines");
				dexit();
				}
			else
			sp = symtab;
	}
	if (enterf>0) {
		snp = namep;
		for (np = &sp->name[0]; np < &sp->name[8];)
			if (*np++ = *snp)
				snp++;
	}
	return(sp);
}
char revbuff[200], *bp;
backsch(c)
	{
	if (bp-revbuff > 200)
		error("Excessive define looping", bp--);
	*bp++ = c;
	}

subst(np, sp)
char *np;
struct symtab *sp;
{
	register char *vp;
	int macflg;

	lp = np;
	bp = revbuff;
	if (depth++>100)
		{
		error("define recursion loop\n");
		return;
		}
	if ((vp = sp->value) == 0)
		return;
	macflg= (*vp == '(');
	/* arrange that define unix unix still
	has no effect, avoiding rescanning */
	while (blank(*vp))
		vp++;
	if (streq(sp->name,vp))
		{
		while (*vp)
			sch(*vp++);
		return;
		}
	if (macflg)
		expdef(vp);
	else
		while (*vp)
			backsch(*vp++);
	while (bp>revbuff)
		ungetc(*--bp);
}

getsuf(as)
char as[];
{
	register int c;
	register char *s;
	register int t;

	s = as;
	c = 0;
	while(t = *s++)
		if (t=='/')
			c = 0;
		else
			c++;
	s =- 3;
	if (c<=14 && c>2 && *s++=='.')
		return(*s);
	return(0);
}

setsuf(as, ch)
char as[];
{
	register char *s, *s1;

	s = s1 = copy(as);
	while(*s)
		if (*s++ == '/')
			s1 = s;
	s[-1] = ch;
	return(s1);
}

callsys(f, v)
char f[], *v[]; {
	int t, status;

	if ((t=fork())==0) {
		execv(f, v);
		printf("Can't find %s\n", f);
		exit(100);
	} else
		if (t == -1) {
			printf("Try again\n");
			return(100);
		}
	while(t!=wait(&status));
	if ((t=(status&0377)) != 0 && t!=14) {
		if (t!=2)		/* interrupt */
			{
			printf("Fatal error in %s\n", f);
			eflag = 8;
			}
		dexit();
	}
	return((status>>8) & 0377);
}

copy(as)
char as[];
{
	register char *otsp, *s;
	int i;

	otsp = tsp;
	s = as;
	while(*tsp++ = *s++);
	if (tsp >tsa+CHSPACE)
		{
		tsp = tsa = i = alloc(CHSPACE+50);
		if (i== -1){
			error("no space for file names");
			dexit(8);
			}
		}
	return(otsp);
}

nodup(l, os)
char **l, *os;
{
	register char *t, *s;
	register int c;

	s = os;
	if (getsuf(s) != 'o')
		return(1);
	while(t = *l++) {
		while(c = *s++)
			if (c != *t++)
				break;
		if (*t=='\0' && c=='\0')
			return(0);
		s = os;
	}
	return(1);
}

cunlink(f)
char *f;
{
	if (f==0)
		return(0);
	return(unlink(f));
}
expdef(proto)
  char *proto;
{
char buffer[EXPSIZE], *parg[20], *pval[20], name[20], *cspace, *wp;
char protcop[EXPSIZE], *pr;
int narg, k, c;
pr = protcop;
while (*pr++ = *proto++);
if (pr>protcop+EXPSIZE){
	error("define prototype too big");
	dexit(8);
	}
proto= protcop;
for (narg=0; (parg[narg] = token(&proto)) != 0; narg++)
	;
/* now scan input */
cspace = buffer;
while ((c=getch()) == ' ');
if (c != '(')
	{
	error("defined function requires arguments");
	return;
	}
ungetc(c);
for(k=0; pval[k] = coptok(&cspace, buffer+EXPSIZE); k++);
if (k!=narg)
 {
  error("define argument mismatch");
  return;
 }
while (c= *proto++)
   {
   if (!letter(c))
      backsch(c);
   else
      {
      wp = name;
      *wp++ = c;
      while (letnum(*proto))
        *wp++ = *proto++;
      *wp = 0;
      for (k=0; k<narg; k++)
      if(streq(name,parg[k]))
        break;
      wp = k <narg ? pval[k] : name;
      while (*wp) backsch(*wp++);
      }
   }
}
token(cpp) char **cpp;
{
char *val;
int stc;
stc = **cpp;
*(*cpp)++ = '\0';
if (stc==')') return(0);
while (**cpp == ' ') (*cpp)++;
for (val = *cpp; (stc= **cpp) != ',' && stc!= ')'; (*cpp)++)
  {
  if (!letnum(stc) || (val == *cpp && !letter(stc)))
    {
    error("define prototype argument error");
    return(0);
    }
  }
return(val);
}
coptok (cpp, clim) char **cpp, *clim;
{
	char *val;
	int stc, stop,paren;
paren = stop = 0;
val = *cpp;
if (getch() == ')')
	return(0);
while (((stc = getch()) != ',' && stc != ')' ) || paren > 0 || stop >0)
	{
	if (stc == '\0')
		{
		error("non terminated macro call");
		val = 0;
		break;
		}
	if (stop == 0 && (stc == '"' || stc == '\''))
		stop = stc;
	else if (stc==stop)
		stop=0;
	if ( stc == '\\')
		{
		stc = getch();
		if (stop>0 || (stc != ',' && stc != '\\'))
			*(*cpp)++ = '\\';
		*(*cpp)++ = stc;
		}
	else
		{
		*(*cpp)++ = stc;
		if (stop==0)
			{
			if (stc == '(')
				paren++;
			if (stc == ')')
				paren--;
			}
		}
	if (*cpp >= clim)
		{
		error("define argument too long",0);
		dexit(8);
		}
	}
*(*cpp)++ = 0;
ungetc(stc);
return(val);
}
letter(c)
{
if ((c >= 'a' && c <= 'z') ||
    (c >= 'A' && c <= 'Z') ||
    (c == '_'))
    return (1);
else
    return(0);
}
letnum(c)
{
if (letter(c) || (c >= '0' && c <= '9'))
  return(1);
else
  return(0);
}
streq(s,t) char *s, *t;
{
int c;
while ( (c= *s++) == *t++)
   if (c==0) return(1);
return(0);
}
puts(s)
	char *s;
{
int c;
if (pflag && !exflag) return;
while (c= *s++)
	putc(c, obuf);
}
itoa(n)
{
static char sb[20];
char *sp;
sp = sb+19;
*sp=0;
if (n<=0)
	*--sp = '0';
else
while (n)
	{
	*--sp = '0'+ n%10;
	n=n/10;
	}
return(sp);
}
blank(c)
{
return(c==' ' || c== '\t');
}
