#

	/*
	 * GRAPHIC WONDER DEPENDENT ROUTINES
	 */

#include "../gpac.h"
#include "../error_codes.h"
#include "gw.h"


Ginit(df_size, ink_size, num_segs, font)
	int df_size;
	int ink_size;
	int num_segs;
	char *font;
	{
	int arg[3];
	register fontfd;
	int size;
	register i;
	register char *file;
	char cbuf[32];

	file = "/dev/gw0";
	for(i = 0; i < NGW; i++)
		{
		file[7] = '0'+i;
		if((Gdev_file = open(file, read_write)) >= 0)
			break;
		}
	if(Gdev_file < 0)
		return(Gerror(INIT_ERR));
	arg[0] = GRAB;
	Gfil_size = arg[2] = (df_size+1023)/1024;
	Gfil_size =* 1024;
	if(Gstty(Gdev_file, arg) < 0) 
		{
		perror("gw");
		return(Gerror(INIT_ERR));
		}
	arg[0] = MAP;
	if(Gstty(Gdev_file, arg) < 0)
		{
		perror("gw");
		return(Gerror(INIT_ERR));
		}
	/*
	 * set up font allocate lower core for this
	 */
	if((fontfd = open(stringf(cbuf, "/usr/font/%s", font), read_it)) < 0)
		{
		Gerror(OPEN_ERR, "init", font);
		perror("");
		exit();
		}
	seek(fontfd, 4, 0);
	read(fontfd, &size, 2);
	if((size>>1) >= df_size-ink_size)
		{
		Gerror(FONT_SIZEERR, size>>1);
		exit();
		}
	seek(fontfd, 020, 0);
	read(fontfd, 0, size);
	Gfil_start = size;
	Gfil_size =- (size>>1);
	arg[0] = dtabr;
	arg[2] = 0;
	Gstty(Gdev_file, arg);
	if(Ginit_tab(ink_size) < 0)
		ERROR_RETURN;
	GOOD_RETURN;
	}


Gopenseg()
	{
	register strt;

	if((strt = Gget_blk()) == ERROR) 
		ERROR_RETURN;
	Gcodep = Gblkptr = strt+2;
	Gblksize = *(Gcodep-1)-3;
	Ginsert_code(gw_xqt | (strt+6));
	Ginsert_code(gw_jump);
	Gcode_mode = CONTROL;
	Gq_ptr = 0;
	return(strt+2);
	}


Gcloseseg()
	{
	register i;

	if(Gcode_mode == CHARACTER)
		if(Gmake_room(1) != ERROR)
			Ginsert_code(gw_unload_cmode);
		   else
			*(Gcodep-1) = gw_unload_cmode;
	Ginsert_code(gw_term);
	i = Gfil_start;
	*(Gblkptr+1) =| i;
	*(Gcur_start) = Gblkptr+1;	/*  Unposted  */
	Gtrimblk(Gblkptr-1, *(Gblkptr-1)-Gblksize-3);
	return(Gblkptr+1);
	}

Gset_nxtblk(jump_addr, addr)
	int *jump_addr;
	int addr;
	{

	*jump_addr = gw_jump | addr;
	}


Gnxt_seg(jump_addr)
	int *jump_addr;
	{

	return(*jump_addr);
	}


Gnxt_blk(seg_start)
	int *seg_start;
	{

	return(*(seg_start+1));
	}


Gnewblk()
	{
	register int new_blk, i;

	if((new_blk = Gget_blk()) == ERROR) 
		ERROR_RETURN;
	Ginsert_code(gw_term);
	*(Gblkptr+1) =| new_blk+2;	/*  two to get over boundary tags  */
	Gcodep = Gblkptr = new_blk+2;
	Gblksize = *(Gcodep-1)-3;	/*  two for boundary tags and one for term  */
	Ginsert_code(gw_xqt | (new_blk+6));
	Ginsert_code(gw_jump);
	GOOD_RETURN;
	}


Gappendseg(this_segp, next_segp)
	struct segment *this_segp, *next_segp;
	{
	register i;
	register *ptr;

	if(Gcode_mode == CHARACTER)
		if(Gmake_room(1) != ERROR)
			Ginsert_code(gw_unload_cmode);
		   else
			*(Gcodep-1) = gw_unload_cmode;
	Ginsert_code(gw_term);
	i = next_segp->start_address;
	*(Gblkptr+1) =| i;
	ptr = Gnxt_seg(this_segp->start_address);
	if(ptr == this_segp->end_address)
		Gset_nxtblk(this_segp->start_address, Gblkptr+1);
	Gset_nxtblk(this_segp->end_address, Gcur_start);
	Gtrimblk(Gblkptr-1, *(Gblkptr-1)-Gblksize-3);
	return(Gblkptr+1);
	}


Gstart()
	{
	register i;
	int arg[3];

	*(Gblkptr) = gw_jms | ((i = Gblkptr)+4);
	arg[0] = start;
	arg[2] = Gfil_start;
	if(Gstty(Gdev_file, arg) < 0)
		{
		perror("gw start");
		abort();
		}
	}


Gdummy_seg()
	{
	register i;
	register j;

	i = Gcodep;
	Gmake_room(22);
	Ginsert_code(0);
	Ginsert_code(gw_waittil | 2);
	Ginsert_code(gw_setstate);
	Ginsert_code(gw_state);
	Ginsert_code(load_long_format);
	Ginsert_code(gw_ioff);
	Ginsert(gw_xqt | (j = Gcodep+9));
	Ginsert_code(gw_ion);
	Ginsert_code(gw_setxy);
	Ginsert_code(0);
	Ginsert_code(0);
	Ginsert_code(gw_stpsnc);
	Gtabinkptr = Gcodep;
	Ginsert_code(gw_nop);
	Ginsert_code(gw_waittil | 4);
	Ginsert_code(i);		/*  return from jms  */
	Ginsert_code(02000);
	Ginsert_code(0);
	Ginsert_code(0);
	Ginsert_code(02000);
	Ginsert_code(0176000);
	Ginsert_code(0);
	Ginsert_code(0);
	Ginsert_code(0176000);
	}


Gfinish()
	{

	close(Gdev_file);
	Gtabclose();
	}


Ggencode(n)
	int n;
	{

	register struct code_queue *p;
	register dx, dy;
	int i;

	p = Gcode_queue;
	Gnum_generated = 0;
	while(Gnum_generated < n)
		{
		if(p->c_type == INTENSITY)
			{
			if(Gmake_room(1) != ERROR)
				Ginsert_code(gw_int_load | (p->xpos&017));
			Gnum_generated++; p++;
			continue;
			}
		switch(Gcode_mode)
			{
		   case CHARACTER :
			if(Gmake_room(1) != ERROR)
				Ginsert_code(gw_unload_cmode);
			Gcode_mode = CONTROL;
		   case CONTROL :
			if(p->c_type&(BPOINT|VPOINT|BVECTOR))
				if(Gmake_room(3) != ERROR)
					{
					Ginsert_code(gw_setxy);
					Ginsert_code(p->xpos-512);
					Ginsert_code(p->ypos-512);
					Gx_abs = p->xpos;
					Gy_abs = p->ypos;
					Gnum_generated++; p++;
					}
			if((i = Gnext(1)) == long_vect)
				Genter_mode(long_vect);
			   else
				if(Gnext(2) < med_vect)
					Genter_mode(short_vect);
				   else
					if(i != dummy_big_number)
						Genter_mode(med_vect);
			break;
		   case short_vect :
			if((Gcode_mode = Gnext(1)) == short_vect)
				{
				Gbyte_ptr = 0;
				do
					{
					if(p->c_type&(VPOINT|BPOINT|BVECTOR))
						{
						if(Gbyte_ptr%2)
							Gbyte_insert(0);  /*  kludge to ensure xy pair is with iof1  */
						Gbyte_insert(gw_sviof1);	
						}
					Ggen_sv(p);
					Gnum_generated++;  p++;
					}  while(Gnext(1) == short_vect);
				for(i = 0; i < Gbyte_ptr; i =+ 2)
					if(Gmake_room(1) != ERROR)
						Ginsert_code((Gbyte_queue[i] & 0377)  | (Gbyte_queue[i+1]<<8));

				}
			   else
				Genter_mode(Gcode_mode);
			break;
		   case med_vect :
			if(Gnext(1) == long_vect)
				Genter_mode(long_vect);
			   else
				if(Gnext(4) <= 4*short_vect)
					Genter_mode(short_vect);
				   else
					{
					if(p->c_type != INTENSITY)
					   do
						{
						if(p->c_type&(VPOINT|BPOINT|BVECTOR))
							if(Gmake_room(2) != ERROR)	/* must have xy pair before a terminate */
								Ginsert_code(gw_iof1);
						if(Gmake_room(1) != ERROR)
							Ggen_mv(p);
						Gnum_generated++;  p++;
						}  while(Gnext(1) == med_vect);
					}
			break;
		   case long_vect :
			if(Gnext(2) <= 2*short_vect)
				Genter_mode(short_vect);
			   else
				if(Gnext(3) <= 3*med_vect)
					Genter_mode(med_vect);
				   else
					{
					if(p->c_type != INTENSITY)
					   do
						{
						if(p->c_type&(VPOINT|BPOINT|BVECTOR))
							if(Gmake_room(3) != ERROR)
								Ginsert_code(gw_iof1);
						if(Gmake_room(2) != ERROR)
							Ggen_lv(p);
						Gnum_generated++;  p++;
						}  while(Gnext(1) == long_vect);
					}
			}  /*  end of switch  */
		}
	return(Gnum_generated);
	}


Genter_mode(new_mode)
	{
	register code;

	if(Gmake_room(1) != ERROR)
		{
		switch(new_mode)
			{
			   case long_vect :
				code = load_long_format;
				break;
			   case med_vect :
				code = load_med_format;
				break;
			   case short_vect :
				code = load_short_format;
			}
		Ginsert_code(code);
		}
	Gcode_mode = new_mode;
	}


Gnext(n)
	int n;
	{
	register i, dx, dy;
	int result, dum_x_abs, dum_y_abs;

	dum_x_abs = Gx_abs;  dum_y_abs = Gy_abs;
	result = 0;
	for(i = Gnum_generated; i < Gnum_generated+n; i++)
		if(i >= Gq_ptr || Gcode_queue[i].c_type == INTENSITY)
			return(dummy_big_number);
		   else
			{
			dx = Gcode_queue[i].xpos-dum_x_abs;
			dy = Gcode_queue[i].ypos-dum_y_abs;
			if((dx < 010 && dx > -010) && (dy < 010 && dy > -010))
				result =+ short_vect;
			   else
				if((dx < 0200 && dx > -0200) && (dy < 0200 && dy > -0200))
					result =+ med_vect;
				   else
					result =+ long_vect;
			dum_x_abs = Gcode_queue[i].xpos;
			dum_y_abs = Gcode_queue[i].ypos;
			}
	return(result);
	}


Gbyte_insert(value)
	char value;
	{

	Gbyte_queue[Gbyte_ptr++] = value;
	Gbyte_queue[Gbyte_ptr] = NULL;
	}


Ggen_sv(p)
	struct code_queue *p;
	{
	register dx, dy;

	dx = (p->xpos - Gx_abs) & 017;
	dy = (p->ypos - Gy_abs) & 017;
	Gbyte_insert((dx<<4) | dy);
	Gx_abs = p->xpos;
	Gy_abs = p->ypos;
	}


Ggen_mv(p)
	struct code_queue *p;
	{
	register dx, dy;

	dx = (p->xpos-Gx_abs) & 0377;
	dy = (p->ypos-Gy_abs) & 0377;
	Ginsert_code((dx<<8) | dy);
	Gx_abs = p->xpos;
	Gy_abs = p->ypos;
	}


Ggen_lv(p)
	struct code_queue *p;
	{
	register dx, dy;

	dx = (p->xpos-Gx_abs) & 037777;
	dy = (p->ypos-Gy_abs) & 037777;
	dx = (dx<<2)>>2;
	dy = (dy<<2)>>2;
	Ginsert_code(dy);
	Ginsert_code(dx);
	Gx_abs = p->xpos;
	Gy_abs = p->ypos;
	}


Gsidein()
	{

	}


Gwaitstop()
	{
	int arg[3];

	arg[0] = waittilcomm;
	arg[2] = 2;
	if(Gstty(Gdev_file, arg) < 0)
		perror("wait error");
	}


Gsave_seg()
	{

	}


Gclosefill()
	{

	}


#define EINTR 4
extern int errno;


Gstty(file, arg)
	int file;
	int arg[];
	{
	register ret;

	while((ret = stty(file, arg)) < 0 && errno == EINTR)
		;
	return(ret);
	}
