#

	/*
	 *	GPAC TABLET GW ROUTINES
	 */


#include "../gpac.h"
#include "../error_codes.h"
#include "tab.h"

cursor(cnum, n)
	int cnum;
	int n;
	{
	int arg[3], rest[5];
	register i, cn, val;

	valid_segment;
	TAB_OPEN(cursor);
	i = n;
	if(Gseg_table[i].start_address)
		{
		if((cn = cnum) < SETEVENTCURSOR || cn > SETINKCURSOR)
			return(Gerror(BAD_CURSOR, cn));
		arg[0] = cn == SETEVENTCURSOR ? ECURSOR : ICURSOR;
		arg[2] = rest;
		rest[0] = rest[2] = Gseg_table[i].start_address;
		i = Gseg_table[i].end_address;
		rest[1] = i | GW_JUMP;
		rest[3] = (rest[0]+4) | GW_XQT;
		rest[4] = rest[0]+6;	/*  Magic 6  */
		if(Gstty(Gtablet.fd, arg) < 0)
			perror("tablet");
		}
	  else
		return(Gerror(NOEXIST_ERR, "cursor", i));
	GOOD_RETURN;
	}
