#

	/*
	 *	GPAC TABLET GW ROUTINES
	 */


#include "../gpac.h"
#include "../error_codes.h"
#include "tab.h"

activate(evnt_type, arg)
	int evnt_type, arg;
	{
	int argument[3], rest[7];
	register i, mask;

	TAB_OPEN(activate);
	argument[0] = ACTIVATE;
	switch(evnt_type)
		{
		case INKING :
			argument[2] = rest;
			rest[0] = GW;
			if(Gtablet.buf_addr == 0)
				{
				Gtablet.buf_addr = Gget_blk();
				if(*(Gtablet.buf_addr)-2 > Gtablet.desired_ink_size)
					{
					Gtrimblk(Gtablet.buf_addr, Gtablet.desired_ink_size);
					Gtablet.curr_ink_size = Gtablet.desired_ink_size;
					}
				   else
					Gtablet.curr_ink_size = *Gtablet.buf_addr - 2;
				}
			rest[1] = Gtablet.buf_addr+1;
			rest[2] = Gtablet.curr_ink_size*2;
			clearink();
			*Gtabinkptr = GW_XQT | rest[1];
			rest[3] = Ginkmode.sample_interval;
			rest[4] = Ginkmode.mode;
			rest[5] = Ginkmode.end_condition;
			rest[6] = Ginkmode.timeout_interval;
			Gactevnt[INKING] = ON;
			break;
		case INTRVL1 :
		case INTRVL2 :
		case INTRVL3 :
		case TIMEOUT :
			argument[2] = arg < MIN_TIME ? MIN_TIME : arg;
		case TTY :
			Gactevnt[evnt_type] = ON;
			break;
		case Z_AXIS_DOWN :
		case Z_AXIS_UP :
		case BUTTON1_DOWN :
		case BUTTON1_UP :
		case BUTTON2_DOWN :
		case BUTTON2_UP :
		case BUTTON3_DOWN :
		case BUTTON3_UP :
		case RANGE_OUT :
		case RANGE_IN :
			Gactevnt[evnt_type] = ON;
			mask = 0;
			for(i = Z_AXIS_DOWN; i <= RANGE_IN; i++)
				if(Gactevnt[i++] == ON || Gactevnt[i] == ON)
					mask =| 1<<((i-Z_AXIS_DOWN)>>1);
			argument[2] = mask;
			evnt_type = BUTTONS;
			break;
		default :
			return(Gerror(ACT_INVALERR, evnt_type));
		}
	argument[1] = evnt_type;
	if(Gstty(Gtablet.fd, argument) < 0)
		return(Gerror(ACT_ERR));
	GOOD_RETURN;
	}


