/*
 Using a Decwriter terminal for printing input.
 call: lp[?] to print on /dev/tty? (default a)
 */ 
int tty[3];
int fin, fout;
int sv;
char *p "/dev/ttya";

finish() {
	tty[2] = sv;
	stty(fout, tty);
	exit();
}
main(cnt, v)
	char **v;
{
	register c, pos, npos;
	if((*v)[2])
		p[8] = (*v)[2];
	fout = open(p, 1);
	if(fout < 0) {
		writef(2, "open err\n");
		exit();
	}
	if(c = fork()) {
		writef(2, "%d\n", c);
		exit();
	}
	gtty(fout, tty);
	sv = tty[2];
	signal(1, 1);
	signal(2, 1);
	signal(3, 1);
	tty[2] = 02|04000|0300;
	stty(fout, tty);
	putchar('\r');
	pos = npos = 0;
	if(cnt > 1)
		fin = open(*++v, 0);
	do {
		if(fin < 0)
			goto next;
		while(c = getchar())
			if(c > ' ') {
				if(npos < pos/2) {
					putchar('\r');
					pos = 0;
				}
				while(npos < pos) {
					putchar('\b');
					pos--;
				}
				while(npos > pos) {
					putchar(' ');
					pos++;
				}
				putchar(c);
				pos++;
				npos++;
			}
			else
				switch(c) {
				case 025:
				case ' ':
					npos++;
					break;
				case '\b':
					if(npos)
						npos--;
					break;
				case '\t':
					npos = (npos/8+1)*8;
					break;
				case '\n':
					putchar(c);
				case '\r':
					npos = 0;
					break;
				default:
					putchar(c);
				}
next:
		if(--cnt > 1)
			fin = open(*++v, 0);
	}
	while(cnt > 1);
	putchar('\r');
	flush();
	finish();
}
