/* Hebrew dates for 2.10.1655 - 2.10.2168 */ 
/* Tables were condensed from "Secrets of the 'Ibur'", Z.H.Joffe,
    Darom pub. co., Jerusalem 1931 (in hebrew).
*/
/*
 */ 
/* bit for each long year,year 0 = cyc itself */ 
int pl[20] {
	040400, 031456, 066120, 0140741, 0111616,
	027035, 070160, 0142642, 015017, 0126134,
	050661, 0101702, 0127055, 056122, 060664,
	0111151, 026603, 057034, 0120146, 0141611 },
/* same for short years/cycles */ 
mi[20] {
	016323, 0100200, 01015, 036022, 040040,
	0100100, 07617, 010020, 0160740, 01001,
	06002, 070074, 0100, 0601, 0117012,
	020004, 040120, 0100643, 011010, 026164 };
/* cycle types */ 
char ctyp[27] { 7, 9, 10, 12, 13, 14, 15,
	0, 1, 2, 4, 5, 6, 8, 9, 11, 12, 13, 14, 15, 0, 1, 3, 4, 5, 6, 8 }, *mname[12] { "Tishrei", "Heshvan", "Kislev", 
		"Tevet", "Shvat", "Adar  ",
	"Nisan", "Iyar", "Sivan", "Tamuz", "Av", "Elul" }, *hbuf " 0         0000\n";
/*
 */ 
main(c, v)
	char **v;
{
	register m, y, yc;
	long d, atol(), ltime();
	if(c == 1) {
		d = atol("114777");	/* day no. of 1.1.70 */ 
		m = (ldiv(ltime(), 28800)+1)/3;	/* add 8 hrs to change date at 1600 gmt */ 
		d =+ m;
	}
	else if(c != 4) {
		putstr("Usage: hdate [day mon year]\n");
		exit();
	}
	else {
		d = atoi(*++v);
		m = atoi(*++v);
		y = atoi(*++v);
		if(y < 100)
			y =+ 1900;
		if((m =- 2) <= 0) {
			m =+ 12;
			y--;
		}
		yc = y/100;
		y =% 100;
		d =+ atol("36524")*(yc-16)+atol("365")*y+yc/4+y/4+367*m/12-20338;
	}
	if(d < 0 || d > atol("187370"))
		putstr("out of range\n");
	else
		putstr(nhd(d));
}
/*
 | compute date string from no. of days since 1 Tishrei 5416
 */ 
nhd(ln)
	long ln;
{
	int dy, dm, cy;
	register m, y, n;
	for(cy = 0; ln >= (dy = cycsiz(ctyp[cy])); cy++)
		ln =- dy;
	n = ln;
	for(y = 1; n >= (dy = dysiz(y, ctyp[cy])); y++)
		n =- dy;
	y =+ (cy+285)*19;
	for(m = 0; ; m++) {
		dm = ((m+1)&1)+29;
		if(m == 1 && dy%30 == 25)
			dm++;	/* Mlea */ 
		if(m == 2 && dy%30 == 23)
			dm--;	/* Hasera */ 
		if(dy > 365) {	/* Meuberet */ 
			if(m == 5) {
				mname[5][5] = 'a';
				dm++;
			}
			else if(m == 6 && mname[5][5] == 'a') {
				mname[5][5] = 'b';
				m--;
				dm--;
			}
		}
		if(n < dm)
			break;
		n =- dm;
	}
	putb(n+1, hbuf+1);
	for(n = 0; hbuf[n+3] = mname[m][n]; n++)
		;
	hbuf[n+3] = ' ';
	putb(y, hbuf+14);
	return(hbuf);
}
/*
 | size of hebrew year y of cycle type cy
 */ 
dysiz(y, cy) {
	register z, c, x;
	z = y;
	c = cy;
	x = 354;
	if((z*7+1)%19 < 7)
		x =+ 30;
	if(pl[z]&(1<<c))
		x++;
	else if(mi[z]&(1<<c))
		x--;
	return(x);
}
/*
 | size of cycle of type cy
 */ 
cycsiz(cy) {
	register c, x;
	c = cy;
	x = 6940;
	if(pl[0]&(1<<c))
		x++;
	else if(mi[0]&(1<<c))
		x--;
	return(x);
}
/*
 | put decimal no. in buf
 */ 
putb(n, buf)
	char *buf;
{
	register m;
	register char *b;
	m = n;
	b = buf;
	do
		*b-- = m%10+'0';
	while(m =/ 10);
}
