/*
 *	driver flag bits
 */
#define WRITE		0
#define OPEN		1
#define RCLOSE 		2
#define READ		4
#define TIMING		010
#define RUN		020
#define XCLOSE		040
#define WCLOSE		0100

/*
 *	protocol states
 */
#define NSTATES 	7
#define IDLE		0
#define XMIT1		1
#define XMIT2		2
#define XMIT3		3
#define RECV1		4
#define RECV2		5
#define RECV3		6

/*
 *	significant bytes
 */
#define STX		2
#define ETX		3
#define EOT		4
#define ENQ		5
#define ACK		6
#define NAK		025
#define FS		034

/*
 *	significant bytes + parity
 */
#define STXp		0202
#define ETXp		3
#define EOTp		0204
#define ENQp		5
#define ACKp		6
#define NAKp		0225
#define FSp		0234

/*
 *	decision table selectors
 */
#define Y_SIZE		9
#define Y_STX		0
#define Y_ETX		1
#define Y_EOT		2
#define Y_ENQ		3
#define Y_ACK		4
#define Y_NAK		5
#define Y_default	6
#define Y_xmit		6
#define Y_timout	7
#define Y_overun	8
#define Y_break 	8
#define Y_parity	8
#define Y_error 	8

/*
 *	state m/c states
 */
#define NULL		0		/* do nothing */
#define ACK_R1		1		/* send ack, move to state RECV1 */
#define t_XFLAG 	2		/* see if output waiting */
#define _IDLE		3		/* move to state IDLE */
#define STX_X2		4		/* send STX, move to state XMIT2 */
#define ENQ_		5		/* send ENQ */
#define _X2		6		/* transmit next message data byte */
#define xr_IDLE 	7		/* reset message, move to state IDLE */
#define ok_IDLE 	8		/* message xmit ok, move to IDLE */
#define lpc_R2		9		/* initialise lpc, move to state RECV2 */
#define ACK_		10		/* send ACK */
#define _R3		11		/* move to state RECV3 */
#define byte_		12		/* receive next message byte */
#define lpc_IDL 	13		/* check lpc, input message, move to state IDLE */
#define r_IDLE		14		/* reset message, move to state IDLE */
#define END		15		/* signal end of reception */
#define e_IDLE		16		/* eot error, move to state IDLE */
#define e_xr_ID 	17		/* eot error, reset xmit message, move to state IDLE */
#define e_r_IDL 	18		/* eot error, reset recv message, move to state IDLE */
#define e_byte		19		/* record byte error, receive error byte */

/*
 *	decision table for state m/c
 */
char	Bp_dtbl [NSTATES] [Y_SIZE]
{
/* -------- **	  STX	   ETX	    EOT      ENQ      ACK      NAK	 ?     TIMOUT	 error
    STATES
/*   idle   */	  NULL,    NULL,     END,  ACK_R1,    NULL,    NULL,	NULL, t_XFLAG,	  NULL,
/* try xmit */	 _IDLE,   _IDLE,  e_IDLE,  ACK_R1,  STX_X2,   _IDLE,   _IDLE,	 ENQ_,	 _IDLE,
/*   xmit   */   _IDLE,   _IDLE,   _IDLE,   _IDLE,   _IDLE,   _IDLE,     _X2,    NULL,   _IDLE,
/* end xmit */ xr_IDLE, xr_IDLE, e_xr_ID, xr_IDLE, ok_IDLE, xr_IDLE, xr_IDLE, xr_IDLE, xr_IDLE,
/* try recv */	lpc_R2,   _IDLE,  e_IDLE,    ACK_,   _IDLE,   _IDLE,   _IDLE,	_IDLE,	 _IDLE,
/*   recv   */	e_byte,     _R3, e_r_IDL,  e_byte,  e_byte,  e_byte,   byte_,  r_IDLE,	e_byte,
/* end recv */ lpc_IDL, lpc_IDL, lpc_IDL, lpc_IDL, lpc_IDL, lpc_IDL, lpc_IDL,  r_IDLE,	r_IDLE
};


/*
 *	define the buffer structure
 */

#define BUFSIZ		DATASIZ+2	/* allow space for ETX and LPC in buffer */

struct	buf
{
	int		b_count;
	int		b_size;
	struct	buf	*b_next;
	int		b_lpc;
	char		b_flag;
	char		b_retry;
	char		b[BUFSIZ];
};

/*
 *	buffer flag bits
 */
#define B_READ		1
#define B_XMIT		2
#define B_ERR		4
#define B_ASLEEP	010


/*
 *	define structure to log errors
 */
struct	error
{
	char	*e_mess;
	int	e_count;
};
