.hpf hyphen.local
.P1
.de PT
.tl 'TM01 - TM-11/TU-10 MAG. TAPE INTERFACE'\*[CH]'PD-1C303-01'
.tl 'File: tni.c''Section 12'
.tl '''Issue 1, January 1976'
..
.1C
.CD
.I
(Page missing from the original material)
.DE
.bp
.1C
.CD
.I
(Page missing from the original material)
.DE
.bp
.2C
The block address verification for magnetic tape is, because of the
medium's sequential nature and the attempt to have it emulate a disk file
system, more complex than that of most strategy routines and therefore
merits elaboration. A block number counter (t_nxrec[]) is maintained for
each drive. An I/O request may not be initiated to a block number exceeding
the value of the drive's counter. Specifically, when the device is opened
(see tm.c/tmopen), the value of this counter is set to the size of the
largest permissible file (65535 blocks). As long as only read requests are
made, the value of the counter does not change. However, whenever a write
request is made, the counter's value is set to the requested block number
plus one (which will be, for almost all cases, the number of the block that
will be written next). For every read or write request, the block number of
the request is checked against the counter. If the request's block number
exceeds the counter value, then the request is marked as complete but in
error (u_error). Otherwise the request is considered valid. A special case
is the situation where a read request is made for a block number that
equals the counter's value. This could occur, for example, if records are
being read and written and a read is issued for block n + 1 immediately
after writing block n. In this case no actual I/O takes place, but the
user's I/O buffer is zeroed and the I/O request is marked as completed.
.sp 1m
.ne 10
.
.LP
.LG
.B tmwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
tmwrite(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interface to TM11 driver for "raw" mode write requests.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Tmwrite handles raw mode write requests to TM11 magnetic tape. See
rp.c/rpwrite for a discussion of raw mode write routines. Before calling
bio.c/physio to do the real work, the starting block number of the request
must be calculated tm.c/tmphys.
