.hpf hyphen.local
.P1
.de PT
.tl 'LP01 - LINE PRINTER INTERFACE'\*[CH]'PD-1C302-01'
.tl 'File: lp.c''Section 13'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B lpcanon
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
lpcanon(c)
.br
int c;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Edits characters written to the LP11 line printer.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The lpcanon routine edits (i.e., translates as required) the character "c"
being written to the LP11 printer and causes the resultint character(s)
(which may include new lines or page ejects) to be placed on the printer's
output queue. There are essentially two phases of editing, the first being
done only for half ASCII (64 character) printers, and the second being done
for all printers.
.
.LP
Lpcanon must be compiled for either a 64 or 96 character printer; it is not
able to dynamically determine which it is being invoked for. In particular,
a parameter within the driver is available for specifying the character set
(CAP). If lpcanon was compiled for a 64 character printer, then an initial
editing of certain characters is done as follows.
.
.LP
Character	Mapped Into
.
.LP
a thru z	A thru Z
.br
{		(-
.br
}		)-
.br
`		'-
.br
|		!-
.br
~		^-
.
.LP
The overstruck characters are actually generated by invoking lpcanon for
the first character of the overstrike, backing up the perceived column
counter (see below) to give the impression of backspace, and then
proceeding into the second editing phase with the second character of the
overstrike.
.
.LP
Regardless of the printer's character set, all characters pass through a
"second" editing phase (although, strictly speaking, it is really the first
and only phase for 96 character printers). Three counters are maintained: a
perceived column counter (ccc), that indicates into which column the next
character should go; the actual column counter (mcc), that indicates into
which column the next character will actually go (i.e., the column position
of the printer itself); and a line counter (mlc), that keeps track of the
number of lines printed on a page. Each character being printed has a
different affect on these counters, as shown below.
.IP "Character" 10
Mapping
.LP
.IP "Tab" 10
Set perceived column counter to next tab stop (every eight columns).
.IP "New Page" 10
Put "new page" character on output queue. Reset both column counters and
the line counter to zero.
.IP "New Line" 10
Put new line on output queue, unless the per page line limit has been
reached. If so, change new line to new page character and put on output
queue. Adjust the line counter as necessary and reset both column counters
to zero.
.IP "CR" 10
Reset perceived column counter to zero.
.IP "Backspace" 10
Back up perceived column counter one position.
.IP "Blank" 10
Advance perceived column counter one position.
.IP "All Others" 10
If the perceived column exceeds the characters per line limit, merely add
one to the perceived column counter and discard the character. Otherwise,
adjust the perceived and actual counters as necessary to make them agree.
(That is, if the perceived precedes the actual, place a carriage return and
enough blanks on the output queue to align the counters. If the actual
precedes the perceived, put enough blanks on the output queue to realign
the counters.) Once the counters are aligned, the character is placed on
the output queue and the perceived and actual column counters are
incremented.
.
.LP
Notice that the notion of a perceived and an actual column counter permits
the printing of overstruck characters and attempts to minimize the number
of blanks being printed (lines with all blanks are translated to just a new
line and trailing blanks on a line are not printed).
.sp 1m
.ne 10
.
.LP
.LG
.B lpclose
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
lpclose(dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically closes the LP11 line printer.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Lpclose logically closes the LP11 by causing the paper to be ejected to
top-of-form and marking the device as closed (lp11.flag).
.sp 1m
.ne 10
.
.LP
.LG
.B lpint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
lpint()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interrupt handler for the LP11 line printer.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the interrupt handler for the LP11 printer, lpint must reactivate the
printer for the next character in the output queue, if any. A second
responsibility is to awaken lp.c/lpoutput if the output queue length has
shrunk to an acceptable length, so that more characters may be placed on
it.
.sp 1m
.ne 10
.
.LP
.LG
.B lpopen
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
lpopen(dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically opens the LP11 line printer.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The lpopen routine logically opens the LP11 line printer. In particular, it
ensures that the device is not already being used by another user and that
the printer itself is ready to be used (on line, power on, etc.). The
device is not opened and an error is indicated (u_error) if one of these
tests fail. If all is well, the device is enabled, marked as open
(lp11.flag), and it is ensured that the paper is at top-of-form (or, at
least, insofar as the driver is concerned).
.sp 1m
.ne 10
.
.LP
.LG
.B lpoutput
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
lpoutput(c)
.br
int c;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Places a character on the LP11's output queue and activates printing.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Before placing the character "c" on the LP11's output queue, lpoutput
verifies that there are not already too many unprinted characters on the
queue. If the queue is too long, it waits until the queue shrinks to an
acceptable length (see lp.c/lpint). The character is then placed on the
output queue and steps are taken to activate actual printing (see
lp.c/lpstart).
.sp 1m
.ne 10
.
.LP
.LG
.B lpstart
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
lpstart()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Activates the LP11 line printer for a character.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If the LP11 printer is ready to print a character and there are any
characters to be printed in the output queue, the printer is passed the
first character in the queue.
.sp 1m
.ne 10
.
.LP
.LG
.B lpwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
lpwrite()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The write routine for the LP11 line printer.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The lpwrite routine is the interface between the user writing to the LP11
line printer and the device driver itself. Therefore, it is called whenever
the user issues a write request to this device. Lpwrite collects from the
user's output buffer as many characters as necessary to satisfy the write
request's byte count and causes them to be translated (see lp.c/lpcanon),
as necessary, and placed on the LP11's output queue.
