.hpf hyphen.local
.P1
.de PT
.tl 'KL01 - KL-11 OR DL-11 ASYNCHRONOUS INTERFACE'\*[CH]'PD-1C302-01'
.tl 'File: kl.c''Section 12'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B klclose
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
klclose(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Performs a logical close of a terminal attached with a KL11 or DL11A
asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Kiciose logically closes terminals attached with KL11 or DL11AA interfaces
by invoking tty.c/wflushtty for the appropriate device "dev". This causes
all characters on the device's output queue (t_outq) to be transmitted and
flushes any characters on the device's input queues t_rawq, t_canq).
.sp 1m
.ne 10
.
.LP
.LG
.B klopen
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
klopen(dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Performs a logical open of a terminal attached with a KL11 or DL11A
asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The klopen routine does a logical open of a terminal attached with a KL11
or DL11A interface. This primarily entails the initialization of the
terminal control structure (struct tty) for the appropriate minor device
(kl11[dev.d_minor]). This entails computing the address of the device's
registers, and certain assumptions are made in this respect. In particular,
minor device zero is assumed to be the system console, since the console is
typically connected with a KL11 or DL11A interface. Further, it is assumed
that the minor device numbers for any additional terminals attached with a
KL11 or DL11A interface have been assigned consecutively starting with
minor device one. For example, if system has three KL11's, then they must
be given minor device numbers zero (system console), one, and two. A final
responsibility of klopen is to enable interrupts in the device's read and
write status registers and to enable the reader, so that characters may be
received from paper tape on the terminal (e.g., a teletype terminal).
.
.LP
The argument "flag" is nut used by klopen since the terminal is always
opened for both reading and writing, but serves to maintain syntax
compatibility with other device open routines.
.sp 1m
.ne 10
.
.LP
.LG
.B klread
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
klread(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The read routine for terminals attached with KL11 or DL11A asynchronous
interfaces.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The kiread routine is the KL11/DL11A driver's interface to the general
purpose functions of UNIX that handle terminal I/O. In particular, all read
requests to terminals attached with all or DL11A interfaces must pass
through kiread, which does nothing more than invoke tty.c/ttread for the
appropriate device "dev".
.sp 1m
.ne 10
.
.LP
.LG
.B klrint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
klrint(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts that result when a character is received from a terminal
attached with a KL11 or DL11A asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The klrint routine receives control whenever an interrupt on the receive
side of the KL11 or DL11A interface occurs. The character is retrieved from
the read data buffer and placed on the raw input queue (t_rawq) for device
"dev" (see tty.c/ttyinput). The reader is then reenabled, so that
characters may continue to be received if they are coming from paper tape
(e.g., a teletype terminal).
.sp 1m
.ne 10
.
.LP
.LG
.B klsgtty
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
klsgtty(dev, array)
.br
int dev, *array;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Determines or modifies the mode of a terminal attached with a KL11 or DL11A
asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
A nonzero value of "array" implies that information about the current state
of the terminal is desired in response to a guy system call (see tty.c/guy)
by the user. In this case klsgtty assumes that "array" is a three word
array and places the current state (t_flags) of the terminal into the last
word.
.
.LP
Conversely, a zero value of "array" implies that the terminal's state is to
be changed in response to a stty system call (see tty.c/stty), but only
after any pending output to the device has been physically transmitted.
.
.LP
Note that klsgtty totally disregards device speeds, both when determining
and modifying the state of the device.
.sp 1m
.ne 10
.
.LP
.LG
.B klwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
klwrite(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The write routine for terminals attached with KL11 or DL11A asynchronous
interfaces.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The klwrite routine is the KL11/DL11 driver's interface to the general
purpose functions of UNIX that handle terminal I/O. With one exception all
write requests to terminals attached with KL11 or DL11A interfaces must
pass through klwrite, which does nothing more than invoke tty.c/ttwrite for
the appropriate device "dev".
.
.LP
Tile system console is normally attached with a KL11 or DL11A interface.
Since UNIX itself manipulates the device registers directly when printing
system messages on the console (see prf.c/putchar), system writes to the
console do not go through klwrite.
.sp 1m
.ne 10
.
.LP
.LG
.B klxint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
klxint(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts that result from transmitting to a terminal attached
with a KL11 or DL11A asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The klxint routine receives control whenever an interrupt on the transmit
side of the KL11 or DL11A interface occurs. Transmission of the next
character in the output queue (t_outq) for device "dev" is initiated (see
tty.c/ttstart). If the output queue is short enough, then processes waiting
for it to shrink to an acceptable length before placing more characters on
it (i.e., write to the device; see tty.c/ttwrite) or to empty (see
tty.c/wflushtty) are awakened.
