.hpf hyphen.local
.P1
.de PT
.tl 'HT01 - TU16 MAGNETIC TAPE INTERFACE'\*[CH]'PD-1C302-01'
.tl 'File: ht.c''Section 11'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B hcommand
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
hcommand(unit, com)
.br
int unit, com;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Issues a command to the TU16 magnetic tape controller.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Before issuing a command to the TU16 controller, hcommand ensures that the
controller is ready and that no other magnetic tape I/O requests are active
(d_active in httab). The logical "unit" is mapped onto a physical unit
(Unit 4-7 map into drive 0-3). Once these conditions are met, the
controller command "com" is issued fo drive "unit".
.sp 1m
.ne 10
.
.LP
.LG
.B htclose
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
htclose(dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Performs a logical close for the TU16 magnetic tape.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Certain cleanup functions must be performed after a user has completed use
of a TU16 magnetic tape device. These are done by htclose, which is called
when the magnetic tape file is closed. In particular, the drive "dev" is
marked as not in use (h_openf[dev]) so that others may now use it, a double
end-of-file is written if the device was opened for writing ("flag" = 2).
If the unit is 0-3 or 8-11 the tape is rewound.
.sp 1m
.ne 10
.
.LP
.LG
.B htintr
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
htintr()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts from the TU16 magnetic tape.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the interrupt handler for TU16 magnetic tape, htintr's first
responsibility is to determine if an error occurred on the controller
command. There are many possibilities if an error occurred.
.IP 1. 4
If the error was not an end-of-file, is deemed recoverable, and was from an
actual I/O request (as distinguished from the tape positioning initiated by
ht.c/htstart), then the number of I/O errors that have already occurred for
this request is checked. If fewer than ten errors have occurred, then
action is taken to reposition the tape and retry the request. Otherwise,
the request is abandoned as hopeless, is not retried, and becomes subject
to the checks described in items 2 and 3 below.
.IP 2. 4
Any error that does not result in a retry and which was not an end-of-file
or from a raw mode I/O request causes the drive to be marked as unusable.
Note that tape positioning errors and unrecoverable I/O errors fall into
this category. This stigma holds until the device is closed.
.IP 3. 4
All requests that are not retried are marked as in error and then
ultimately handled as if they were successfully completed actual I/O
requests (the handling of which is described below). This includes an
end-of-file condition.
.
.LP
All successfully completed actual I/O requests are marked as complete and
removed from the queue; for successfully completed tape positioning
commands (done as a prelude to the actual I/O for those requests needing
tape positioning, see ht.c/htstart) the current block number counter
(h_blknon) is adjusted to reflect the tape's position and the request
remains as the first in the queue. Ht.c/htstart is then invoked for the
first request in the queue.
.
.LP
On an end of file if the request was for block I/O, the device is shut down
(made unavailable for further reads) to prevent read ahead from moving the
tape forward. This is to allow multifile tape processing.
.sp 1m
.ne 10
.
.LP
.LG
.B htopen
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
htopen(dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Performs a logical open for the TU16 magnetic tape.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Because of magnetic tape's sequential nature, only one user is allowed to
access a given drive at one time. The function of htopen is to enforce this
restriction by checking the availability of the specified device "dev". If
the drive in question is already in use (h_openftp, then appropriate error
bits are set (u_error). Otherwise, the drive is marked in use
(h_openftclevi) and the block counters (h_biknon and h_nxrecfl) are
initialized. The flag "flag", which indicates whether the open is for
reading and/or writing, is not used and only serves to maintain syntax
compatibility with other device open routines.
.
.LP
Units 0-7 are mapped into 800 BPI where as units 8-15 are mapped into 1600
BPI and the appropriate controller bits are set.
.sp 1m
.ne 10
.
.LP
.LG
.B htphys
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
htphys (dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Computes the starting block number for raw mode I/O requests to TU16
magnetic tape.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Prior to doing raw mode I/O to magnetic tape, the starting block number for
the transfer must be calculated. This is necessary so that the tape may be
properly positioned before starting the I/O (see ht.c/htstart). This duty
is performed by htphys, which then records its findings in the block number
indicator for drive "dev" (i.e., h_blkno[].
.sp 1m
.ne 10
.
.LP
.LG
.B htread
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
htread(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interface to TU16 driver for "raw" mode read requests.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Htread handles raw mode read requests to TU16 magnetic tape. See
rp.c/rpread for a discussion of raw mode read routines. Before calling
bio.c/physio to do the real work, the starting block number of the requesto
must be calculated by ht.c/htphys.
.sp 1m
.ne 10
.
.LP
.LG
.B htstart
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
htstart
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Initiates the actual I/O procedure for TU16 magnetic tape.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If there are any I/O requests on the TU16 queue (chained from d_actf in
httab), htstart initiates the I/O procedure for the first request in the
queue. This entails first verifying that any previous I/O to the device did
not result in an unrecoverable I/O error (see ht.c/htintr) and that the
controller is ready to accept commands. Failure to pass these two tests
results in the I/O request being marked complete but in error and removing
it from the I/O queue. Otherwise, a contrailer command is issued for the
situation that pertains to the request.
.IP 1. 4
If the tape is not correctly positioned to do the read or write, then a
command is issued to advance or rewind the tape to the correct block.
.IP 2. 4
In all other cases the actual I/O for the first request in the queue is
initiated.
.
.LP
In either case the function being performed is recorded (in d_active) for
later use by the interrupt handler (see ht.c/htintr).
.sp 1m
.ne 10
.
.LP
.LG
.B htstrategy
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
htstrategy(bp)
.br
struct buf *bp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Places an I/O buffer on the TU16's queue of I/O buffers to read/write.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Htstrategy performs for TU16 magnetic tape the general strategy functions
described in rp.c/rpstrategy. The I/O buffer queuing strategy employed is
strictly First In First Out (FIFO). As might be expected, the logical
device number is taken to be the physical drive number.
.
.LP
The block address verification for magnetic tape is because of the medium's
sequential nature and the attempt to have it emulate a disk file system,
more complex than that of most strategy routines and therefore merits
elaboration. A block number counter (h_nxrec[]) is maintained for each
drive. An I/O request may not be initiated to a block number exceeding the
value of the drive's counter. Specifically, when the device is opened (see
ht.c/htopen), the value of this counter is set to the size of the largest
permissible file (65535 blocks). As long as only read requests are made,
the value of the counter does not change. However, whenever a write request
is made, the counter's value is set to the requested block number plus one
(which will be, for almost all cases, the number of the block that will be
written next). For every read or write request, the block number of the
request is checked against the counter. If the request's block number
exceeds the counter value, then the request is marked as complete but in
error (u_error). Otherwise the request is considered valid. A special case
is the situation where a read request is made for a block number that
equals the counter's value. This could occur, for example, if records are
being read and written and a read is issued for block n + 1 immediately
after writing block n. In this case no actual I/O takes place, but the
user's I/O buffer is zeroed and the I/O request is masked as completed.
.sp 1m
.ne 10
.
.LP
.LG
.B htwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
htwrite(dcv)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interface to TU16 driver for "raw" mode write requests:
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Htwrite handles raw mode write requests to TU16 magnetic tape. See
rp.c/rpwrite for a discussion of raw mode write routines. Before calling
bio.c/physio to do the real work, the starting block number of the request
must be calculated by ht.c/htphys.
