.hpf hyphen.local
.P1
.de PT
.tl 'DC01 - DC-11 COMMUNICATIONS INTERFACE'\*[CH]'PD-1C302-01'
.tl 'File: dc.c''Section 3'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B dcclose
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dcclose(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically closes a terminal attached with a DC11. asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
In order to logically close a terminal attached with a DC11 interface,
dcclose only has to change the software state (tstate) for the proper minor
device (dc11[rdev.d_minor]) to closed and, after forcing any data on the
output queue (t_outq) to be transmitted, flush the device's I/O queues (see
tty.c/wflushtty).
.sp 1m
.ne 10
.
.LP
.LG
.B dcopen
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dcopen(dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically opens a terminal attached with a DC11 asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The deepen routine does a logical open of a terminal attached with a DC11
interface. Dcopen must first filter out requests to open invalid devices.
Assuming that the device number "dev" is satisfactory, the device's control
structure (dc11[dev.d_minor]) is selected and the device is placed into a
waiting-to-open state (t_state). Note that for the purpose of selecting an
actual DC11, the minor device number plus one corresponds directly to the
DC11's position in the system. For example, minor device two causes the
third DC11 on the system to be selected.
.
.LP
If the device is not already in the open state (i.e. the device was closed;
it is permissible to invoke dcopen more than once without intervening
closes), the terminal control structure (struct tty) for the device and the
DC11's hardware status registers are initialized, and the state of the
device is set to open. Note that the initial line speed selection is always
for the next to lowest that is available on the DC11.
.
.LP
At this point, the device, whether previously opened or being opened for
the first time, is simultaneously in the software states (tstate) of open
and waiting-to-open. All that remains for dcopen to do is to await a
carrier signal on the DC11 (see dc.c/dcrint) if one is not already present.
Once carrier is detected, the waiting-to-open stigma is removed and the
opening of the device is complete.
.sp 1m
.ne 10
.
.LP
.LG
.B dcread
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dcread(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Read routine for terminals attached with a DC11 asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The dcread routine is the DC11 driver's interface to the general purpose
functions of UNIX that handle terminal 110. All read requests to terminals
attached with a DC11 interface must pass through dcread. If the DC11 device
"dev" still has a carrier signal, then dcread merely has to invoke
tty.c/ttread to obtain input data from the canonical queue (t_canq).
.sp 1m
.ne 10
.
.LP
.LG
.B dcrint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dcrint(dev)
.br
in dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts that occur in the receive portion of the DC11
asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the interrupt handler on the receive side of a DC11 interface, dcrint
must diagnose the DC11's state in order to decide what to do about the
interrupt.
.
.LP
In particular, dcrint must first determine if a carrier signal is still
present on the DC11 device "dev". If there is no such signal, the software
state of the device (t_state) is altered to reflect loss of carrier.
Additionally, if the device is not in the waiting-to-open state (see
dc.c/dcopen), then it was open for some user and the carrier dropped for
some reason. This necessitates disabling the receiver, flushing the
device's I/O queues (see tty.c/flushtty), and signaling to the user that
carrier has been lost.
.
.LP
The action taken when a carrier signal is present on the line depends on
whether or not the DC11 has sensed an error. If an error is indicated
(which could signify a carrier transition or be a ring indication) and the
DC11 is in the waiting-to-open state (see dc.c/dcopen), the device's state
is changed to reflect presence of the carrier and dc.c/dcopen is awakened
so that it may conclude open processing. Otherwise, the interrupt is
assumed to have been caused by receipt of a character by the device. If the
character's parity is allowable under the mode of the terminal flags), it
is placed on the device's raw input queue (t_rawq; see tty.c/ttyinput);
otherwise, it is discarded.
.sp 1m
.ne 10
.
.LP
.LG
.B dcsgtty
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dcsgtty(dev, array)
.br
int dev, *array;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Determines or modifies the mode of a terminal attached with a DC11
asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
A nonzero value of "array" signifies that information about the current
state of the terminal attached to the DC11 device "dev" is desired in
response to a gtty system call (see tty.c/gtty). In this case, "array" is
assumed to be a three word array into which dcsgtty places the current line
speeds (t_speeds), zero, and the current state (t_flags) of the device and
its associated terminal.
.
.LP
Conversely, a zero value of "array" implies that the state of the device is
to be respecified in response to a stty system call (see tty.c/stty).
Pending output (t_outq) is first written and the device's I/O queues are
flushed (see tty.c/wflushtty). The speeds kspeeds) and mode (t_flags) of
the terminal are then respecified as requested. If the requested speeds are
reasonable (that is, the DC11 is wired for the speeds specified by the
user), the DC11's transmitter and receiver status registers are altered to
reflect the new line speeds. Whether or not a speed for the transmitter or
receiver is reasonable is determined by the presence of a nonzero entry in
the proper position, of the DC11 driver's dctstab[] or dcrstabn table,
respectively.
.sp 1m
.ne 10
.
.LP
.LG
.B dcwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dcwrite (dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Write routine for terminals attached with a DC asynchronous interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The dcwrite routine is the DC11 driver's interface to the general purpose
functions of UNIX that handle terminal I/O. All write requests to terminals
attached with a DC11 interface must pass through dcwrite. If the DC11
device "dev" still has a carrier signal, they dcwrite merely invokes
tty.c/ttwite to place the data on the output queue (t_outq) and initiate
transmission.
.sp 1m
.ne 10
.
.LP
.LG
.B dcxint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dcxint(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interrupt handler for the transmit portion of a DC11 asynchronous
interface.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The dcxint routine receives control whenever an interrupt on the transmit
side of a DC11 interface occurs. Transmission of the next character in the
output queue (t_outg) of device "dev" is initiated (see tty.c/ttstart). If
this queue is empty or has reached its low water mark, all processes
waiting for such events are awakened. The former event is waited on by
tty.c/wilushtty; the latter, by processes waiting for the -queue to shrink
to a reasonable length before putting more data on it.
