.hpf hyphen.local
.P1
.de PT
.tl 'SYS501 - SYSTEM CALL INTERFACE 5'\*[CH]'PD-1C301-01'
.tl 'File: sys5.c''Section 20'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B lflags
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
lflags()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
System call interface for semaphores.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Semaphores are currently implemented as lock/unlock conditions. Lflags is
called with an action code in u_arg[0] and the semaphore number in
u_arg[1]. The action code is one of the following:
.IP 1. 3
Lock - If the semaphore is locked, wait until it becomes unlocked. When the
semaphore becomes unlocked (or if originally unlocked) lock it and return.
.IP 2. 3
Unlock - Clear the semaphore and wake up all processes waiting on it.
.IP 3. 3
Tlock - If the semaphore is unlocked, lock it and in either case (locked or
unlocked) return.
.
.LP
The process id of the locking process is saved in the semaphore to allow
the system to know who has certain semaphores. If the semaphore value is
out of range return the EINVAL error. If the action code is not one of the
above return the ENOENT error.
