.hpf hyphen.local
.P1
.de PT
.tl 'PRF01 - PRINT FACILITY'\*[CH]'PD-1C301-01'
.tl 'File: prf.c''Section 11'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B panic
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
panic(str)
.br
char *str;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No return.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Idles the processor.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Panic is used to gracefully bring down the system when a fatal error (i.e.,
out of swap space, out of i-nodes etc.) is encountered. After updating any
mounted file systems (see alloc.c/update) and printing the message pointed
to by "str" on the system console, the processor is placed in an endless
idle loop.
.sp 1m
.ne 10
.
.LP
.LG
.B printf
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
printf(format,a1,...,a9,aa,ab,ac)
.br
char *format;
.br
Arguments al-ac may be one of:
.br
	char *al;
.br
	int al;
.br
	int al; (one char in low byte)
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Prints messages on the system console with format control.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The system's printf function performs exactly like the C library's printf,
except that it always prints on the system console and only a subset of the
format control directives are available. In particular, within the format
control string "format", only the conversion specifications c, d, l, o, and
s are recognized and honored.
.sp 1m
.ne 10
.
.LP
.LG
.B printn
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
printn(nurn, base)
.br
int num, base;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Prints a number on the system console in any base.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Printn is used to print on the system console the value of "num" in base
abases. This is accomplished by having printn recursively call itself to
print the quotient of "num" divided by "base". The recursive calling is
terminated when this quotient reaches zero. The remainder from each
division is then printed as the system crawls back up the chain of printn
calls. This has the effect of printing the remainders from the divisions in
inverse order, which yields the desired result.
.sp 1m
.ne 10
.
.LP
.LG
.B putchar
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
putchar(c)
.br
int c;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Prints a single character on the system console.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Bypassing the device driver's write routines, putchar prints the character
"c" on the system console by manipulating the device's registers directly.
The character is not printed if the console switches are set to zero.
