.hpf hyphen.local
.P1
.de PT
.tl 'MAIN01 - MAIN'\*[CH]'PD-1C301-01'
.tl 'File: main.c''Section 8'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B estabur
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
estabur(text, data, bss)
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Determines whether a process with a given text, data and stack size can fit
within the limits of user virtual address space and loads prototype
segmentation registers.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
With a 16 bit address, only 64K bytes of virtual address space is available
to a user process. (When I and D space is implemented for user processes it
will allow 64K bytes of text and 64K bytes of data, bss and stack.) The
main.c/estabur function is called wheneyer the size of a process is to be
changed (e.g. when an overlay is done, when a process needs more stack
space , etc.) to make a test fit and insure that the process can take on
tie new size. The first check that is made also insures that the text,
data, stack and U block areas, which are loaded contiguously do not exceed
the total amount of available user memory "maxmem".
.
.LP
Main.c/estabur insures that the text, data and stack are protected
appropriately. The different areas are segregated into different groups of
Memory Management registers.
.
.LP
the arguments "text", "data" and "stack" have a different meaning depending
on whether the process being tested is reentrant or not. For reentrant
processes the arguments represent the size of the text, data and stack
areas respectively in memory blocks. For nonreentrant processes the "text"
argument are zero and the the text and data is included in the "data"
argument. The "data" argument in all cases includes the bss and data areas
for a process. Reentrant processes must have their Memory Management
Registers write protected and any portion of a register (less than 4K
words) that is unused cannot be used to map data. Similarly, since the
stack expands downward, it must be segregated from the data registers.
.
.LP
Processes are loaded into memory with the U block, text, data and stack
area physically contiguous. The U block is not, however, included in the
user's virtual address space. For reentrant processes, the text may be
loaded elsewhere. With this in mind, a check is made to see that the text,
data and bss area will not exceed the number of memory management registers
available (8).
.
.LP
If any of the checks fail, an error ENOMEN is posted (in "u_error") and a
-1 is returned to the caller to indicate that the process should be
aborted.
.
.LP
Processes that satisfy the above memory requirements can have their
prototype segmentation registers loaded. "U_uisia[]" is the corresponding
prototype User Instruction Address Register array (8 words) and "u_uisd[]"
is the prototype User Instruction Descriptor Register array. Text registers
are set up first (only for reentrant programs). Text registers have the
Access Control Field in the prototype descriptor registerS set to read-only
to preserve their reentrancy. If text only partially fills the virtual
address space mapped by one of the registers, there will be a gap in the
virtual address space of the process, as that register cannot be used to
map the data portion. (The UNIX loader has forseen how the program will be
loaded and relocated the object program appropriately.) The data portion is
loaded into the succeeding registers and the access control is marked
read/write. A virtual address gap will lie between the data and stack and
any unused portion of a Memory Management register in the data area cannot
be used to map stack space, because the expansion directions are different
even though the access control permissions are the same. The prototype
registers for the stack area are loaded starting at the high virtual
address end. Each register is marked read/write, but the expansion
direction is marked so that the stack grows downward in physical memory.
.
.LP
When the prototype registers have been set up, main.c/sureg is called to
load the prototype registers into the User Memory Management registers.
.
.LP
A zero is returned to the caller of main.c/estabur to indicate that the
process will fit in user virtual address space.
.sp 1m
.ne 10
.
.LP
.LG
.B main
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
main()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Initializes the system.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This function initializes all system buffers, mounts the root file system
and creates the Scheduler and INIT processes. Since the Operating System is
not loaded with either the C or assembly language library, there is no
startoff function (crt0.s) to involk main.c/main. Instead, the mch.s/start
function involks main.c/main. An arrangement also exists between
main.c/main and mch.s/start for bringing up the INIT process. Mch.s/start
sets up the virtual address space for the operating system and creates a
stack (which will be owned by the Scheduler). The functions performed by
main.c/main are:
.
.LP
1. The version number (release number) is printed on the system console.
.
.LP
2. The amount of memory available for user processes is determined and is
cleared. This is done by setting up User Instruction Address Register 0 and
User Instruction Descriptor register XXXX map successive memory blocks (64
bytes) XXXX and the address space of the operating system. The mch.s/fubyte
function is used to fetch the first byte in a memory block. If a trap
occurs as a result of this fetch, the clearing operation is terminated.
Mch.s/clearseg is called to zero each memory block and the external
variable "maxmem" is used to count the number of memory blocks. As each
block is cleared, it is allocated (by calling alloc.c/mfree) to the free
memory table ("coremap"). At the end of this operation, the amount of
memory available for user processes will be in "maxmem" and the "coremap"
array will be initialized to contain all of user memory as its first and
only piece of available core.
.
.LP
3. The total amount of available memory may be limited by the system
constant "MAXMEM" (see pararn.h). The external variable "maxmem" is set to
the minimum value of "MAXMEM" and the amount of memory that was
experimentally determined.
.
.LP
4. The amount of swap space ("nswap" in conf.c) and its location specified
in "swplo" is entered in the "swapmap" array. The external variable "nswap"
contains the number of blocks (512 bytes) available on the swap device. The
external variable "swplo" is the offset (in blocks) on the device
(specified in "swapdev") that this area begins. This offset cannot be zero
as block zero has a special meaning to the system.
.
.LP
5. A determination is made as to which one of the two available clocks
(KW11-L or KW11-P) is on the system. This is done in a manner similar to
that by which the amount of available memory was determined. That is, a
fetch is first attempted on the status register associated with the KW11-L
(using mch.s/fuword). If this fails (i.e., a trap occurs) a fetch is
attempted on the KW11-P status register. If neither fetch succeeds, then no
clock is present and the system panics ("PANIC NO CLOCK"). For the KW11- L
clock, it is only necessary to set the interrupt enable bit to start the
clock counting at line frequency. For the KW11-P clock, the line frequency
rate must be selected and repeat interrupt mode set (see DEC Peripherals
Handbook).
.
.LP
6. The Process Table entry for the Scheduler is then set up. The Scheduler
is a process which runs entirely in Kernel Address space. It is always
process zero in the Process Table and is always locked in memory. (The
SLOAD flag in "p_flag" is always set and a special indicator SSYS is also
set to mark it as the Scheduler.) The size and location of:the Scheduler do
not correspond to the location and size of the function slp.c/sched. The
location of the Scheduler is taken to be the start of the U block and its
size is taken to be that of the U block. This is done because the INIT
process is created by the Operating System forking and as small a core
image as possible should be used. The U block created by mch.s/start is
allocated to the Scheduler.
.
.LP
7. The block device buffers are initialized by bio.c/binit and the
character device buffers are initialized by tty.c/cinit. These routines
also determine the number of block and character devices on the system. The
root file system is mounted (by calling alloc.c/iinit). The root inode is
retrieved from the root file system (via iget.c/iget), and an external
variable "rootdev" is loaded with the address in the Inode Table entry of
the root inode. The working directory entry "u_cdir" is also set up so that
it indicates the root directory. (This is done so that when the INIT
process is spawned, it will have the root inode as it's working directory.)
.
.LP
8. The INIT process is spawned. This is done by a trick in which a tiny
program is hand crafted in memory and executed. This program (a copy of
which is in the "icode[]" array") simply requests an overlay of the INIT
process. The actual procedure is as follows:
.
.LP
a. The slp.c/newproc function is called to do a fork of the Scheduling
process. From 6 above, the size of the Scheduler was set to the size of
it's U block, so a fork replicates the U block. The slp.c/newproc function
creates a new process within the system which is an identical copy of the
original process. Both processes begin executing at the return from
slp.c/newproc. The only difference is that since only one process can be
executing at a time, one process (the child) will actually return from the
slp.c/swtch function, and not slp.c/newproc. The child process (forerunner
of INIT) will call for the creation of a one memory block (64 bytes) area
for the program (by calling slp.c/expand) and will set up the prototype
segmentation registers "u_uisa[]" and "u_uisd[]", so that main.c/sureg can
be called to actually load them. Main.c/sureg sets up as a default a 32
word memory block An offset (USIZE) is setup in the prototype segmentation
address register "u_uisa[0]", so that the physical area of memory where the
program is loaded is directly behind the Scheduler's U block. Once this has
been done, the "icode[]" program is copied into the user's address space
(by mch.s/copyout). (It should be noted that the child process is
essentially creating itself.) The mch.s/start function is set up so that
upon a return to it from main.c/main a system call is simulated. This is
done by setting up the system stack so that a return from trap (RTT)
instruction is executed, which will take the execution into User address
space at virtual address 0. The "icode[]" program executes and makes an
exec system call to overlay itself with the /etc/init process.
.
.LP
The parent process (in this case the system) only creates the U block for
the new process. The child actually loads the "icode[]" program. This is
essentially a combination of a fork and exec system call. The parent calls
the function slp.c/sched which is the endlessly looping Scheduling process.
The Scheduler receives no signals, so that it cannot be killed and thus
need never be respawned.
.sp 1m
.ne 10
.
.LP
.LG
.B sureg
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
sureg()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Loads User Memory Management registers from their software prototypes.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
In order to dispatch any process, that process' virtual address space must
be setup. Also, when any growth in the size of a process (stack growth or
memory allocation) occurs, the virtual address map in the Memory Mansgement
Unit must be changed and reloaded. The main.c/sureg function sets up the
user virtual address space by loading the Memory Management registers from
the prototype address and descriptor registers ("u_uisa[]" and "u_uisd[]"
which contain the virtual address map for the process relative to absolute
location 0. In order to load the Memory Management Unit, the address
registers ("u_uisa[]") must be relocated to the proper physical address. In
particular, the "p_addr" entry in the Process Tabli contains the physical
address (in memory blocks) of the process. This value is added to each of
the instruction address prototype ("u_uisa[]") registers when they are
loaded into the User Memory Management Address Registers. (When the
prototype registers were set up by main.c/estabur, allowance was made for
the position and size of the U block.) Since reentrant processes may have
the text segment loaded elsewhere, a further adjustment of the registers
mapping the text area may be necessary. Reentrancy can be checked for by
examining the "p_textp" entry in the Process Table. If this is zero, the
process is not reentrant. If nonzero, it contains a pointer to a Text Table
entry which contains the address of the text ("u_caddr"). A relative
correction ("p_addr" - "x_addr") can then be applied to the reentrant text
address registers when the prototype descriptor register ("u_uisd[]") are
loaded. Registers mapping reentrant text must also have the write only bit
set in the Access Control Field of the descriptor register while those for
stack and data (including nonreentrant text) are read-write.
