.hpf hyphen.local
.P1
.de PT
.tl 'IGET01 - I-NODE INTERFACE'\*[CH]'PD-1C301-01'
.tl 'File: iget.c''Section 6'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B iget
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
iget (dev, ino)
.br
int dev;
.br
int ino;
.sp 1n
.
.LP
.I RETURNS
.
.LP
A pointer to a locked, incremented i-node if successful. Otherwise, a panic
situation if the System INODE Table (inode.h) is full.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Look up the i-node associated with i-number, "ino", on device, "dev", and
return a pointer to the locked, incremented i-node.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
I-nodes are locked whenever they are created, updated, or written to the
disk. The protocol if an i-node is locked is to set a bit requesting the
i-node, then to sleep until it becomes unlocked.
.
.LP
Iget searches through the in-core System INODE Table (inode.h) for a
matching i-number, "ino" and device, "dev". If it is present and is a mount
point (i.e., some file system has been mounted on it) an indirection takes
place to resume the search in the root directory of the mounted file
system. The Mount Table contains the new device name for this mount point.
.
.LP
When the i-node is found, the usage count is incremented, it is locked, and
a pointer to the inode is returned.
.
.LP
If the i-node is not present in the in-core System INODE Table then the
i-node is fetched from the disk ilist of the appropriate device, "dev". The
inode is read from the disk at block number B where B = (i-number + 31)/16
.br
since there are 16 i-nodes per block and inumber 1 starts in block 2. The
remainder from the above calculation, R, is used to locate the inode within
the block. The i-node is moved into the System INODE Table, the count is
incremented, and the i-node is locked. The pointer to this i-node is
returned.
.sp 1m
.ne 10
.
.LP
.LG
.B iput
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
iput (p)
.br
struct i-node sp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Deallocate the i-node pointed to by "p".
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Iput decrements the usage count (i_count) of the i-node pointed to by "p".
If the usage count indicates that there are other processes connnected to
this i-node then return.
.
.LP
If this is the last reference (the usage count is zero), then the i-node is
freed and may be written back to the disk ilist. This is done by locking
the i-node to prevent other processes from connecting to it while it is
de-allocated.
.
.LP
If the link count (i_nlink) is zero, the file has been removed by all users
so that the i-node can be freed. Iget.c/itrunc is called to release all
data blocks and indirect blocks used in this i-node. Alloc.c/ifree is
called to put this i-number back on the freelist of i-numbers.
.
.LP
Iget.c/iupdat is called to update the modify date and time and write the
i-node back to the ilist if necessary.
.
.LP
In all cases pipe.c/prele is called to unlock the inode.
.sp 1m
.ne 10
.
.LP
.LG
.B itrunc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
itrunc (ip)
.br
int *ip;
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Free all the blocks associated with the i-node pointed to by "ip".
(Truncate the file to zero length).
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Itrunc frees all the blocks associated with an inode. That means if the
file is small it searches through the i-node and frees each block addressed
in the i-node. If the file is large, it reads each indirect block pointed
to by the i-node into memory and frees each block in that indirect block.
Itrunc continues until all blocks are freed, then the file size is set to
zero, the file mode to small, and the update flag is set. If the mode is a
special file (device), no blocks are associated so just return.
.sp 1m
.ne 10
.
.LP
.LG
.B iupdat
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
iupdat (p, tm) int *p; int *tm;
.
.LP
RETURNS: None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Check accessed and update flags on the i-node pointed to by "p" and if
either flag is on, update the date and time with the values pointed to by
"tm". Write the i-node back to the disk ilist.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Iupdat calls fio.c/getfs to get the pointer to the superbiock of the
appropriate file system. If this file system is mounted as read-only then
the inode cannot be updated and the routine returns.
.
.LP
The block, B, within the ilist containing this inode is calculated as
.br
B = (i-number + 31)/16
.br
The remainder of the above calculation, R, is used to locate the i-node
within the block.
.
.LP
If the access flag is on, the last access time is updated from the user
time. If the update flag is on the last modified date and time is updated
from the time pointed to by "tm". The i-node is then re-written to the
ilist.
.sp 1m
.ne 10
.
.LP
.LG
.B maknode
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
maknode (mode)
.br
int mode;
.sp 1n
.
.LP
.I RETURNS
.
.LP
A pointer to the i-node of the file just created.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Build an i-node for a new file with the read/write permissions specified in
"mode".
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
A new file is added to the directory found in the per user control block
entry u.u_pdir. Maknode calls alloc.c/ialloc to allocate an i-node from the
file system superbiock associated with the directory in the per user
control block. It marks the i-node as allocated, set the link count to one,
sets the uid (owner) and gid (associated project) from the per user control
block (u.u_uid, u.u_gid). Iget.c/wdir is used to write the directory entry
for this i-node. The directory entry is composed of an i-number and a 14
character file name.
.sp 1m
.ne 10
.
.LP
.LG
.B wdir
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
wdir (ip)
.br
int sip;
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Write a directory entry for the i-node pointed to by "ip".
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Directory entries are composed of a two byte inumber and a fourteen
character file name. The name is taken from the per user control block
where it was left on the previous call to nami.c/namei. The structure
u_dent within the per user control block defines the format of directories.
Wdir copies the filename from the per user control block temporary area
(u_dbuf) to the directory entry area (u_dent). Wdir calls rdwri.c/writei to
write the update directory back to the disk. It then calls iget.c/iput to
deallocate the directory i-node.
