);
	return;
}

/*	output: write 1 line (terminated by '\0' or '\n') */
output(str)
register char	*str;
{
	register char c;
	while (c = *str++) {
		putc(c,&fout);
		if (c == '\n') break;
	}
	return;
}

/*	err: terminate with error and print diagnostic */
err(mesg)
register char	*mesg;
{
	int ttydes,ttyold[3];
	char *p;
	if (gtty(ttydes = 2,ttyold)) ttydes = 1;
	write(ttydes,"reform:",7);
	p = mesg;
	while(*p++);
	write(ttydes,mesg,p-mesg);
	write(ttydes,"\n",1);
	exit(1);
}

/*
 *	getnum: scan and convert number, return zero if none found
 *	set scan ptr to addr of ending delimiter
 */
getnum(scan1)
char	**scan1;
{
	register int n;
	register char c, *scan;
	n = 0;
	scan = *scan1;
	while ((c = *scan++) >= '0' && c <= '9') n = n * 10 + c -'0';
	*scan1 = --scan;
	return(n);
}

/*
 *	stdtabs: standard tabs table
 *	format: option code letter(s), null, tabs, null
 */
char	stdtabs[] {
'a',	0,1,10,16,36,72,0,			/* IBM 370 Assembler */
'a','2',0,1,10,16,40,72,0,			/* IBM Assembler alternative*/
'c',	0,1,8,12,16,20,55,0,			/* COBOL, normal */
'c','2',0,1,6,10,14,49,0,			/* COBOL, crunched*/
'c','3',0,1,6,10,14,18,22,26,30,34,38,42,46,50,54,58,62,67,0,
						/* crunched COBOL, many tabs */
'f',	0,1,7,11,15,19,23,0,			/* FORTRAN */
'p',	0,1,5,9,13,17,21,25,29,33,37,41,45,49,53,57,61,0, /* PL/I */
's',	0,1,10,55,0,				/* SNOBOL */
'u',	0,1,12,20,44,0,				/* UNIVAC ASM */
0};

/*
 *	stdtab: return tab list for any "canned" tab option.
 *	entry: option points to null-terminated option string
 *		tabvect points to vector to be filled in
 *	exit: return(0) if legal, tabvect filled, ending with zero
 *		return(-1) if unknown option
 */
stdtab(option,tabvect)
char	option[];
int tabvect[];
{
	register char *sp;
	tabvect[0] = 0;
	sp = stdtabs;
	while (*sp) {
		if (equal(option,sp)) {
			while (*sp++);		/* skip to 1st tab value */
			while (*tabvect++ = *sp++);	/* copy, make int */
			return(0);
		}
		while(*sp++);	/* skip to 1st tab value */
		while(*sp++);		/* skip over tab list */
	}
	return(-1);
}


/*	equal: string comparison, return 1 if equal, 0 otherwise */
equal(s1,s2)
char	*s1,*s2;
{
	register char c;
	while((c = *s1++) == *s2++ && c);
	if (c == *--s2)
		return(1);
	return(0);
}
t[];
{
	register char *sp;
	tabvect[0] = 0;
	sp = stdtabs;
	while (*sp) {
		if (equal(option,sp)) {
			while (*sp++);		/* skip to 1st tab value */
			while (*tabvect++ = *sp++);	/* copy, make int */
			return(0);
		}
		while(*sp++);	/* skip to 1st tab value */
		while(*sp++);		/* skip over tab list */
	}
	return(-1);
}


/*	equal: string comparison, reint __i_size;
char ofile[64];
char a1[1024];
char a2[64];
int iobuf[259];
main(argc,argv) char **argv;
{
	register char *name, *str, *v;
	char *bp, *cp, *sv;
	int i,j,k,cflg;
	char c;

	if (*argv[1] == '-') {
		cflg++;
		++argv;
		argc--;
	}
	else cflg = 0;
	while(--argc) {
		++argv;
		bp = *argv;
		if ((i=fopen(*argv,iobuf))<0) {
			write(2,"can not open ",13);
			write(2,*argv,size(*argv));
			write(2,"\n",1);
			continue;
		}
		cp = ofile;
		while(*++bp)
			if(*bp == '/') *bp = '\0';
		while(*--bp == '\0');
		while(*bp != '\0' && bp > *argv) bp--;
		while(*cp++ = *bp++);
		cp--; *cp++ = '.';
		if(cflg) *cp++ = 'c';
		else *cp++ = 'i';
		*cp = '\0';
		close(1);
		if (creat(ofile,0644)<0)  {
			write(2,"can not create .i file\n",23);
			exit(1);
		}
	   while(1) {
		str = a1;
		name = a2;
		while(((c=getc(iobuf)) == '\n') || (c == ' '));
		if(c==-1) break;
		*name++ = c;
		while(((*name++=c=getc(iobuf)) != ' ') && (c != -1) && (c != '\n'));
		*--name = '\0';
		while(((c=getc(iobuf)) == ' ') || (c == '\n'));
		if(c != '"') {
			if (c==-1) {write(2,"unexpected eof\n",15); exit(1);}
			write(2,"missing initial quote for ",26);
			write(2,a2,size(a2));
			write(2," : remainder of line ignored\n",29);
			while((c=getc(iobuf)) != '\n');
			continue;
		}
	keeponl:
		while((c=getc(iobuf)) >= 0) {switch(c) {
		case '"':
			break;
		case '\\':
			switch(c=getc(iobuf)) {
			case 't':
				*str++ = '\011';
				continue;
			case 'n':
				*str++ = '\012';
				continue;
			case 'r':
				*str++ = '\015';
				continue;
			case 'b':
				*str++ = '\010';
				continue;
			case '\\':
				*str++ = '\\';
				continue;
			default:
				if (c<='7' && c>='0') 
						*str++ = getnm(c);
				else *str++ = c;
				continue;
			}
		default:
			*str++ = c;
		}
		if (c=='"') break;
		}
		if (c==-1) {write(2,"unexpected eof\n",15); exit(1);}
		while(((c=getc(iobuf)) == '\n') || (c == ' '));
		if (c=='"') goto keeponl;
		else {
			iobuf[1] =+ 1;
			iobuf[2] =- 1;
		}
		*str = '\0';
		if(!(sv=v=regcmp(a1,0))) {
			write(2,"fail: ",6);
			write(2,a2,size(a2));
			write(2,"\n",1);
			continue;
		}
		printf("/* \"%s\" */\n",a1);
		printf("char %s[] {\n",a2);
		while(__i_size > 0) {
			for(k=0;k<12;k++)
				if(__i_size-- > 0) printf("0%o,",*v++);
			printf("\n");
		}
		printf("0};\n");
		free(sv);
	   }
	   close(i);
	}
	exit(0);
}
size(p) char *p;
{
	register i;
	register char *q;

	i = 0;
	q = p;
	while(*q++) i++;
	return(i);
}
getnm(j) char j;
{
	register int i;
	register char c;
	i = j - '0';
	while((c=getc(iobuf)) >= '0' && c <= '