#include	<sys/param.h>
#include	<sys/buf.h>
#include	<a.out.h>

char	*unixf;
char	*coref;
int	ufd, cfd;
struct buf bfreelist;
struct buf buf[NBUF];

struct nlist nl[] =
{
	{ "_buf",	0, 0 },
	{ "_bfreelist",	0, 0 },
	{ 0,		0, 0 },
};

main(ac, av)
char **av;
{
	register struct buf *bp, *bnext, *breal;

	if (ac != 3)
	{
		printf("Usage: x unix core\n");
		exit(1);
	}
	unixf = av[1];
	coref = av[2];
	if ((ufd = open(unixf, 0)) == -1)
	{
		perror(unixf);
		exit(1);
	}
	if ((cfd = open(coref, 0)) == -1)
	{
		perror(coref);
		exit(1);
	}
	nlist(unixf, nl);
	if (nl[0].n_value == 0 && nl[0].n_type == 0 ||
	    nl[1].n_value == 0 && nl[1].n_type == 0)
	{
		printf("_buf or _bfreelist not found\n");
		exit(1);
	}
	lseek(cfd, (long)nl[0].n_value, 0);
	read(cfd, buf, NBUF * sizeof(struct buf));
	lseek(cfd, (long)nl[1].n_value, 0);
	read(cfd, &bfreelist, sizeof(bfreelist));
	for (bp = buf; bp < &buf[NBUF]; bp++)
		bp->b_scratch = 0;		/* used to detect loops */
	bp = &bfreelist;
	breal = nl[1].n_value;
	printf(" Addr   Forw   Back\n");
	for (;;)
	{
		printf("%06o %06o %06o\n", breal, bp->av_forw, bp->av_back);
		bp->b_scratch++;
		bp = bp->av_forw;
		bnext = bp;
		if (bp == (struct buf *)nl[1].n_value)	/* bfreelist */
			break;
		bp = (struct buf *)((char *)bp - (char *)nl[0].n_value);
		if ((unsigned)bp % (sizeof(struct buf)))
		{
			printf("Forw not on buf boundary\n");
			exit(1);
		}
		bp = (struct buf *)((char *)bp + (char *)&buf);
		if ((unsigned)bp > (unsigned)&buf[NBUF])
		{
			printf("Forw outside buf array\n");
			exit(1);
		}
		if (bp->av_back != breal)
		{
			printf("Back pointer of next buffer incorrect\n");
			exit(1);
		}
		if (bp->b_scratch)
		{
			printf("Freelist loop detected\n");
			exit(1);
		}
		if (bp->b_flags & B_BUSY)
		{
			printf("Next block is BUSY\n");
			exit(1);
		}
		breal = bnext;
	}
	exit(0);
}
