#include	<sys/param.h>
#include	<sys/proc.h>
#include	<sys/dir.h>
#include	<sys/user.h>
#include	<sys/stat.h>
#include	<sys/map.h>
#include	<a.out.h>

#define	MEMEND	024000		/* first unusable core addr - * 64 bytes */

char	*unixf;
char	*coref;
int	ufd, cfd;
unsigned active;
unsigned endsys;
int	crook;
struct proc *pbuf;

struct nlist nl[] =
{
	{ "_proc",	0, 0 },
#define	NLPROC	0
	{ "_text",	0, 0 },
#define	NLTEXT	1
	{ "_coremap",	0, 0 },
#define	NLCMAP	2
	{ "_swapmap",	0, 0 },
#define	NLSMAP	3
	{ "_umap",	0, 0 },
#define	NLUMAP	4
	{ "_etext",	0, 0 },
#define	NLETXT	5
	{ "_end",	0, 0 },
#define	NLEND	6
	{ "_nswap",	0, 0 },
#define	NLSWAP	7
	{ "_swplo",	0, 0 },
#define	NLSWPLO	8
	{ 0,		0, 0 },
};

main(ac, av)
char **av;
{
	register struct nlist *nlp;
	long sz;
	struct stat statb;

	if (ac != 3)
	{
		printf("Usage: chk unix core\n");
		exit(1);
	}
	unixf = av[1];
	coref = av[2];
	if ((ufd = open(unixf, 0)) == -1)
	{
		perror(unixf);
		exit(1);
	}
	if ((cfd = open(coref, 0)) == -1)
	{
		perror(coref);
		exit(1);
	}
	fstat(cfd, &statb);
	sz = (long)MEMEND * 64;
	sz += 512;	/* written to tape even though past end of memory */
	if (statb.st_size != sz)
	{
		printf("Illegal core size (should be %ld)\n", sz);
		exit(1);
	}
	nlp = nl;
	nlist(unixf, nlp);
	while (nlp->n_name[0])
	{
		if (nlp->n_value == 0 && nlp->n_type == 0)
		{
			printf("Symbol %s not found\n", nlp->n_name);
			crook++;
		}
		nlp++;
	}
	if (crook)
		exit(1);
	/*
	 * get the proc array
	 */
	pbuf = want(NPROC * sizeof(struct proc));
	lseek(cfd, (long)nl[NLPROC].n_value, 0);
	read(cfd, pbuf, NPROC * sizeof(struct proc));
	endsys = (nl[NLEND].n_value + 077) >> 6;
	endsys += (nl[NLETXT].n_value + 077) >> 6;

	getregs();
	chktext();
	if (crook)
		exit(1);
	chkprocs();
	if (crook)
		exit(1);
	cmapchk();
	if (crook)
		exit(1);
	exit(0);
}

getregs()
{
	register struct proc *p;
	register slot;
	struct regs
	{
		unsigned r_r0;
		unsigned r_r1;
		unsigned r_r2;
		unsigned r_r3;
		unsigned r_r4;
		unsigned r_r5;
		unsigned r_r6;
		unsigned r_ka6;
		unsigned r_ka5;
	} regs;
	register struct regs *rp;
	char found;

	rp = &regs;
	lseek(cfd, 04L, 0);
	read(cfd, rp, sizeof regs);
	printf("r0 0%o r1 0%o r2 0%o r3 0%o r4 0%o r5 0%o r6 0%o\n",
		rp->r_r0, rp->r_r1, rp->r_r2, rp->r_r3, rp->r_r4, rp->r_r5, rp->r_r6);
	printf("ka5 0%o ka6 0%o\n", rp->r_ka5, rp->r_ka6);
	active = rp->r_ka6;
	found = 0;
	slot = 0;
	for (p = pbuf; p < &pbuf[NPROC]; p++, slot++)
		if (p->p_stat != NULL && p->p_stat != SZOMB &&
		   (p->p_flag & SLOAD) && p->p_addr == active)
		{
			printf("Proc slot %u was running\n", slot);
			found++;
		}
	if (found == 0)
		printf("No proc agrees with stored ka6!\n");
}

chktext()
{
	unsigned count;
	unsigned ts;
	char *buf0, *buf1;

	{
		long ds;

		ds = (unsigned)nl[NLEND].n_value;
		ds += 077;
		ds &= ~077;
		lseek(cfd, ds, 0);
	}
	lseek(ufd, 020L, 0);
	count = 0;
	ts = (nl[NLETXT].n_value + 077) & ~077;
	buf0 = want(BSIZE);
	buf1 = want(BSIZE);
	while (count != ts)
	{
		register unsigned *up0, *up1;
		register unsigned n;

		n = ts - count;
		if (n > BSIZE)
			n = BSIZE;
		if (n == 0)
			break;
		read(ufd, buf0, n);
		read(cfd, buf1, n);
		n >>= 1;
		up0 = (unsigned *)buf0;
		up1 = (unsigned *)buf1;
		do
		{
			if (*up0 != *up1)
			{
				if (crook == 0)
					printf("Addr\t%s\t%s\n", unixf, coref);
				printf("0%o\t0%o\t0%o\n", count, *up0, *up1);
				crook++;
			}
			up0++;
			up1++;
			count += 2;
		} while (--n > 0);
	}
	free(buf0);
	free(buf1);
}

chkprocs()
{
	register struct proc *p;
	register slot;
	register unsigned n;
	unsigned nlend, nlswap;
	long swplo;
	unsigned nact;
	struct user u;

	lseek(cfd, (long)nl[NLSWAP].n_value, 0);
	read(cfd, &nlswap, sizeof nlswap);
	lseek(cfd, (long)nl[NLSWPLO].n_value, 0);
	read(cfd, &swplo, sizeof swplo);
	swplo++;	/* it is decremented in machdep.c */
	slot = 0;
	nlend = endsys;
	nact = 0;
	p = pbuf;
	if (p->p_stat != SSLEEP && p->p_stat != SRUN)
	{
		printf("Sched: bad stat 0%o\n", p->p_stat);
		crook++;
	}
	else
		nact++;
	if (p->p_flag != (SLOAD | SSYS))
	{
		printf("Sched: bad flag 0%o\n", p->p_flag);
		crook++;
	}
	if (p->p_addr != nlend || p->p_size != USIZE)
	{
		printf("Sched: bad addr 0%o or size %d\n",
			p->p_addr, p->p_size);
		crook++;
	}
	nlend += USIZE + NBUF * 8;
	for (p = &pbuf[1]; p < &pbuf[NPROC]; p++, slot++)
	{
		if (p->p_stat == NULL || p->p_stat == SZOMB)
			continue;
		nact++;
		if (p->p_size <= USIZE)
		{
			printf("Proc slot %u - too small (%d)\n",
				slot, p->p_size);
			crook++;
			continue;
		}
		if ((p->p_flag & SLOAD) == 0)
		{
			if ((long)p->p_addr < swplo ||
			    (long)p->p_addr > swplo + (long)nlswap)
			{
				printf("Proc slot %u (swapped out) - illegal addr %u\n", slot, p->p_addr);
				crook++;
			}
			continue;
		}
		if (p->p_addr < nlend || p->p_addr > MEMEND)
		{
			printf("Proc slot %u (in core) - illegal addr 0%o\n", slot, p->p_addr);
			crook++;
			continue;
		}
		lseek(cfd, (long)p->p_addr << 6, 0);
		if (read(cfd, &u, sizeof u) != sizeof u)
		{
			printf("Can't read ppda (slot %u)\n", slot);
			crook++;
			continue;
		}
		n = (unsigned)u.u_procp - nl[NLPROC].n_value;
		if ((n % sizeof(struct proc)) || (n / sizeof(struct proc)) >= NPROC)
		{
			printf("Inconsistent user area (proc slot %u)\n", slot);
			crook++;
		}
	}
	printf("%u active procs\n", nact);
}

cmapchk()
{
#ifdef	DEBUG
	register struct map *map, *mp;
	unsigned size;

	map = mp = want(CMAPSIZ * sizeof(struct map));
	lseek(cfd, (long)nl[NLCMAP].n_value, 0);
	read(cfd, map, CMAPSIZ * sizeof(struct map));
	size = endsys + USIZE + NBUF * 8 - 1;
	for (mp = map; mp < &map[CMAPSIZ]; mp++)
	{
		if (mp->m_size == 0)
			break;
		if (size >= mp->m_addr ||
		    (size = mp->m_addr + mp->m_size) > MEMEND)
		{
			printf("cormap crook\n");
			crook++;
			break;
		}
	}
	if (mp == &map[CMAPSIZ])
	{
		printf("cormap has overflowed\n");
		crook++;
	}
	if (crook == 0)
	{
		{
			register struct proc *p;
	
			mfree(map, endsys + USIZE + NBUF * 8, 0);
			for (p = pbuf; p < &pbuf[NPROC]; p++)
			{
				if (p->p_stat == NULL || p->p_stat == SZOMB)
					continue;
				if ((p->p_flag & SLOAD) == 0)
					continue;
				if (mfree(map, p->p_size, p->p_addr))
				{
					crook++;
					break;
				}
			}
		}
		{
			register struct text *tp;
			struct text *tbuf;

			tbuf = want(NTEXT * sizeof(struct text));
			lseek(cfd, (long)nl[NLTEXT].n_value, 0);
			read(cfd, tbuf, NTEXT * sizeof(struct text));
			for (tp = tbuf; tp < &tbuf[NTEXT]; tp++)
				if (tp->x_iptr != NULL)
					if (mfree(map, tp->x_size, tp->x_caddr))
					{
						crook++;
						break;
					}
			free(tbuf);
		}
		if (map[0]->m_size != MEMEND || map[1]->m_size)
		{
			printf("cormap has gaps\n");
			crook++;
		}
	}
	free(map);
#endif
}

want(sz)
unsigned sz;
{
	register char *n;

	if ((n = malloc(sz)) != NULL)
		return(n);
	printf("Out of memory\n");
	exit(1);
}

#ifdef	DEBUG
mfree(mp, size, a)
struct map *mp;
register int a;
{
	register struct map *bp;
	register unsigned int t;

	for (bp = mp; bp->m_addr <= a && bp->m_size != 0; bp++);
	if (bp > mp && (bp-1)->m_addr+(bp-1)->m_size == a)
	{
		(bp-1)->m_size += size;
		if (a+size == bp->m_addr)
		{
			(bp-1)->m_size += bp->m_size;
			while (bp->m_size)
			{
				bp++;
				(bp-1)->m_addr = bp->m_addr;
				(bp-1)->m_size = bp->m_size;
			}
		}
	}
	else
	{
		if (a+size == bp->m_addr && bp->m_size)
		{
			bp->m_addr -= size;
			bp->m_size += size;
		}
		else if (size)
		{
			do
			{
				t = bp->m_addr;
				bp->m_addr = a;
				a = t;
				t = bp->m_size;
				bp->m_size = size;
				bp++;
			} while (size = t);
		}
	}
}
#endif
