#include <param.h>
#include <systm.h>
#include <map.h>
#include <dir.h>
#include <signal.h>
#include <user.h>
#include <proc.h>
#include <buf.h>
#include <reg.h>
#include <file.h>
#include <fcntl.h>
#include <inode.h>
#include <seg.h>
#include <acct.h>
#include <lnode.h>
#include <tty.h>
#include <errno.h>

extern struct proc proc[];
extern struct map coremap[];
extern struct map swapmap[];
extern struct user u;
extern char b[];

/*
 * exec system call, with and without environments.
 */
struct execa {
	char	*fname;
	char	**argp;
	char	**envp;
};

exec()
{
	((struct execa *)u.u_ap)->envp = NULL;
	exece();
}

exece()
{
	register nc;
	register char *cp;
	register struct buf *bp;
	register struct execa *uap;
	int na, ne, bno, ucp, ap, c;
	struct inode *ip;

	if ((ip = namei(uchar, 0)) == NULL)
		return;
	bno = 0;
	bp = 0;
	nc = 0;
	if (access(ip, IEXEC))
		goto bad;
	if ((ip->i_mode & IFMT) != IFREG ||
	   (ip->i_mode & (IEXEC|(IEXEC>>3)|(IEXEC>>6))) == 0)
	{
		u.u_error = EACCES;
		goto bad;
	}
	/*
	 * Collect arguments on "file" in swap space.
	 */
	na = 0;
	ne = 0;
	uap = (struct execa *)u.u_ap;
	if ((bno = malloc(swapmap,(NCARGS + BSIZE - 1) / BSIZE)) == 0)
		panic("Out of swap");
	if (uap->argp)
		for (;;)
		{
			ap = NULL;
			if (uap->argp)
			{
				ap = fuword((caddr_t)uap->argp);
				uap->argp++;
			}
			if (ap == NULL && uap->envp)
			{
				uap->argp = NULL;
				if ((ap = fuword((caddr_t)uap->envp)) == NULL)
					break;
				uap->envp++;
				ne++;
			}
			if (ap == NULL)
				break;
			na++;
			if (ap == -1)
				u.u_error = EFAULT;
			do
			{
				if (nc >= NCARGS-1)
					u.u_error = E2BIG;
				if ((c = fubyte((caddr_t)ap++)) < 0)
					u.u_error = EFAULT;
				if (u.u_error)
					goto bad;
				if ((nc & BMASK) == 0)
				{
					if (bp)
						bdwrite(bp);
					bp = getblk(swapdev, swplo+bno+(nc>>BSHIFT));
					ka5->r[0] = baddr(bp);
					cp = &b;
				}
				nc++;
				*cp++ = c;
			} while (c > 0);
		}
	if (bp)
		bdwrite(bp);
	bp = 0;
	nc = (nc + NBPW-1) & ~(NBPW-1);	/* round up to words */
	getxfile(ip, nc);
	if (u.u_error)
	{
bad:
		if (bp)
			brelse(bp);
		nc = (nc + BSIZE - 1) >> BSHIFT;	/* nr. blks */
		while (nc--)
		{
			bp = getblk(swapdev, swplo+bno+nc);
			bp->b_flags &= ~B_DELWRI;
			bp->b_flags |= B_AGE;
			brelse(bp);
		}
		goto home;
	}

	/*
	 * copy back arglist
	 */

	ucp = -nc - NBPW;	/* space for arg/env lists, plus null word */
	ap = ucp - na*NBPW - 3*NBPW;	/* ... + pointers, nulls, and argc */
	u.u_ar0[R6] = ap;
	suword((caddr_t)ap, na-ne);	/* args (not incl. env) */
	nc = 0;
	for (;;)
	{
		ap += NBPW;
		if (na==ne)
		{
			suword((caddr_t)ap, 0);
			ap += NBPW;
		}
		if (--na < 0)
			break;
		suword((caddr_t)ap, ucp);
		do
		{
			if ((nc&BMASK) == 0)
			{
				if (bp)
					brelse(bp);
				bp = bread(swapdev, swplo+bno+(nc>>BSHIFT));
				bp->b_flags &= ~B_DELWRI;
				bp->b_flags |= B_AGE;
				ka5->r[0] = baddr(bp);
				cp = &b;
			}
			subyte((caddr_t)ucp++, (c = *cp++));
			nc++;
		} while (c&0377);
	}
	suword((caddr_t)ap, 0);	/* final null at end of env pointers */
	suword((caddr_t)ucp, 0);	/* final null at top of stack */
	setregs();
	for (nc = 0; nc < NOFILE; nc++)
		if ((unsigned)u.u_ofile[nc] & 01)
		{
			closef((unsigned)u.u_ofile[nc] & ~01);
			u.u_ofile[nc] = NULL;
		}
	if (bp)
		brelse(bp);
home:
	if (bno)
		mfree(swapmap, (NCARGS+BSIZE-1)/BSIZE, bno);
	iput(ip);
}

/*
 * Read in and set up memory for executed file.
 */
getxfile(ip, nargc)
register struct inode *ip;
{
	register unsigned ds;
	register sep;
	register unsigned ts, ss;
	register i;
	long lsize;

	/*
	 * read in first few bytes
	 * of file for segment
	 * sizes:
	 * ux_mag = 407/410/411
	 *  407 is plain executable
	 *  410 is RO text
	 *  411 is separated ID
	 */

	u.u_base = (caddr_t)&u.u_exdata;
	u.u_count = sizeof(u.u_exdata);
	u.u_offset = 0;
	u.u_segflg = KERND;
	readi(ip);
	u.u_segflg = USERD;
	if (u.u_error)
		return;
	if (u.u_count!=0)
	{
		u.u_error = ENOEXEC;
		return;
	}
	sep = 0;
	if (u.u_exdata.ux_mag == 0407)
	{
		lsize = (long)u.u_exdata.ux_dsize + u.u_exdata.ux_tsize;
		u.u_exdata.ux_dsize = lsize;
		if (lsize != u.u_exdata.ux_dsize)	/* check overflow */
		{
			u.u_error = ENOMEM;
			return;
		}
		u.u_exdata.ux_tsize = 0;
	}
	else if (u.u_exdata.ux_mag == 0411)
		sep++;
	else if (u.u_exdata.ux_mag != 0410)
	{
		u.u_error = ENOEXEC;
		return;
	}
	if (u.u_exdata.ux_tsize!=0 && (ip->i_flag&ITEXT)==0 && ip->i_count!=1)
	{
		u.u_error = ETXTBSY;
		return;
	}

	/*
	 * find text and data sizes
	 * try them out for possible
	 * overflow of max sizes
	 */
	ts = btoc(u.u_exdata.ux_tsize);
	lsize = (long)u.u_exdata.ux_dsize + u.u_exdata.ux_bsize;
	if (lsize != (unsigned)lsize)
	{
		u.u_error = ENOMEM;
		return;
	}
	ds = btoc(lsize);
	ss = SSIZE + btoc(nargc);
	if (estabur(ts, ds, ss, sep, RO))
		return;

	/*
	 * allocate and clear core
	 * at this point, committed
	 * to the new image
	 */

	u.u_prof.pr_scale = 0;
	xfree();
	i = USIZE+ds+ss;
	expand(i);
	while (--i >= USIZE)
		clearseg(u.u_procp->p_addr+i);
	xalloc(ip);

	/*
	 * read in data segment
	 */

	estabur((unsigned)0, ds, (unsigned)0, 0, RO);
	u.u_base = 0;
	u.u_offset = sizeof(u.u_exdata)+u.u_exdata.ux_tsize;
	u.u_count = u.u_exdata.ux_dsize;
	readi(ip);
	/*
	 * set SUID/SGID protections, if no tracing
	 */
	if ((u.u_procp->p_flag&STRC)==0)
	{
		if (ip->i_mode&ISUID)
			if (u.u_uid != 0)
			{
				u.u_uid = ip->i_uid;
				u.u_procp->p_uid = ip->i_uid;
			}
		if (ip->i_mode&ISGID)
			u.u_gid = ip->i_gid;
	}
	else
		psignal(u.u_procp, SIGTRAP);
	u.u_tsize = ts;
	u.u_dsize = ds;
	u.u_ssize = ss;
	u.u_sep = sep;
	estabur(ts, ds, ss, sep, RO);
}

/*
 * Clear registers on exec
 */
setregs()
{
	register int *rp;
	register char *cp;
	register i;

	for (rp = &u.u_signal[0]; rp < &u.u_signal[NSIG]; rp++)
		if ((*rp & 1) == 0)
			*rp = 0;
	u.u_r.r_r0 = 0;		/* r0 */
	u.u_r.r_r1 = 0;		/* r1 */
	for (cp = &regloc[2]; cp < &regloc[6];)
		u.u_ar0[*cp++] = 0;
	u.u_ar0[R7] = u.u_exdata.ux_entloc & ~01;
	u.u_ar0[RPS] &= ~017;		/* clean up the new PS */
	for (rp = (int *)&u.u_fps.u_fpregs[0]; rp < (int *)&u.u_fps.u_fpregs[6];)
		*rp++ = 0;		/* clear floating point regs */
	u.u_fps.u_fpsr = 05400;	/* trap undefined, overflow, conv. err */
	/*
	 * Remember file name for accounting.
	 */
	u.u_acflag &= ~AFORK;
	bcopy((caddr_t)u.u_dbuf, (caddr_t)u.u_comm, DIRSIZ);
}

/*
 * exit system call:
 * pass back caller's arg
 */
rexit()
{
	register struct a
	{
		int	rval;
	} *uap;

	uap = (struct a *)u.u_ap;
	exit((uap->rval & 0377) << 8);
}

/*
 * Release resources.
 * Save u. area for parent to look at.
 * Enter zombie state.
 * Wake up parent and init processes,
 * and dispose of children.
 */
exit(rv)
{
	register int i;
	register struct proc *p, *q;

	p = u.u_procp;
	p->p_flag &= ~(STRC|SULOCK);
	p->p_clktim = 0;
	u.u_cputl = 0;
	for (i=0; i<NSIG; i++)
		u.u_signal[i] = 1;
	if ((p->p_pid == p->p_pgrp) &&
	    (u.u_ttyp != NULL) && (u.u_ttyp->t_pgrp == p->p_pgrp))
	{
		register struct lnode *lp;

		u.u_ttyp->t_pgrp = 0;
		lp = p->p_lnode;
		lp->l_flags &= ~LOGGEDIN;
		if (lp->l_flags & ASYNCKILL)
			signal(p->p_pgrp, SIGKILL);
	}
	p->p_pgrp = 0;
	for (i=0; i<NOFILE; i++)
		if (u.u_ofile[i] != NULL)
			closef((unsigned)u.u_ofile[i] & ~01);
	plock(u.u_cdir);
	iput(u.u_cdir);
	if (u.u_rdir)
	{
		plock(u.u_rdir);
		iput(u.u_rdir);
	}
	xfree();
	acct();
	mfree(coremap, p->p_size, p->p_addr);
	p->p_lnode->l_muse -= p->p_size;
	p->p_stat = SZOMB;
	((struct xproc *)p)->xp_xstat = rv;
	((struct xproc *)p)->xp_utime = u.u_cutime + u.u_utime;
	((struct xproc *)p)->xp_stime = u.u_cstime + u.u_stime;
	if (p->p_pid == 1)
		printf("init dead (status 0%o)\n", rv);
	i = 0;
	for (q = &proc[1]; q < &proc[NPROC]; q++)
	{
		if (q->p_ppid == p->p_pid)	/* a child of this proc */
		{
			q->p_ppid = 1;		/* now a ward of the state */
			if (q->p_stat == SSTOP)
				setrun(q);
			else if (q->p_stat == SZOMB)	/* it's dead too */
				i++;
		}
		else if (p->p_ppid == q->p_pid)	/* parent of this proc */
			wakeup((caddr_t)q);
		if (p->p_pid == q->p_pgrp)
			q->p_pgrp = 0;
	}
	if (i && p->p_ppid != 1)
		wakeup((caddr_t)&proc[1]);
	swtch();	/* no return */
}

/*
 * Wait system call.
 * Search for a terminated (zombie) child,
 * finally lay it to rest, and collect its status.
 * Look also for stopped (traced) children,
 * and pass back status from them.
 */
wait()
{
	wait1(0);
}

wait1(flag)
{
	register f;
	register struct proc *p;

	f = 0;

loop:
	for (p = &proc[0]; p < &proc[NPROC]; p++)
	if (p->p_ppid == u.u_procp->p_pid)
	{
		f++;
		if (p->p_stat == SZOMB)
		{
			if (flag)		/* from limits system call */
				retlimits(p);
			p->p_lnode->l_refcount--;
			u.u_r.r_r0 = p->p_pid;
			u.u_r.r_r1 = ((struct xproc *)p)->xp_xstat;
			u.u_cutime += ((struct xproc *)p)->xp_utime;
			u.u_cstime += ((struct xproc *)p)->xp_stime;
			p->p_pid = 0;
			p->p_ppid = 0;
			p->p_pgrp = 0;
			p->p_sig = 0L;
			p->p_flag = 0;
			p->p_wchan = 0;
			p->p_stat = NULL;
			return;
		}
		if (p->p_stat == SSTOP)
		{
			if ((p->p_flag&SWTED) == 0)
			{
				p->p_flag |= SWTED;
				u.u_r.r_r0 = p->p_pid;
				u.u_r.r_r1 = (fsig(p)<<8) | 0177;
				return;
			}
			continue;
		}
	}
	if (f)
	{
		sleep((caddr_t)u.u_procp, PWAIT);
		goto loop;
	}
	u.u_error = ECHILD;
}

/*
 * fork system call.
 */
fork()
{
	register struct proc *p1, *p2;
	register struct lnode *lp;
	int a;

	/*
	 * Make sure there's enough swap space for max
	 * core image, thus reducing chances of running out
	 */
	if ((a = malloc(swapmap, ctod(MAXMEM))) == 0)
	{
		u.u_error = ENOMEM;
		goto out;
	}
	mfree(swapmap, ctod(MAXMEM), a);
	a = 0;
	p2 = NULL;
	for (p1 = &proc[0]; p1 < &proc[NPROC]; p1++)
	{
		if (p1->p_stat==NULL && p2==NULL)
			p2 = p1;
		else
		{
			if (p1->p_uid==u.u_uid && p1->p_stat!=NULL)
				a++;
		}
	}
	/*
	 * Disallow if
	 *  No processes at all; or
	 *  not su and would take last slot.
	 */
	if (p2 == NULL || (u.u_uid != 0 && p2 == &proc[NPROC-1]))
	{
		u.u_error = EAGAIN;
		goto out;
	}
	p1 = u.u_procp;
	lp = p1->p_lnode;
	if (lp->l_plimit && lp->l_refcount >= lp->l_plimit)
	{
		u.u_error = EPLIM;
		goto out;
	}
	if (lp->l_mlimit)
	{
/* temporarily disabled by KFH
		if ((lp->l_muse + p->p_size) > lp->l_mlimit)
		{
			uprints("Memory limit reached\n");
			u.u_error = EMLIM;
			goto out;
		}
*/
		lp->l_muse += p1->p_size;
	}
	if (newproc())
	{
		u.u_r.r_r0 = p1->p_pid;
		u.u_start = time;
		u.u_cstime = 0;
		u.u_stime = 0;
		u.u_cutime = 0;
		u.u_utime = 0;
		u.u_locki = NULL;
		u.u_lockf = 0;
		u.u_acflag = AFORK;
		return;
	}
	u.u_r.r_r0 = p2->p_pid;

out:
	u.u_ar0[R7] += NBPW;
}

/*
 * break system call.
 *  -- bad planning: "break" is a dirty word in C.
 */
sbreak()
{
	struct a
	{
		char	*nsiz;
	};
	register a, n, d;
	int i;

	/*
	 * set n to new data size
	 * set d to new-old
	 * set n to new total size
	 */

	n = btoc((int)((struct a *)u.u_ap)->nsiz);
	if (!u.u_sep)
		n -= ctos(u.u_tsize) * stoc(1);
	if (n < 0)
		n = 0;
	d = n - u.u_dsize;
	n += USIZE+u.u_ssize;
	if (estabur(u.u_tsize, u.u_dsize+d, u.u_ssize, u.u_sep, RO))
		return;
	u.u_dsize += d;
	if (d > 0)
		goto bigger;
	a = u.u_procp->p_addr + n - u.u_ssize;
	i = n;
	n = u.u_ssize;
	while (n--)
	{
		copyseg(a-d, a);
		a++;
	}
	expand(i);
	return;

bigger:
	expand(n);
	a = u.u_procp->p_addr + n;
	n = u.u_ssize;
	while (n--)
	{
		a--;
		copyseg(a-d, a);
	}
	while (d--)
		clearseg(--a);
}
