#include <param.h>
#include <systm.h>
#include <callo.h>
#include <seg.h>
#include <dir.h>
#include <signal.h>
#include <user.h>
#include <proc.h>
#include <reg.h>

extern struct proc proc[];
extern struct user u;

struct cblock *tfreelist = NULL;	/* head of timeout reserve list */
struct cblock *thead = NULL;		/* head of the timeout list */
char tfreecount;			/* size of reserve list */
char ntimeouts;				/* size of active timeout list */
extern struct cblock *getcf();

#define	SCHMAG	8/10

/*
 * clock is called straight from
 * the real time clock interrupt.
 *
 * Functions:
 *	reprime clock
 *	copy *switches to display
 *	implement callouts
 *	maintain user/system times
 *	maintain date
 *	profile
 *	lightning bolt wakeup (every second)
 *	alarm clock signals
 *	jab the scheduler
 */

clock(dev, sp, r1, nps, r0, pc, ps)
dev_t dev;
caddr_t pc;
{
	register struct timout *tp;
	register struct proc *pp;

	/*
	 * restart clock
	 */

	lks->r[0] = 0115;

	/*
	 * display register
	 */

	display();
	/*
	 * callouts
	 * if none, just continue
	 * else update first non-zero time
	 */

	tp = (struct timout *)thead;
	while (tp != NULL)
	{
		if (tp->ti_time)
		{
			tp->ti_time--;
			break;
		}
		tp = tp->ti_next;
	}

	/*
	 * if ps is high, just return
	 */
	if (BASEPRI(ps))
		goto out;

	/*
	 * callout
	 */

	spl5();
	while ((tp = (struct timout *)thead) != NULL && tp->ti_time == 0)
	{
		register int (*func)();
		register caddr_t a;

		func = tp->ti_func;
		a = tp->ti_arg;
		thead = tp->ti_next;
		if (tfreecount < NTFREE)
		{
			tfreecount++;
			tp->ti_next = tfreelist;
			tfreelist = tp;
		}
		else
			putcf(tp);
		ntimeouts--;
		(*func)(a);
	}

	/*
	 * lightning bolt time-out
	 * and time of day
	 */
out:
	if (USERMODE(ps))
	{
		u.u_utime++;
		if(u.u_prof.pr_scale)
			addupc(pc, &u.u_prof, 1);
	}
	else
	{
		u.u_stime++;
	}
	pp = u.u_procp;
	if(++pp->p_cpu == 0)
		pp->p_cpu--;
	lticks++;			/* time in ticks */
	if(++lbolt >= HZ)
	{
		if (BASEPRI(ps))
			return;
		lbolt -= HZ;
		++time;
		spl1();
		runrun++;
		wakeup((caddr_t)&lbolt);
		if (u.u_cputl && --u.u_cputl == 0)
			psignal(pp, SIGCPUTL);
		for(pp = &proc[0]; pp < &proc[NPROC]; pp++)
			if (pp->p_stat && pp->p_stat<SZOMB)
			{
				register a;
	
				if(pp->p_time != 127)
					pp->p_time++;
				if(pp->p_clktim && --pp->p_clktim == 0)
					psignal(pp, SIGALRM);
/* DEBUG - KFH
				a = (pp->p_cpu & 0377)*SCHMAG + pp->p_nice - NZERO;
DEBUG - KFH */
/* DEBUG - KFH */		a = (pp->p_cpu & 0377) + pp->p_nice - NZERO - 5;
				if(a < 0)
					a = 0;
				if(a > 255)
					a = 255;
				pp->p_cpu = a;
				if(pp->p_pri >= PUSER)
					setpri(pp);
			}
		if(runin!=0)
		{
			runin = 0;
			wakeup((caddr_t)&runin);
		}
		if (USERMODE(ps))
		{
			pp = u.u_procp;
			if (pp->p_uid != 0 && pp->p_nice < NZERO+10 &&
			    u.u_utime > 30*HZ)
				pp->p_nice += 10;
		}
	}
}

/*
 * timeout is called to arrange that
 * fun(arg) is called in tim/HZ seconds.
 * An entry is sorted into the callout
 * structure. The time in each structure
 * entry is the number of HZ's more
 * than the previous entry.
 * In this way, decrementing the
 * first entry has the effect of
 * updating all entries.
 *
 * Timeout returns NULL if there are no blocks available,
 * or the number of timeouts has exceeded NCALL.
 */
timeout(fun, arg, tim)
int (*fun)();
caddr_t arg;
register tim;
{
	register struct timout *p1, *p2;
	struct timout *p3;
	int s;

	if (ntimeouts >= NCALL)
		return(NULL);
	p1 = thead;
	p2 = NULL;
	p3 = NULL;
	s = spl7();
	while (p1 != NULL)
	{
		if (tim <= p1->ti_time)
		{
			p1->ti_time -= tim;
			p3 = p1;
			break;
		}
		tim -= p1->ti_time;
		p2 = p1;
		p1 = p1->ti_next;
	}
	/*
	 * The item is now added after p2 (if not NULL),
	 * or at the start of the queue
	 */
	if ((p1 = (struct timout *)getcf()) == NULL)
	{
		if ((p1 = tfreelist) == NULL)
		{
			if ((p1 = p3) != NULL)
				p1->ti_time += tim;
			splx(s);
			return(NULL);
		}
		tfreelist = p1->ti_next;
		tfreecount--;
	}
	if (p2 == NULL)
	{
		p1->ti_next = thead;
		thead = p1;
	}
	else
	{
		p1->ti_next = p2->ti_next;
		p2->ti_next = p1;
	}
	p1->ti_time = tim;
	p1->ti_func = fun;
	p1->ti_arg = arg;
	ntimeouts++;
	splx(s);
	return(p1);
}
