/ C library -- signal

/ signal(n, 0); /* default action on signal(n) */
/ signal(n, odd); /* ignore signal(n) */
/ signal(n, label); /* goto label on signal(n) */
/ returns old label, only one level.

/ On receipt of a caught signal, the indicated routine is called,
/ with ps and pc on the stack (if possible). If a system call was
/ interrupted, r0 will contain EINTR. An assembler routine (below)
/ is called to stack other registers so that the interrupted
/ C-routine can be continued.

EINVAL	= 22.
.signal	= 48.
.globl	_signal, cerror

_signal:
	mov	r5,-(sp)
	mov	sp,r5
	mov	4(r5),r1	/ signal number
	cmp	r1,$NSIG
	bhis	2f
	mov	6(r5),r0	/ action
	mov	r1,0f
	asl	r1
	mov	dvect(r1),-(sp)	/ previous action
	mov	r0,dvect(r1)
	mov	r0,0f+2
	beq	1f
	bit	$1,r0
	bne	1f
	asl	r1
	add	$tvect,r1
	mov	r1,0f+2		/ alter action address
1:
	sys	0; 9f
	bes	3f
	bit	$1, r0		/ if ignored by parent, dvect will be incorrect
	beq	1f
	mov	r0, (sp)	/ ... so correct it
1:
	mov	(sp)+,r0
	mov	(sp)+,r5
	rts	pc
2:
	mov	$EINVAL,r0
3:
	jmp	cerror

NSIG = 0
tvect:
	jsr	r0,1f; NSIG=NSIG+1	/ 0
	jsr	r0,1f; NSIG=NSIG+1	/ 1 = hangup
	jsr	r0,1f; NSIG=NSIG+1	/ 2 = interrupt
	jsr	r0,1f; NSIG=NSIG+1	/ 3 = quit
	jsr	r0,1f; NSIG=NSIG+1	/ 4 = illegal instruction
	jsr	r0,1f; NSIG=NSIG+1	/ 5 = trace or bpt
	jsr	r0,1f; NSIG=NSIG+1	/ 6 = iot
	jsr	r0,1f; NSIG=NSIG+1	/ 7 = emt
	jsr	r0,1f; NSIG=NSIG+1	/ 8 = floating exception
	jsr	r0,1f; NSIG=NSIG+1	/ 9 = kill
	jsr	r0,1f; NSIG=NSIG+1	/ 10 = bus error
	jsr	r0,1f; NSIG=NSIG+1	/ 11 = segmentation violation
	jsr	r0,1f; NSIG=NSIG+1	/ 12 = bad system call
	jsr	r0,1f; NSIG=NSIG+1	/ 13 = pipe
	jsr	r0,1f; NSIG=NSIG+1	/ 14 = alarm clock
	jsr	r0,1f; NSIG=NSIG+1	/ 15 = terminate
	jsr	r0,1f; NSIG=NSIG+1	/ 16 = cpu time limit
	jsr	r0,1f; NSIG=NSIG+1	/ 17
	jsr	r0,1f; NSIG=NSIG+1	/ 18
	jsr	r0,1f; NSIG=NSIG+1	/ 19

1:					/ called from above; r0 already saved
	mov	r1,-(sp)		/ r2-r5 saved on entry to C routine
	sub	$tvect+4,r0
	asr	r0
	mov	r0,-(sp)
	asr	(sp)			/ signal number received
	jsr	pc,*dvect(r0)		/ call C routine
	tst	(sp)+			/ lose signal number
	mov	(sp)+,r1
	mov	(sp)+,r0
	rtt				/ popped ps may set T bit
.data
9:
	sys	.signal; 0:..; ..
.bss
dvect:	.=.+[NSIG*2]
