/*
**	write to another user
**
**	setgid to DAEMON
*/

#include	<local-system>
#include	<sys/param.h>
#include	<sys/stat.h>
#include	<stdio.h>
#include	<signal.h>
#include	<utmp.h>
#include	<passwd.h>

char		*strcat();
char		*strcpy();
char		*strchr();

short		signum[] =
{
	SIGHUP, SIGINT, SIGQUIT, 0
};
char		*myname;
char		*eofstr	= "SIG\n";
char		dev[]	= "/dev/";
char		othertty[sizeof dev + LINESIZ];
char		mytty[1+LINESIZ];
char		utmpf[]	= UTMPF;
short		valid;
short		redirected;
short		otvalid;
short		logcnt;
int		eof();
int		timout();
FILE		*tf;
char		*name;
short		to;

#define	STREQUAL	0	/* value returned by "strcmp" for equal strings */




main(argc, argv)
	register int	argc;
	register char	*argv[];
{
	register FILE	*uf;
	char *		target;
	struct stat	stbuf;
	char		sbuf[SSIZ];
	struct utmp	ubuf;
	struct pwent	me, other;

	name = *argv;

	if(argc < 2)
	{
		printf("usage: write user [ttyname]\n");
		return 1;
	}
	if ( argc > 2 )
	{
		target = argv[2];
		othertty[0]++;
	}

	other.pw_strings[LNAME] = argv[1];
	if ( getpwuid( &other, (char *)0, 0 ) == PWERROR )
	{
		printf( "Who?\n" );
		return 1;
	}

	me.pw_limits.l_uid = getuid();
	if ( getpwlog( &me, sbuf, SSIZ ) == PWERROR )
	{
		printf( "Who are you?\n" );
		return 1;
	}

	if ( !isatty(1) || !isatty(2) )
		redirected++;
	else
		if ( fstat( 2, &stbuf ) == SYSERROR )
		{
			perror( "stderr" );
			return 1;
		}

	if ((uf = fopen(utmpf, "r")) == NULL)
	{
		perror( utmpf );
		return 1;
	}

	while (fread((char *)&ubuf, sizeof(ubuf), 1, uf) == 1)
	{
		if ( ubuf.ut_line[0] == 0 )
			continue;	/* unallocated */

		if ( ubuf.ut_uid == other.pw_limits.l_uid )
		{
			logcnt++;
			if ( othertty[0]==0 || (target && strncmp(target+strlen(target)-2, ubuf.ut_line+strlen(ubuf.ut_line)-2, 2) == STREQUAL) )
			{
				strcpy(othertty, dev);
				strncat(othertty, ubuf.ut_line, LINESIZ);
				otvalid++;
			}
		}
		if ( !redirected && ubuf.ut_ttyid == stbuf.st_rdev )
		{
			valid++;
			if ( me.pw_limits.l_uid != ubuf.ut_uid )
			{
				me.pw_limits.l_uid = ubuf.ut_uid;
				getpwlog(&me, sbuf, SSIZ);
			}

			strncpy(mytty, ubuf.ut_line, LINESIZ);
		}
	}
	fclose(uf);

	if ( !valid && !redirected )
	{
		printf( "Can't find your tty\n" );
		return 1;
	}

	myname = me.pw_strings[LNAME];

	if (argc == 2 && logcnt > 1 && otvalid)
	{
		printf("%s logged more than once\nwriting to %s\n", argv[1], othertty+(sizeof dev - 1));
	}
	else
	if(otvalid == 0 || logcnt == 0)
	{
		printf( "%s not %s\n", argv[1], logcnt?"on that tty":"logged in" );
		return 1;
	}

	signal(SIGALRM, timout);
	alarm(5);
	if ((tf = fopen(othertty, "w")) == NULL)
	{
		alarm(0);
		goto perm;
	}
	alarm(0);

	setgid( getgid() );
	sigs(eof);
	fprintf(tf, "\n\7Message from %s on %s", myname, SYSTEMID);
	if( !redirected )
		fprintf(tf, " at %s...\7", mytty);
	fprintf(tf, "\n");

	if ( to )
	{
		register	i;

		for ( i = 2 ; i < argc ; i++ )
		{
			register char *	cp;
			register	c;

			for ( cp = argv[i] ; c = *cp ; cp++ )
				if ( c < ' ' || c >= 0177 )
					*cp = '?';
			fprintf(tf, " %s", argv[i]);
		}

		fprintf(tf, "\n");

		return 0;
	}

	fflush(tf);

	for(;;)
	{
		register	i, c;
		register char	*p;
		char		buf[128];

		if ( (i = read(0, buf, 128)) <= 0 )
		{
			eofstr = "EOF\n";
			eof();
		}
		if(buf[0] == '!')
		{
			buf[i] = 0;
			ex(buf);
			continue;
		}
		for ( p = buf ; p < &buf[i] ; p++ )
			if ( (c = *p & 0177) < ' ' )
				switch ( c )
				{
				case '\n':
				/* case '\f': */
				case '\b':
				case '\r':
				case '\t':
					break;

				default:
					*p = '\007';
				}
		write(fileno(tf), buf, i);
	}

perm:
	printf("Permission denied\n");
	return 1;
}

timout()
{
	printf("Timeout opening other tty\n");
	exit(1);
}

eof()
{
	fprintf(tf, eofstr);
	exit(0);
}

ex(bp)
char *bp;
{
	register i;

	sigs(SIG_IGN);
	switch ( i = fork() )
	{
	case SYSERROR:
		printf("Try again\n");
		goto out;
	case 0:
		sigs((int (*)())0);
		execl("/bin/sh", "sh", "-c", bp+1, 0);
		exit(0);
	default:
		while(wait((int *)NULL) != i) ;
	}
	printf("!\n");
out:
	sigs(eof);
}

sigs(sig)
int (*sig)();
{
	register i;

	for(i=0;signum[i];i++)
		signal(signum[i],sig);
}
