/*	To print the words of the dictionary with a particular prefix */
/*	The prefix may be of zero characters! */
/*	Upper and lower case characters are treated as identical */
/*	This was designed for use with the editor ED for checking spelling */
/*	Author G. R. Smith UNSW 5/6/1981.	*/

#define	DICTFILE	"/usr/dict/words"
#define MAXWORDLEN	60
long	lseek();

int		n;	/* Number of blocks in the dictionary */

char		*key;	/* What to look for */
char		lblock[01000];	/* last block read from dictionary */
int		lnum;	/* Block number in lblock */
char		*lend;	/* Position of last char in lblock */


main(argc,argv)
int		argc;
char		**argv;
{
register	int	hi,mid,lo;	/* binary search bounds */
char		*p;
if(argc != 2)
	{
	prints("Predict : Expected word prefix\n");
	exit(1);
	}
key = argv[1];
close(0);
if(open(DICTFILE,0) != 0)
	{
	prints("Predict : Dictionary not found\n");
	exit(2);
	}
n = lseek(0,0L,2) >> 9;	/* Find the size of the dictionary */
lo = -1;
hi = n > 0 ? n + 1 : 0;
lnum = -1;	/* lblock contains rubbish */
/*	Binary search on the dictionary blocks */
while(lo + 1 != hi)
	{
	mid = (lo + hi) / 2;
	if(blook(mid))
		lo = mid;
	else
		hi = mid;
	}
if(lo <= 0)
	{
	if(lnum != 0)
		inblock(0);
	if(lend != &lblock[-1])
		match(lblock);
	}
else
	{
	if(lnum != lo)
		inblock(lo);
	p = lblock;
	while(*(p++) != '\n');
	match(p);
	}
exit(0);
}


blook(b)
int		b;
{
register	char	*kp,*sp;

/*	Look at the first complete word in the block and compare with key */
/*	ie ignore trash preceeding first \n */
/*	Return zero if key strictly before the first complete word */
/*	else return non-zero	*/

inblock(b);
sp = lblock;
/*	Find the start of the first word */
while(*(sp++) != '\n');
if(sp > lend)
	return(0);	/* end of the file */
kp = key;
/*	Skip to first mismatch */
while(cequal(*sp++,*kp++));
--sp;--kp;
return((*kp == '\0' && *sp == '\n') || clow(*kp) > clow(*sp));
}

cequal(a,b)
char		a,b;
{
/*	Characters equal, Upper - lower case mapped */
if(a == b)
	return(1);
else
	{
	a = clow(a);
	b = clow(b);
	return(a == b);
	}
}

clow(a)
char		a;
{
/*	Translate character to force lower case */
if(a >= 'A' && a <= 'Z')
	a += 'a' - 'A';
return(a);
}

match(sp)
register	char	*sp;
{
register	char	*kp;
char		chr;
char		word[MAXWORDLEN];	/* Safe place for word under construction */
register	char	*wp;

/*	Print matches from current position sp until had enough */
do
	{
	kp = key;
	wp = word;
	while(cequal(*kp,*sp))
		{
		*wp++ = *sp;
		kp++;
		if(sp == lend)
			{
			inblock(lnum + 1);
			sp = lblock;
			}
		else
			sp++;
		}
	if(*kp != '\0' && *kp < *sp)
		break;	/* No need to continue */
	do	/* Process remainder of the word up till \n */
		{
		chr = *sp;
		*wp++ = chr;
		if(sp == lend)
			{
			inblock(lnum + 1);
			sp = lblock;
			}
		else
			sp++;
		}	while(chr != '\n');
	if(*kp == '\0')	/* Got a hit */
		write(1,word,wp - word);
	}	while(lnum <= n);
}

prints(string)
char		*string;
{
write(2,string,strlen(string));
}

inblock(bnum)
int		bnum;
{
lnum = bnum;
lseek(0, (long) lnum << 9, 0);
lend = &lblock[read(0,lblock,01000) -1];
}
