#include <stdio.h>
#include <ctype.h>
#include "lrnref"
#ifdef UNSW
#include <passwd.h>
#include <class.h>
#define	CLSIZ	64
#endif

selsub(argc,argv)
char *argv[];
{
	char ans1[100], *cp;
	static char ans2[50];
	static char dirname[80];
	static char subname[20];
#ifdef UNSW
	static char pbuf[SSIZ];
	static char classbuf[CLSIZ];
	static struct pwent  pe;
#else
	static char *home;
	static char playdir[60];
#endif

	if (argc > 1 && argv[1][0] == '-') {
		direct = argv[1]+1;
		argc--;
		argv++;
	}
	chknam(direct);
	if (chdir(direct) != 0) {
		fprintf(stderr, "can't cd to %s\,", direct);
		exit(1);
	}
	sname = argc > 1 ? argv[1] : 0;
	if (argc > 2)
		strcpy (level=ans2, argv[2]);
	else
		level = NULL;
	if (argc > 3 )
		speed = atoi(argv[3]);
#ifdef UNSW
	pe.pw_uid= getuid();
	if (getpwlog(&pe,pbuf,SSIZ) <= 0)
	{
		name = lastname = pbuf;
		name[0]= '\0';
	}
	else
	{
		register	i;
		register char	*cp;

		name= pe.pw_strings[FIRSTNAME+3];
		lastname= pe.pw_strings[LASTNAME+3];

		for (i=0; i<NCLASS && (cp = classes[i].c_name); ++i)
			if (pe.pw_limits.l_cmask[classes[i].c_index]
					& classes[i].c_mask)
			{
				sprintf(classbuf,"%-10s%s",pwline,cp);
				pwline = classbuf;
				break;
			}
	}
#else
	name= &dirname[79];  name[0]= '\0';
#endif
	if (!sname) {
		printf ("Hello %s, welcome to 'learn'\n\n",name);
		printf("These are the available courses -\n");
		list("Linfo");
		printf("If you want more information about the courses,\n");
		printf("or if you have never used 'learn' before,\n");
		printf("press the RETURN key; otherwise type the name\n");
		printf("of the course you want (don't forget RETURN).\n");
		fflush(stdout);
		gets(sname=subname);
		if (sname[0] == '\0') {
			list("Xinfo");
			do {
				printf("\nWhich subject, %s?  ",name);
				fflush(stdout);
				gets(sname=subname);
			} while (sname[0] == '\0');
		}
	}
	chknam(sname);
	if (!level) {
		printf("If you were in the middle of this subject\n");
		printf("and want to start where you left off, type\n");
		printf("the last lesson number the computer printed.\n");
		printf("To start at the beginning, just hit RETURN.\n");
		fflush(stdout);
		gets(ans2);
		if (ans2[0]==0)
			strcpy(ans2,"0");
		for (cp=ans2; *cp; cp++)
			if (*cp == '(' || *cp == ' ')
				*cp= 0;
		level=ans2;
	}

#ifndef UNSW
	/* make new directory for user to play in */
	if ( (home = getenv("HOME")) == (char *)0)
	{	fprintf(stderr, "Learn: no HOME directory!\n");
		exit();
	}

	sprintf(playdir, "%s/play", home);

	if (chdir(playdir) != 0) 
	{	sprintf(ans1, "mkdir %s", playdir);
		system(ans1);
		if ( chdir(playdir) != 0 )
		{	fprintf(stderr, "Learn: cannot change to %s\n",playdir);
			exit(1);
		}
	}
	sprintf(dir=dirname, "%s/pl%da", playdir, getpid());
#else
	/* pad level if only integer specified */

	if (strcmp(level,"0") != 0)
	{
		for (cp=level; isdigit(*cp); ++cp)  ;
		if (*cp != '.')
			strcpy(cp,".1a");
	}

	/* make temporary directory for user to play in */

	sprintf(dir=dirname, "/tmp/lrn%x.%d",getuid(),getpid());
#endif
	sprintf(ans1, "mkdir %s", dir);
	system(ans1);
	if (chdir(dir) < 0) {
		fprintf(stderr, "Couldn't create working directory.\nBye.\n");
		exit(1);
	}
	/* after this point, we have a working directory. */
	/* have to call wrapup to clean up */
	if (access(sprintf(ans1, "%s/%s/Init", direct, sname), 04)==0)
		if (system(sprintf(ans1, "%s/%s/Init %s", direct,sname, level)) != 0) {
			printf("Leaving learn.\n");
			wrapup(1);
		}
	if (level[0] == '-')	/* no lesson names start with - */
		ask = 1;
	start(level);
}

chknam(qname)
char *qname;
{
	if (access(qname, 05) < 0) {
		printf("Sorry, there is no subject or lesson named %s.\nBye, %s.\n", qname, name);
		exit(1);
	}
}
