#include "draw.h"
FILE *plotfile;

wplot(arg1, arg2)
char *arg1, *arg2;
{
	register struct symbol *p;
	register FILE *outfile;

	if((p = lookup(arg1)) == NULL)
	{
		warn("unknown module\n");
		return;
	}

	if((outfile = fopen(arg2, "w")) == NULL)
	{
		perror(arg2);
		oldline();
		return;
	}


	plotfile = outfile;
	draw(0.0, 0.0, p->list->mod.up);

	fprintf(outfile, "\n");
	if(ferror(outfile))
		warn("write error\n");
	fclose(outfile);
	plotfile = NULL;
}

#define PLOTTER "/bin/plotter"
#define PROMPTON "\007\033AK"
#define PROMPTOFF "\033AL"

jmp_buf plotenv;
int plotting = 0;

plot(arg1)
char *arg1;
{
	register i;
	int status = 0;
	FILE *save = g_out;
	int pipdes[2];

	int levsav = levelmask;
	register j;
	int ploterr = 0;


	fflush(stdout);
	pipe(pipdes);
	switch (i = fork())
	{
	case -1:	perror("fork");
			break;
	case 0:
			close(fileno(tempfile));
			close(pipdes[1]); /* close write end */
			close(0);
			dup(pipdes[0]);
			close(pipdes[0]);
			execl(PLOTTER, PLOTTER, 0);
			perror(PLOTTER);
			exit(1);
	default:
			close(pipdes[0]); /* close the read side */
			plotting = 1;
			if(!setjmp(plotenv))
			{
				g_out = fdopen(pipdes[1], "w");
				for(j = 1;j <= 1<<8; j<<= 1)
				{
					if(levsav & j)
					{
						fprintf(g_out, PROMPTON);
						fprintf(g_out, PROMPTOFF);
						levelmask = j;
						print1(arg1);
					}
				}
			}
			else
			{
				ploterr++;
			}
			plotting = 0;
			levelmask = levsav;
			fclose(g_out);
			g_out = save;
			while(i != wait(&status));
			if(status)
				printf("plotter returns %d\n", status);
			break;
	}
	if(ploterr)
		mhelp();
}
