/*
 *	date [-u] [[[[[[yy]mm]dd]hh]mm]ss]
 */ 

#include	<local-system>
#include	<sys/types.h>
#include	<sys/fcntl.h>
#include	<time.h>
#include	<wtmp.h>


extern
char		*asctime(),
		*tzname[];
extern
struct tm	*localtime(),
		*gmtime();

extern
long		timezone;
extern
char		dmsize[];




main(argc, argv)
	register int	argc;
	register char	*argv[];
{
	register char	*ap;
	register int	uflag;
	long		timebuf;
	struct dtmp	dtmp;
	struct tm	*tp;
	int		confirm = 0;
	extern long	gtime();

	if (argc > 1 && argv[1][0] == '-' && argv[1][1] == 'u')
	{
		argc--;
		argv++;
		uflag = 1;
	}
	else
		uflag = 0;

	time(&timebuf);

	if (argc > 1)
	{
		register int	wf;

		dtmp.d_oldtime = timebuf;
		dtmp.d_type = D_TYPE;

		if ((timebuf = gtime(timebuf, argv[1])) == 0 )
		{
			printf("Usage: date [[[[[[yy]mm]dd]hh]mm]ss]\n");
			exit(1);
		}

		if (!uflag)
		{
			tp = localtime(timebuf);
			if (tp->tm_isdst)
				timebuf -= 60*60;	/* daylight saving correction */
			timebuf += timezone;	/* convert to GMT */
		}

		if (peopleon())
		{
			printf("non-root people logged on");
			confirm++;
		}

		if (timebuf < dtmp.d_oldtime - 5 * 60)
		{
			printf("prior to the current time");
			confirm++;
		}
		else if (timebuf > dtmp.d_oldtime + 60 * 60)
		{
			printf("more than one hour in advance");
			confirm++;
		}

		if (confirm)
		{
			static char	c = '\n';

			printf(": change? (y or n) ");
			read(0, &c, 1);
			wf = c;
			while (c != '\n' && read(0, &c, 1) == 1);
			if (wf != 'y')
				exit(1);
		}

		if (stime(&timebuf) == SYSERROR)
		{
			printf("No permission\n");
			exit(1);
		}

		if ((wf = open(WTMPF, O_WRITE|O_APPEND)) != SYSERROR)
		{
			dtmp.d_newtime = timebuf;
			write(wf, (char *)&dtmp, sizeof dtmp);
			close(wf);
		}
	}

	if (uflag)
	{
		tp = gmtime(timebuf);
		tzname[0] = "GMT";
	}
	else
		tp = localtime(timebuf);

	ap = asctime(tp);

	printf("%.20s", ap);
	printf("%s", tzname[tp->tm_isdst]);
	printf("%s", ap+19);
	exit(0);
}



long
gtime(atimbuf, cp)
	long			atimbuf;
	char			*cp;
{
	register int		i;
	register int		*ip;
	register struct tm	*tvec;
	register long		timbuf = atimbuf;
	register int		y, t, d, h, m, s;

	tvec = localtime(atimbuf);

	y = tvec->tm_year;
	t = tvec->tm_mon + 1;
	d = tvec->tm_mday;
	h = tvec->tm_hour;
	m = tvec->tm_min;
	i = 0;
	ip = (int *)tvec;	/* use tm struct as a workarea */

	while ((*ip++ = gpair(&cp)) >= 0)
		if (i++ >= 6)
			return(0);
	if (i == 0)
		return(0);
	ip = (int *)tvec;

	switch(i)
	{
    case 6:	y = *ip++;
    case 5:	t = *ip++;
    case 4:	d = *ip++;
    case 3:	h = *ip++;
    case 2:	m = *ip++;
    case 1:	s = *ip++;
	}

	if (y < 70 || t < 1 || t > 12 || d < 1 || d > 31 ||
	    h > 23 || m > 59 || s > 59)
		return(0);
	y += 1900;
	timbuf = 0;
	for (i = 1970; i < y; i++)
		timbuf += dysize(i);
	if (dysize(y) == 366 && t >= 3)
		timbuf++;	/* Leap year */
	while (--t)
		timbuf += dmsize[t-1];
	timbuf += d - 1;
	timbuf = timbuf * 24 + h;
	timbuf = timbuf * 60 + m;
	return(timbuf * 60 + s);
}


gpair(cbp)
	char		**cbp;
{
	register int	c, d;
	register char	*cp;

	cp = *cbp;
	if (*cp == 0)
		return(-1);
	c = *cp++ -'0';
	if (c < 0 || c > 9)
		return(-1);
	if (*cp == 0)
		return(-1);
	if ((d = *cp++ -'0') < 0 || d > 9)
		return(-1);
	*cbp = cp;
	return(c*10+d);
}


/*
 *	this routine checks if people other than root are logged on
 *	and returns 1 if so.
 */
peopleon()
{
	register	ufd;
	struct utmp	u;
	static char	utmpf[]	= UTMPF;

	if ((ufd = open(utmpf, 0)) == SYSERROR)
		return(0);

	while (read(ufd, (char *)&u, sizeof u) == sizeof u)
	{
		if (u.ut_line[0] != '\0' && u.ut_uid != 0)
		{
			close(ufd);
			return(1);
		}
	}

	close(ufd);
	return(0);
}
