char tape[] = "/dev/rmt0";
#define	DENS	6
#define	UNIT	8
char ntape[] = "/dev/rnmt0";
#define	NDENS	7
#define	NUNIT	9
char *tp = tape;
char bigfellah[48 * 512];
char master[] = "xxxxxxxxxxxxxx";
char slave[] = "xxxxxxxxxxxxxx";
int namend;

int tfd, ntfd, sfd, mfd;

struct
{
	unsigned short m_count;
	unsigned short m_size;
} m;

main(ac, av)
char **av;
{
	register char *cp;
	register int (*func)();
	int ontape(), offtape(), list();

	if (ac != 3)
		usage();
	func = 0;
	cp = av[1];
	while (*cp)
		switch(*cp++)
		{
	    case 'r':	func = ontape;
			break;

	    case 'x':	func = offtape;
			break;

	    case 't':	func = list;
			break;

	    case 'm':	break;

	    case 'h':	tape[DENS] = 'h';
			ntape[NDENS] = 'h';
			break;

	    case 'n':	tp = ntape;
			break;

	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':	tape[UNIT] = cp[-1];
			ntape[NUNIT] = cp[-1];
			break;

	    default:	usage();

		}
	if (func == 0)
		usage();
	init(av[2]);
	(*func)();
	exit(0);
}

usage()
{
	printf("Usage: ct [rtx][n][mh][01234567] name\n");
	exit(1);
}

init(s)
char *s;
{
	register char *cp;
	register n;

	cp = s;
	if (*cp == 0)
	{
		printf("illegal file name\n");
		exit(1);
	}
	while (*cp++);
	cp--;
	while (--cp > s && *cp != '/');
	if (*cp == '/')
	{
		if (cp == s)
		{
			if (chdir("/") < 0)
			{
				perror("/");
				exit(1);
			}
		}
		else
		{
			*cp = 0;
			if (chdir(s) < 0)
			{
				perror(s);
				exit(1);
			}
			*cp = '/';
		}
		cp++;
	}
	for (n = 0; n < 14; n++)
	{
		master[n] = *cp;
		slave[n] = *cp;
		if (*cp == 0)
			break;
		cp++;
	}
	if (n > 11)
	{
		printf("%s: name too long\n", s);
		exit(1);
	}
	master[n] = slave[n] = '.';
	master[n+1] = 'M';
	master[n+2] = 0;
	slave[n+1] = 'S';
	slave[n+2] = 0;
	namend = n + 2;
}

offtape()
{
	register n, size, count;
	long flsz;

	if ((tfd = open(tp, 0)) < 0)
	{
		perror(tape);
		exit(1);
	}
	if ((mfd = creat(master, 0600)) < 0)
	{
		perror(master);
		exit(1);
	}
	if ((sfd = creat(slave, 0600)) < 0)
	{
		perror(slave);
		exit(1);
	}
	flsz = 0;
	n = size = read(tfd, bigfellah, sizeof bigfellah);
	count = 1;
	do
	{
		if (n == -1)
		{
			perror(tape);
			exit(1);
		}
		flsz = flsz + n;
		if (flsz & 0xFF000000)	/* size would exceed 24 bits */
		{
			close(sfd);
			if (slave[namend] == 0)
			{
				slave[namend] = 'a';
				slave[namend + 1] = 0;
				master[namend - 1] = 'S';
				if (link(master, slave) < 0 ||
					unlink(master) < 0)
				{
					perror(slave);
					exit(1);
				}
				printf("%s renamed %s\n", master, slave);
			}
			slave[namend]++;
			if ((sfd = creat(slave, 0600)) < 0)
			{
				perror(slave);
				exit(1);
			}
			printf("%s created\n", slave);
			flsz = n;
		}
		if (write(sfd, bigfellah, n) != n)
		{
			perror(slave);
			exit(1);
		}
		n = read(tfd, bigfellah, sizeof bigfellah);
		if (n != size || count == -1)
		{
			m.m_size = size;
			m.m_count = count;
			write(mfd, &m, sizeof m);
			size = n;
			count = 1;
		}
		else count++;
	} while (n != 0 || count != 2);		/* 2 TMs ==> EOT */
}

ontape()
{
	register unsigned i, amount;

	if ((ntfd = open(ntape, 1)) < 0)
	{
		perror(ntape);
		exit(1);
	}
	if ((mfd = open(master, 0)) < 0)
	{
		perror(master);
		exit(1);
	}
	slave[namend] = 'a';
	slave[namend + 1] = 0;
	if ((sfd = open(slave, 0)) < 0)
	{
		slave[namend] = 0;
		if ((sfd = open(slave, 0)) < 0)
		{
			perror(slave);
			exit(1);
		}
	}
	while (read(mfd, &m, sizeof m) == sizeof m)
	{
		if (m.m_size == 0)	/* generate a TM */
		{
			close(ntfd);
			if (open(ntape, 1) != ntfd)
			{
				perror(ntape);
				exit(1);
			}
			continue;
		}
		if (m.m_size > sizeof bigfellah)
		{
			printf("size too large\n");
			exit(1);
		}
		for (i = 0; i < m.m_count; i++)
		{
			amount = read(sfd, bigfellah, m.m_size);
			if (amount == 0 && slave[namend])
			{
				close(sfd);
				slave[namend]++;
				if ((sfd = open(slave, 0)) < 0)
				{
					perror(slave);
					exit(1);
				}
				amount = read(sfd, bigfellah, m.m_size);
			}
			if (amount != m.m_size)
			{
				perror(slave);
				exit(1);
			}
			if (write(ntfd, bigfellah, m.m_size) != m.m_size)
			{
				perror(ntape);
				exit(1);
			}
		}
	}
	if (read(sfd, bigfellah, 1) != 0)	/* EOF */
	{
		printf(slave);
		printf(": should be at EOF\n");
		exit(1);
	}
	close(ntfd);
	close(open(tp, 0));		/* rewind */
}

list()
{
	if ((mfd = open(master, 0)) < 0)
	{
		perror(master);
		exit(1);
	}
	while (read(mfd, &m, sizeof m) == sizeof m)
	{
		if (m.m_size == 0)
			printf("TM\n");
		else
			printf("%d * %d\n", m.m_count, m.m_size);
	}
	printf("EOT\n");
}
