#include	<stdio.h>
#include	<param.h>
#include	<signal.h>
#include	<times.h>

#define	TLIMIT	15		/* cpu timelimit (seconds) on the job */

char macro[]	= "/bin/macro";
char link[]	= "/bin/link";
char froth[]	= "-o=";		/* partial arg to link */
char m_out[]	= "m.out";
char monitor[]	= "/lib/monitor";
char sdump[]	= "/bin/sdump";
char core[]	= "core";
char mac[]	= ".mac";		/* normal ending */
char obj[]	= ".obj";		/* replaces .mac */
char lst[]	= ".lst";		/* listing */

char usage[]	= "Usage: ass [-l] [-x] name[.mac] ...\n";

main(ac, av)
char *av[];
{
	register i, n;
	register char *cp;
	int stat;		/* for return statii */
	int listopt;		/* -l option */
	int noexec;		/* -x option */
	char **argv;
	char name[64];
	long chtime;
	struct tms tbuffer;

	if (ac < 2)
	{
		fprintf(stderr, usage);
		exit(1);
	}
	argv = av;
	listopt = 0;
	noexec = 0;
	ac--;
	av++;
	while (av[0][0] == '-')
	{
		if (strcmp(&av[0][1], "l") == 0)
		{
			ac--;
			av++;
			listopt++;
		}
		else if (strcmp(&av[0][1], "x") == 0)
		{
			ac--;
			av++;
			argv++;
			noexec++;
		}
		else
		{
			fprintf(stderr, usage);
			exit(1);
		}
	}
	for (i = 0; i < ac; i++)
	{
		cp = av[i];
		if (*cp == '-')		/* no options allowed */
		{
			fprintf(stderr, usage);
			exit(1);
		}
		while (*cp)
		{
			if (*cp == '.')
			{
				if (strcmp(cp, mac))
				{
					fprintf(stderr, usage);
					exit(1);
				}
				*cp = 0;		/* chop off the .mac */
				break;
			}
			cp++;
		}
	}
	cp = av[ac - 1];		/* the last filename */
	if (strlen(cp) + sizeof obj + sizeof froth + sizeof m_out - 1 > sizeof name)
	{
		fprintf(stderr, "%s too long - job cancelled\n", cp);
		exit(1);
	}
	strcpy(name, cp);	/* name now contains last filename stem */
	cp = &name[strlen(name)];
	strcat(name, obj);
	if ((i = fork()) == 0)
	{
		argv[0] = &macro[5];	/* pass all args to macro */
		if (listopt)
		{
			argv[1] = "-ls";	/* av[1] was the "-l" */
			/*
			 * number of errors still comes out on stdout.
			 * As this can garble the output, stdout is redirected
			 * to /null - NOTE: it cannot just be closed!
			 */
			close(1);
			open("/dev/null", 2);
		}
		execv(macro, argv);
		perror(macro);
		exit(1);
	}
	if (i == -1)
	{
		perror("fork");
		exit(1);
	}
	wait(&stat);
	if (listopt)
	{
		char buf[512];

		*cp = 0;
		strcat(name, lst);
		if ((i = open(name, 0)) != -1)
		{
			while ((n = read(i, buf, sizeof buf)) > 0)
				write(1, buf, n);
			unlink(name);
			*cp = 0;
			strcat(name, obj);
		}
		else if (stat == 0)
		{
			perror(name);
			exit(1);
		}
	}
	if (stat)
	{
		fprintf(stderr, "Assembly errors - execution cancelled\n");
		unlink(name);
		exit(1);
	}
	if ((i = fork()) == 0)
	{
		cp = &name[strlen(name) + 1];
		strcat(strcpy(cp, froth), m_out);
		execl(link, &link[5], cp, name, monitor, 0);
		perror(link);
		exit(1);
	}
	if (i == -1)
	{
		perror("fork");
		exit(1);
	}
	wait(&stat);
	if (stat)
	{
		fprintf(stderr, "Linkage failed - execution cancelled\n");
		exit(1);
	}
	unlink(name);
	times(&tbuffer);
	chtime = tbuffer.tms_cutime + tbuffer.tms_cstime;
	if (noexec)
		exit(0);
	if ((i = fork()) == 0)
	{
		fprintf(stderr, "Execution begins -\n");
		tlimit(TLIMIT);
		execl(m_out, m_out, 0);
		perror(m_out);
		exit(1);
	}
	if (i == -1)
	{
		perror("fork");
		exit(1);
	}
	wait(&stat);
	times(&tbuffer);
	chtime = tbuffer.tms_cutime + tbuffer.tms_cstime - chtime;
	listopt = (int)chtime;
	i = stat & 0377;
	if (i == 0)
	{
		printf("\n\t%d.%02d Sec execution time.\n",
			listopt / HZ, listopt % HZ);
		exit(0);
	}
	cp = &name[4];
	*--cp = 0;
	*--cp = (i & 07) + '0';
	i >>= 3;
	*--cp = (i & 07) + '0';
	i >>= 3;
	*--cp = (i & 03) + '0';
	if ((i = fork()) == 0)
	{
		execl(sdump, &sdump[9], name, 0);
		perror(sdump);
		exit(1);
	}
	wait(&stat);
	unlink(core);
	exit(0);
}
