/*
 *	pexec(name, argv)
 *	PWB interface to execv, performs standard directory search,
 *	using .path, if available. Corresponds to sh routine texec.
 *	uses sequence found in pathstr, if non-null.
 *	Much of code exists for reliability in large systems having
 *	many processes and heavy use of shell procedures.
 */
#define	E2BIG	7
#define	ENOMEM	12
#define	EACCES	13
#define	ETXTBSY	26
extern	errno;

pexec(f, at)
register *at;
{
	char txe2big, txeacces, txtbsy;

	txe2big = txeaccess = txtbsy = 0;
retry:
	execv(f, at);
	switch (errno) {
	case EACCES:
		txeacces++;	/* file there, missing x (probably) */
		break;
	case ENOMEM:
		pexerr(f, "too large");
		return;
	case E2BIG:
		txe2big++;
		break;
	case ETXTBSY:
		if ((txtbsy =+ 10) > 60) {
			pexerr(f, "text busy");
			return;
		}
		sleep(txtbsy);
		goto retry;
	}
	if (txe2big)
		pexerr(f, "arg list too long");
	else if (txeacces)
		pexerr(f, "file not executable");
	else
		pexerr(f, "not found");
}

pexerr(s1, s2)
char *s1, *s2;
{
	pexprs(s1);
	if (s2) {
		pexprs(": ");
		pexprs(s2);
	}
	pexprs("\n");
}

pexprs(s)
register char *s;
{
	while (*s)
		write(2, s++, 1);
}
