/*
**	Definitions for Network FTP header
*/

/*
**	FTP header  SOH <desthost> US <destname> RS
**			<orghost> US <orgname> RS
**			<dataction> US <datname> US <actparam> RS
**			<netstats>
**		    STX
*/

#define	SOH		1
#define	STX		2
#define	RS		036
#define	US		037

#define	HLEVELS		2			/* max levels in a host name */
#define	HOSTSIZE	((DIRSIZ+1)*HLEVELS)	/* max length of a host name */
#define	UNMSIZE		LOGLEN			/* max length of a user name */
#define	DNMSIZE		100			/* max length of a data name */
#define	MAXPARAMS	100			/* max length of action parameters */
#define	MAXSTATS	1000			/* max length of statistics */

/*
**	Global declarations for netheader.c
*/

char *			desthost;		/* destination host name */
char *			destname;		/* destination user name */
char *			orghost;		/* origin host name */
char *			orgname;		/* origin user name */
char *			dataction;		/* action for data */
char *			datname;		/* description of data */
char *			actparam;		/* parameters for action */
char *			netstats;		/* network statistics */

/*
**	Routines implemented by netheader.c
*/

extern int		netheader();		/* one arg: FILE * for input */
extern int		makeheader();		/* two args: FILE * for output, and time */

/*
**	routines called by netheader.c
*/

extern int		neterror();		/* one or more args passed to printf() */

extern char *		malloc();
extern char *		realloc();

/*
**	Statistics made up of host@time pairs separated by ':'
**	where "time" is decimal seconds UNIX GMT
*/
