/*
**	Compatibility routines
*/

#include	<local-system>
#include	<stdio.h>

pause()
{
	sleep(0x7fff);
}

char *
mytty()
{
	extern char	ttyn();
	static char	tty[]	= "/dev/ttyX";
#	define	XPOS			   8

	if ( (tty[XPOS] = ttyn(2)) == 'x' )
		return "/dev/null";
	return tty;
}

fcntl(fd1, mode, fd2)
{
	switch ( mode )
	{
	 case 0:	return dup2(fd1, fd2);
	}

	return SYSERROR;
}

ttyconnect(fd1, fd2, mode, quit)
	int	fd1, fd2, mode;
	char	quit;
{
	switch ( mode )
	{
	 case 1:	return connect(fd1, fd2, quit);
	}

	return SYSERROR;
}



/*
**	Own version of "ctime" ex level 7
*/

/*
**	buffer returned by localtime()
*/

struct	tm
{
	int	tm_sec;
	int	tm_min;
	int	tm_hour;
	int	tm_mday;
	int	tm_mon;
	int	tm_year;
	int	tm_wday;
	int	tm_yday;
	int	tm_isdst;
};


#define		DAYLBEGIN	(31+28+31+30+31+30+31+31+30+31-1)	/* Last Sunday in October */
#define		DAYLEND		(31+28+7)				/* First Sunday in March */

static char	cbuf[26];

char		dmsize[12] =
{
	31,
	28,
	31,
	30,
	31,
	30,
	31,
	31,
	30,
	31,
	30,
	31
};

long		timezone =	(long)GMT*60*60;
int		daylight =	0;	/* Don't allow daylight conversion */

struct tm *	gmtime();
char *		ct_numb();
struct tm *	localtime();
char *		ctime();
char *		asctime();

char *
ctime(t)
	long	t;
{
	return(asctime(localtime(t)));
}

struct tm *
localtime(tim)
	long	tim;
{
	register int dayno;
	register struct tm *ct;
	register daylbegin, daylend;
	long copyt;

	copyt = tim - timezone;
	ct = gmtime(copyt);
	dayno = ct->tm_yday;
	daylbegin = DAYLBEGIN;
	daylend = DAYLEND;
	daylbegin = sunday(ct, daylbegin);
	daylend = sunday(ct, daylend);
	if ( daylight &&
		(  (daylend > daylbegin &&	/* Northern Hemisphere */
			(dayno>daylbegin || (dayno==daylbegin && ct->tm_hour>=2))
			&&
			(dayno<daylend || (dayno==daylend && ct->tm_hour<1))
		   )
		 ||(daylbegin > daylend &&	/* Southern Hemisphere */
			(dayno>daylbegin || (dayno==daylbegin && ct->tm_hour>=2))
			||
			(dayno<daylend || (dayno==daylend && ct->tm_hour<1))
		   )
		)
	   )
	{
		copyt += (long)1*60*60;
		ct = gmtime(copyt);
		ct->tm_isdst++;
	}
	return(ct);
}

sunday(t, d)
	register struct tm *t;
	register int d;
{
	if (d >= 58)
		d += dysize(t->tm_year) - 365;
	return(d - (d - t->tm_yday + t->tm_wday + 700) % 7);
}

struct tm *
gmtime(tim)
	long tim;
{
	register int d0, d1;
	long hms, day;
	register int *tp;
	static struct tm xtime;

	/*
	** break initial number into days
	*/
	hms = tim % 86400L;
	day = tim / 86400L;
	if(hms < 0)
	{
		hms += 86400L;
		day -= 1;
	}
	tp = (int *) &xtime;

	/*
	** generate hours:minutes:seconds
	*/
	*tp++ = hms % 60;
	d1 = hms / 60;
	*tp++ = d1 % 60;
	d1 /= 60;
	*tp++ = d1;

	/*
	 * day is the day number.
	 * generate day of the week.
	 * The addend is 4 mod 7 (1/1/1970 was Thursday)
	 */

	xtime.tm_wday = (day + 7340036L) % 7;

	/*
	 * year number
	 */
	if(day >= 0) for(d1=70; day >= dysize(d1); d1++)
		day -= dysize(d1);
	else for(d1=70; day < 0; d1--)
		day += dysize(d1-1);
	xtime.tm_year = d1;
	xtime.tm_yday = d0 = day;

	/*
	 * generate month
	 */

	if(dysize(d1) == 366)
		dmsize[1] = 29;
	for(d1=0; d0 >= dmsize[d1]; d1++)
		d0 -= dmsize[d1];
	dmsize[1] = 28;
	*tp++ = d0+1;
	*tp++ = d1;
	xtime.tm_isdst = 0;
	return(&xtime);
}

char *
asctime(t)
struct tm *t;
{
	register char *cp, *ncp;
	register int *tp;

	cp = cbuf;
	for(ncp = "Day Mon 00 00:00:00 1900\n"; *cp++ = *ncp++;);
	ncp = &"SunMonTueWedThuFriSat"[3*t->tm_wday];
	cp = cbuf;
	*cp++ = *ncp++;
	*cp++ = *ncp++;
	*cp++ = *ncp++;
	cp++;
	tp = &t->tm_mon;
	ncp = &"JanFebMarAprMayJunJulAugSepOctNovDec"[(*tp)*3];
	*cp++ = *ncp++;
	*cp++ = *ncp++;
	*cp++ = *ncp++;
	cp = ct_numb(cp, *--tp);
	cp = ct_numb(cp, *--tp+100);
	cp = ct_numb(cp, *--tp+100);
	cp = ct_numb(cp, *--tp+100);
	if(t->tm_year >= 100)
	{
		cp[1] = '2';
		cp[2] = '0';
	}
	cp += 2;
	cp = ct_numb(cp, t->tm_year+100);
	return(cbuf);
}

dysize(y)
{
	if((y % 4) == 0)
		return(366);
	return(365);
}

char *
ct_numb(cp, n)
register char *cp;
{
	cp++;
	if(n >= 10)
		*cp++ = (n/10)%10 + '0';
	else
		*cp++ = ' ';
	*cp++ = n%10 + '0';
	return(cp);
}
