/*
** Regulate file transfer with a file protocol as follows:-
**
**  Blocks consist of a header followed by data followed by a trailer.
**  The header contains a sequence number (0/1) and the size
**   (transmitted twice, 2nd as complement of first).
**  The trailer contains a longitudinal parity check of the data,
**   followed by a sum check of the data.
**
**  Block format is
**	STX SEQ SIZ ~SIZ ...DATA... LPC SUM
**
**  Blocks are acknowledged by a 2 byte reply consisting of
**   ACK or NAK followed by the relevant sequence number.
**
**  The protocol is multi-buffered for speed, with at most NBUFS blocks
**   unacknowledged at any one time.
**
** Note: that the DATAZ is really dependant on the accuracy
**	 of the crc check.
*/

#define	MAXSEQ		127
#define	NBUFS		3

struct
{
	char	r_typ;
	char	r_seq;
}
		reply;

#define	HEADER		4
#define	BSEQ		1
#define	TRAILER		2
#define OVERHEAD	(HEADER+TRAILER)
#define	DATAZ		64
#define	DATAZL		64L
#define	BUFZ		(DATAZ+OVERHEAD)

char	buf[BUFZ];

#define	R_EOF		-1
#define	R_TIMEOUT	-2

short		terminate;
short		starting;

enum r_states
{
	r_ok, r_localerr, r_remoterr
};

extern enum r_states	xproto();
extern enum r_states	send();
