/
/	unix level 2 interface for macro spitbol v3.2
/	---- ----- - --------- --- ----- ------- ----
/
/	this module contains the unix operating system interface
/	for the macro spitbol compiler. spitbol's execution begins
/	at the start of this module and after some preliminary
/	set-up, control is passed to the compiler. during
/	compilation and execution the compiler calls subroutines
/	in this module to perform various functions that require
/	operating system calls. all subroutines directly called
/	by the compiler have names that start with "sys" and
/	appear in alphabetical order.
/
/	this level 2 interface includes many extensions to the
/	first interface, including faster initialization, unix
/	version 6/7 independence, and support of pipes.
/
/	the command line has the form:
/
/		spitbol [ options ] ifile ...
/
/	where all specifications are optional.
/
/	if ifiles are specified they are read in order before standard
/	input provided by shell.
/
/	options to the compiler are:
/
/		-e	don't send errors to terminal
/		-l	generate compiler listing
/		-c	generate compilation statistics
/		-x	generate execution statistics
/		-a	like -l -c -x
/		-p	long listing format; generates form feeds
/		-n	suppress execution (like -NOEXEC control card)
/		-mdddd	maximum size in bytes of created objects
/		-sdddd	size in words of stack space
/		-u string executing program may retrieve string by
/			HOST(0) function call
/		-o ofile spitbol will write listing, statistics and
/			dump to ofile and standard output generated
/			by executing program to >file
/
/	defaults:
/
/	standard output comes only from assignments to OUTPUT or
/	from compiler error messages.
/
/		-m8192	see "defmax"
/		-s1024	see "defstk"
/
/	also, the interface determines if the terminal is the standard
/	output file and sets a compiler flag that keeps listing output
/	short. see section: tsttty.
/
/	two files are accessed by the interface:
/
/		/usr/lib/spiterr contains fixed length error messages
/			of 53(10) bytes each, including new line.
/			this file is closed when spitbol terminates.
/
/		/usr/lib/spithost contains a one line description
/			of the host machine's environment, and is
/			open only during initialization. see syshs.
/
/	neither of these files is required for spitbol to execute.
/
/	input/output functions
/	------------ ---------
/
/	the interface handles two modes of input/output transfers:
/
/		line mode, where records are delimited by new line
/		characters. the interface strips them on input and
/		appends them on output.
/
/		raw mode, where a predetermined number of bytes
/		are transferred.
/
/	the particular mode to be used is specified by the programmer
/	in the INPUT/OUTPUT function call and is processed by the
/	interface. the maximum length input record is determined by the
/	-l or -r argument. the length of an output record is determined
/	by the length of the string assigned to the output associated
/	variable, plus one if in line mode.
/
/	the form of the INPUT/OUTPUT function call is
/
/		INPUT/OUTPUT(.name,channel_number,file_name args)
/
/	where	name is the variable name to be input/output associated
/
/		channel number is an integer between 0 and 14. inclusive
/		and is spitbol's identifier for the association.
/
/		file_name args specifies the source/destination of the
/		input/output and any processing arguments. the
/		file_name can specify either a path name to a file
/		or a command string. command strings are distinguished
/		from files by a leading "!". the character following
/		the "!" is the delimiter used to separate the command
/		string from any arguments to the interface. the ending
/		delimter may be omitted if there are no arguments to
/		the interface. there must always be at least one space
/		between the file_name and args, even if the file_name
/		is null.
/
/	file arguments:
/
/		-a	append output at end of existing file. if file
/			doesn't exist it is created. if -a is not specified
/			then the file is created.
/		-bdddd	set buffer size to dddd characters.
/		-c	like -r1.
/		-ldddd	line mode: maximum input record length is dddd
/			characters, length of output record is length
/			of string assigned to output associated variable,
/			plus one if line mode (for new line).
/		-rdddd	raw mode: maximum input record length is dddd
/			characters; length of output record is length
/			of string assigned to output associated variable.
/		-w	write records without buffering; this is
/			automatically set by the interface for terminals.
/
/		defaults:  -b512 -l512
/			   (size of disk block (blksiz) is 512)
/
/	more than one type of transfer may be associated with a file.
/	this is accomplished by calling INPUT/OUTPUT after the initial
/	call with the name, channel number, and file arguments. the
/	file name must not be specified on calls subsequent to the
/	first!
/
/	the unix seek/lseek system call is supported through
/	an external function that can be "loaded" by the executing
/	program. no "load" is done; see sysld, exseek, and osseek.
/
/
/	unix blocks and equates
/	---- ------ --- -------
/
/	list of system calls used by interface.
/
/		close
/		creat
/		dup
/		exec	(version 6)
/		exece	(version 7)
/		exit
/		fork
/		gtty
/		indir
/		kill
/		lseek	(version 7)
/		open
/		pipe
/		read
/		seek	(version 6)
/		signal
/		times
/		wait
/		write
/
/	process time block
/
putime	= 0			/ process user time
pstime	= 4			/ process system time
cutime	= 10			/ child user time
cstime	= 14			/ child system time
timsiz	= 20			/ size in bytes of time block
/
/	global filled in by ld.
/
	.globl	_end		/ address past end of program
/
/	the following equate is for version 6.
/
v6seek	= 19.			/ same as seek
/
/	the following equates are for version 7.
/
exece	= 59.			/ new exec system call
v7seek	= 19.			/ same as lseek
/
/
/	internal spitbol blocks used by interface
/	-------- ------- ------ ---- -- ---------
/
/
/	efblk - external function block
/
fcode	= 0			/ block type - bzefc
fargs	= 2			/ number of arguments
eflen	= 4			/ length in bytes of efblk
efuse	= 6			/ use count
efcod	= 10			/ pointer to code (from sysld)
efvar	= 12			/ pointer to associated variable block
efrsl	= 14			/ result type (see below)
eftar	= 16			/ argument types (see below)
/				/ efrsl and eftar are as follows.
/				/	0 unconverted
/				/	1 string
/				/	2 integer
/				/	3 real
/
/	icblk - integer block
/
icget	= 0			/ block type - bzicl
icval	= 2			/ integer value
/
/	scblk - string block
/
scget	= 0			/ block type - bzscl
sclen	= 2			/ length in bytes of string
schar	= 4			/ characters of string
/
/	xnblk - external non-relocatable block
/
xntyp	= 0			/ block type - bzxnt
xnlen	= 2			/ length in bytes of xnblk
xnval	= 4			/ external values
/
/	xrblk - external relocatble block
/
xrtyp	= 0			/ block type - bzxrt
xrlen	= 2			/ length in bytes of xrblk
xrval	= 4			/ external values
/
/
/	interface blocks
/	--------- ------
/
/	the interface allocates blocks within spitbol's dynamic area
/	for use by the input/output routines. these blocks conform to
/	spitbol's standards, a type flag appears in the first word of
/	the block and for these types of blocks, the length in bytes
/	of the block is stored in the second word of the block.
/
/	the ioblk is the control area for all input/output and is
/	pointed to by the compiler variable rzfil. within the ioblk
/	is an ioelt for each channel number that might be used in
/	an input/output association. there are five fields in each
/	ioelt: file descriptor, file name pointer, buffer block
/	pointer, a word of flags, and the child's process id if this
/	file descriptor is one end of a pipe. the file name and buffer
/	are blocks within spitbol's dynamic area.
/
/	for each call to INPUT/OUTPUT it is possible for a fcblk
/	to be created. within the fcblk is the channel number to be
/	used and the transfer mode. as previously mentioned, more than
/	one fcblk may be active per file. the fcblk is passed to the
/	interface on all input/output calls.
/
/	blocks allocated by the interface come in two flavors: external
/	relocatable (xrblk's) and external non-relocatable (xnblk's).
/
/	xrblk's contain words that are treated as addresses by spitbol.
/	thus, these addresses must conform to spitbol's standard that
/	if an address points within the dynamic area, it must point to
/	the start of a block. it is permissible for words to contain
/	addresses that do not lie in spitbol's dynamic area.
/
/	xnblk's are treated as raw data. no word within an xnblk should
/	point to another dynamic area block, since spitbol will not
/	relocate any fields in an xnblk during garbage collection.
/
/	ioblks are allocated as xrblks, while bfblks and fcblks
/	are xnblks.
/
/	bfblk - buffer block
/
/	the bfblk contains the buffer and related information for a file
/	descriptor. two fields of related information are kept: the
/	number of bytes left in the buffer and an offset to the next
/	byte to be accessed in the buffer.
/
bftyp	= 0			/ spitbol block type (external non-relocatable)
bflen	= 2			/ spitbol block length
bfbsz	= 4			/ buffer size in bytes
bfrem	= 6			/ number of bytes remaining in buffer
bfoff	= 10			/ offset in buffer to next byte
bfbuf	= 12			/ start of buffer
bfsiz	= 12			/ buffer header size (buffer size excluded)
/
/	fcblk - file control block
/
/	the fcblk contains information about an individual i/o association.
/	and is pointed to by a trap block hanging off a variable block. the
/	fcblk contains the file descriptor and the i/o mode. more than one
/	fcblk may be active per file descriptor.
/
fctyp	= 0			/ spitbol block type (external non-relocatable)
fclen	= 2			/ spitbol block length
fchan	= 4			/ channel number
fcrsz	= 6			/ record size (raw mode) or 0 (line mode)
fcsiz	= 10			/ size of fcblk
/
/	ioblk - interface master i/o block
/
/	ioblk holds information about active input/output assocaitions.
/	rzfil in the compiler's relocatable work area points to the
/	current ioblk or contains a zero if no ioblk is active.
/
iotyp	= 0			/ spitbol block type (external relocatable)
iolen	= 2			/ spitbol block length (iosize)
iofdn	= 4			/ file desciptor number
iofnm	= 6			/ pointer to file name for file descriptor
iobuf	= 10			/ pointer to buffer for file descriptor
iopid	= 12			/ process id of child if this is pipe
ioflg	= 14			/ flags for file descriptor
/
/	flags values must never get large enough to "look" like
/	an address within spitbol's dynamic area.
/
io.inp	= 1			/ input association flag
io.oup	= 2			/ output association flag
io.app	= 4			/ append output flag
io.opn	= 10			/ file open flag
io.eof	= 20			/ eof flag
io.err	= 40			/ i/o error flag
io.sys	= 100			/ system file flag
io.wrc	= 200			/ write each record (no buffering)
io.pip	= 400			/ this file descriptor is one end of a pipe
io.ded	= 1000			/ child at other end of pipe is dead
/
ioelt	= ioflg+2-iofdn		/ fields iofnm -> ioflg are ioelt
iosiz	= iofdn+[hichan+1*ioelt]	/ size of ioblk
/
/
/	globals and equates
/	------- --- -------
/
/	globals referenced in the compiler.
/
	.globl	bzicl,bzscl,bzxnt,bzxrt
	.globl	nulls,rzfil
	.globl	sec04,sec05,sec06
/
/	register equates (for compatibility with compiler)
/
cp	= r0
wa	= r1
wb	= r2
wc	= r3
xl	= r4
xr	= r5
ia	= wc
/
/	parameter offsets
/
p1	= 2
p2	= 4
p3	= 6
p4	= 10
regs	= 14
/
/	offsets to registers on stack
/
cp.off	= 0
wa.off	= 2
wb.off	= 4
wc.off	= 6
xl.off	= 10
xr.off	= 12
/
/
/	interface initialization
/	--------- --------------
/
/	process any options specified on command line. on entry
/	sp points to word containing number of options found
/	including the program name. following this word are pointers
/	to the ascii text for each option.
/
.text	/ ianh
unxint: mov	sp,r5		/ use r5 instead of sp
	mov	sp,origsp	/ save original sp
	mov	(r5)+,r4	/ r4 = number of options specified
	tst	(r5)+		/ program name not interesting
	br	4f		/ process others
0:	mov	(r5)+,r0	/ r0 -> option text
	movb	(r0)+,curopt	/ pick up both bytes of option
	movb	(r0)+,curopt+1	/  and store in curopt
	cmpb	$'-,curopt	/ if no leading '-'
	bne	2f		/  then treat as file name
	mov	$opttbl,r1	/ r1 -> option table
1:	cmp	curopt,(r1)	/ ?have we found right one?
	beq	3f
	add	$optsiz,r1	/ point to next entry
	br	1b		/  and try again (will always match)
2:	jsr	pc,optinp	/ process input file names
	br	4f		/ merge with loop control
3:	jsr	pc,*optrtn(r1)	/ call option processing routine
4:	sob	r4,0b		/ loop thru all options
/
/	determine whether this is unix version 6 or 7 through
/	inspection of word following the arguments. version 6
/	has a -1; version 7 a 0.
/
tstver: tst	(r5)+		/ if word is not zero
	bne	0f		/  then default to version 6
	mov	$7,vunix	/  else set version 7
	mov	r5,envptr	/	save environment pointer
	movb	$exece,shexec	/	and make exec an exece
0:
/
/	determine what happens to the pc when an odd address trap occurs.
/	this allows correct computation of error codes.
/	[odd pc incrementing is pdp-11 model dependent.]
/
tstmod: sys	signal ; 10. ; 1f
				/ issue signal to catch trap
	mov	$077777,pc	/ cause odd address trap (bus error)
1:	tst	(sp)		/ if (sp) > 0
	bmi	2f
	mov	$1,pmodel	/  then set pmodel to 1
2:				/ (else set pmodel to -1, default)
/
/	dup standard input to get lowest file descriptor number.
/
fndlow: clr	cp		/ file descriptor 0
	sys	dup		/ make a copy
	mov	cp,lodesc	/ save in lodesc
	sys	close		/ no longer need copy
/
/	open error text file and save file descriptor.
/
opnerf: sys	open ; errnam ; 0
				/ open error text file
	bcs	0f		/ skip next line if open error
	mov	r0,errfcb	/ save file descriptor
0:
/
/	open and read host string file. the string read is returned
/	on calls to syshs (HOST) with all null arguments.
/
opnhst: sys	open ; hstnam ; 0
				/ open host string file
	bcs	2f		/ skip if open error
	mov	cp,wa		/ save file descriptor for close
	sys	read ; hstblk+schar ; maxhst
				/ read up to maxhst characters
	bcs	1f		/ if read error then close file
	tst	cp		/ if null file
	beq	0f		/  then set null host string
	cmpb	hstblk+schar-1(cp),$lf
				/ if last character read was lf
	bne	0f
	dec	cp		/  then decrement host string length
0:	mov	cp,hstblk+sclen / set length of host string
1:	mov	wa,cp		/ reload file descriptor
	sys	close		/  and close
2:
/
/	if additional input files were specified on option then save
/	current input file descriptor and open the first of these
/	additional files.
/
inpopn: tst	inpptr		/ if inpptr = 0
	beq	0f		/  then no switch necessary
	clr	cp		/ get file descriptor zero
	sys	dup		/ duplicate
	mov	cp,orginp	/ and save it
	jsr	pc,swcinp	/ switch input files
0:
/
/	if output file was specified as option then save current output
/	file by dup'ing it, and open file specified. this allows option
/	to specify where listing and statistics go, while real output
/	of program goes to output file provided by