;;;	/ p o p / m a n d c 1 . p
;;;	Missionaries and Cannibals Function Package #1
;;;
;;;	Steven Hardy
;;;	24 June 1976
;;;
;;;	The following function takes a list and object.
;;;	It returns a copy of the list with the object deleted.
function delete object list;
	if	object == hd(list)
	then	tl(list)
	else	[%hd(list)%] <> delete(object,tl(list))
	close
end;
;;;
;;;	The following function takes two lists.
;;;	It returns a copy of the first with the elements of the second deleted.
operation without master unwanted;
	if	unwanted == []
	then	master
	else	delete(hd(unwanted),
			master without tl(unwanted))
	close
end;
;;;
;;;	The following function takes twolists and returns a list containing all
;;;	the elements of the first AND all the elements of the second;
operation with listone listtwo;
	listone <> listtwo
end;
;;;
;;;	Declare the two global variables used by this package.
vars leftbank rightbank;
;;;
;;;	The following function takes a listof things tobe moved from the
;;;	the left bank to the right. It alters the variables "leftbank"
;;;	and "rightbank" appropriately
function moveltor move;
	leftbank without move -> leftbank;
	rightbank with move -> rightbank;
end;
;;;
;;;	The following function moves a list of objects from the right
;;;	bank to the left.
function movertol move;
	rightbank without move -> rightbank;
	leftbank with move -> leftbank;
end;
;;;
;;;	The following function initialises the global variables
;;;	ready for a a trial solution.
function startmandc;
	[m m m c c c boat] -> leftbank;
	[] ->rightbank;
end;
;;;
;;;	The following function prints the left bank of the state.
function printleftbank;
	pr("leftbank");
	sp(1);
	pr("is");
	sp(1);
	pr(leftbank);
	nl(1);
end;
;;;
;;;	The following function prints the right bank of the current state.
function printrightbank;
	pr("rightbank");
	sp(1);
	pr("is");
	sp(1);
	pr(rightbank);
	nl(1);
end;
;;;
;;;	The following function prints the state of the game.
function printstate;
	printleftbank();
	printrightbank();
end;
;;;
;;;	The library index function for this package.
function mandc1;
	'Missionaries and Cannibals Package #1'=>
end;
;;;
;;;	We can simplify printstate thus:
;;;
;;;	function printbank name;
;;;		pr(name);
;;;		sp(1);
;;;		pr("is");
;;;		sp(1);
;;;		pr(valof(name));
;;;		nl(1);
;;;	end;
;;;
;;;	function printstate;
;;;		printbank("leftbank");
;;;		printbank("rightbank");
;;;	end;
;;;
;;;	The following functions simplify interaction with the above routines.
;;;
;;;	The following function returns TRUE iff the given OBJECT is in the given LIST.
function member object list;
	if	list == []
	then	false
	elseif	object == hd(list)
	then	true
	else	member(object,tl(list))
	close
end;
;;;
;;;	The following function deduces which of MOVELTOR and MOVERTOL
;;;	should be applied.
function domove move;
	if	member("boat",leftbank)
	then	moveltor(move)
	else	movertol(move)
	close
end;
;;;
;;;	The following function requests a move.
function requestamove;
	printstate();
	prstring('Type a move');
	readline();
end;
;;;
;;;	The following function counts the number of
;;;	times object occurs in list;
function count object list;
	if	list == []
	then	0
	elseif	object == hd(list)
	then	1 + count(object,tl(list))
	else	count(object,tl(list))
	close
end;
;;;
;;;	The following function returns the list describing
;;;	the side from which the boat is about to leave.
function fromside;
	if	member("boat",leftbank)
	then	leftbank
	else	rightbank
	close
end;
;;;
;;;	The following function returns the list describing
;;;	the side to which the boat is about to go.
function toside;
	if	member("boat",leftbank)
	then	rightbank
	else	leftbank
	close
end;
;;;
;;;	The following function checks that the boat will be okay in a move.
function boatokay move;
	count("boat",move) == 1
	and	count("c",move) + count("m",move) >= 1
	and	count("c",move) + count("m",move) <= 2
	and	count("c",move) <= count("c",fromside())
	and	count("m",move) <= count("m",fromside())
end;
;;;
;;;	The following function checks that the bank from which the
;;;	the boat leaves will be okay after a move.
function frombankokay move;
	count("m",move) == count("m",fromside())
	or	(count("m",fromside()) - count("m",move))
			>=	(count("c",fromside()) - count("c",move))
end;
;;;
;;;	The folllowing function checks that the bank at which the boat
;;;	is due to arrive will be okay after a move
function tobankokay move;
	count("m",move) + count("m",toside()) == 0
	or	(count("m",toside()) + count("m",move))
			>=	(count("c",toside()) + count("c",move))
end;
;;;
;;;	The following function determines the acceptability of
;;;	its argument as a move.
function allowablemove move;
	boatokay(move)
	and	frombankokay(move)
	and	tobankokay(move)
end;
;;;
;;;	The following function makes a whole sequence of moves.
function makemoves;
	vars move;
	requestamove() -> move;
	if	allowablemove(move)
	then	domove(move)
	else	prstring('Move not acceptable\n')
	close;
	makemoves()
end;
;;;
;;;	The following function plays a game of MANDC with the user.
function mandc;
	startmandc();
	makemoves();
end;
