#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 *
 * EM1 - UNIX as translator
 *
 * code generating routines
 *
 */

gen(mnem) {
	register char *ss;

	switch(mnem) {
	case op_nul:	break;
	case MOV:	ss = "mov "; break;
	case op_add:
	case op_pad:	ss = "add "; break;
	case BIS:
	case op_ior:	ss = "bis "; break;
	case op_sub:
	case op_psb:	ss = "sub "; break;
	case op_mul:	ss = "mul "; break;
	case op_div:	ss = "div "; break;
	case SXT:	ss = "sxt "; break;
	case BIC:	ss = "bic "; break;
	case ASHC:	ss = "ashc "; break;
	case ASH:	ss = "ash "; break;
	case ASR:
	case op_shr:	ss = "asr "; break;
	case ASL:
	case op_shl:	ss = "asl "; break;
	case TST:	ss = "tst "; break;
	case LDCIF:	ss = "movif "; break;
	case op_ldf:
	case op_stf:	ss = "movf "; break;
	case STCFI:	ss = "movfi "; break;
	case op_fad:	ss = "addf "; break;
	case op_fsb:	ss = "subf "; break;
	case op_fmu:	ss = "mulf "; break;
	case op_fdv:	ss = "divf "; break;
	case JSR:	ss = "jsr "; break;
	case JMP:	ss = "jmp "; break;
	case RTS:	ss = "rts "; break;
	case SOB:	ss = "sob "; break;
	case CLR:
	case op_zre:
	case op_zrl:	ss = "clr "; break;
	case MOVB:	ss = "movb "; break;
	case BISB:	ss = "bisb "; break;
	case COM:
	case op_com:	ss = "com "; break;
	case op_inc:
	case op_inl:
	case op_ine:	ss = "inc "; break;
	case op_dec:
	case op_del:
	case op_dee:	ss = "dec "; break;
	case op_neg:	ss = "neg "; break;
	case op_bgt:	ss = "jgt "; break;
	case op_blt:	ss = "jlt "; break;
	case op_bge:	ss = "jge "; break;
	case op_ble:	ss = "jle "; break;
	case op_bne:	ss = "jne "; break;
	case op_beq:	ss = "jeq "; break;
	case op_brf:	ss = "jbr "; break;
	case op_cmi:
	case op_cmu:	ss = "cmp "; break;
	case op_cmf:	ss = "cmpf "; break;
	case XOR:
	case op_xor:	ss = "xor "; break;
	case op_and:	ss = "bit "; break;
	case BHI:	ss = "jhi "; break;
	case BHIS:	ss = "jhis "; break;
	case BLO:	ss = "jlo "; break;
	case BLOS:	ss = "jlos "; break;
	case HALT:	ss = "4"; break;
	case SETI:	ss = "seti"; break;
	case SETL:	ss = "setl"; break;
	case CFCC:	ss = "cfcc"; break;
	default:	ss = error("unknown PDP mnemonic",0);
	}
	pputs(ss);
}

gen0(m) {
	gen(m);
	pline();
}

gen1(m,s) char *s; {
	gen(m);
	pputs(s);
	pline();
}

gen2(m,s1,s2) char *s1,*s2; {
	gen(m);
	pputs(s1);
	pputc(',');
	pputs(s2);
	pline();
}

genf(m,f1,f2) fake_t *f1,*f2; {
	gen(m);
	pputs(str(f1));
	pputc(',');
	pputs(str(f2));
	pline();
}

char *int8(an) int an; {
	static char sb[MAXSTRL];
	register char *s;
	register n;

	s = &sb[MAXSTRL];
	*--s = '\0';
	n = an;
	if (n > -8 && n < 8)
		return(int10(n));
	do
		*--s = (n & 07) + '0';
	while (n = (n>>3) & 017777);
	return(s);
}

char *int10(an) {
	static char sb[MAXSTRL];
	register char *s;
	register n;

	s = &sb[MAXSTRL];
	*--s = '\0';
	if ((n = an) < 0)
		n = -n;
	do
		*--s = (n % 10) + '0';
	while (n =/ 10);
	if (an < 0)
		*--s = '-';
	return(s);
}

char *strapp(to,from) char *to,*from; {
	register char *t,*f;

	t = to;
	f = from;
	while (*t = *f++)
		t++;
	return(t);
}

char *locname(n) {
	register char *s;

	s = int10(n);
	*--s = LOC_PREFIX;
	return(s);
}

char *imm(n) {
	register char *s;

	s = int8(n);
	*--s = '$';
	return(s);
}

char *str(ap) fake_t *ap; {
	register fake_t *p;
	register char *s;
	register i;
	static char sb[MAXSTRL];

	s = sb;
	p = ap;
	i = p->index;
	if (p->flags & IND)
		*s++ = '*';
	switch (p->type) {
	case REG:
		if (is_reg(p)==FREG)
			*s++ = 'f';
		if (p->offset) {
			s = strapp(s,int8(p->offset));
			*s++ = '(';
		}
		*s++ = 'r';
		*s++ = i + '0';
		if (p->offset)
			*s++ = ')';
		*s = '\0';
		break;
	case LOCL:
		if (p->offset || i)
			s = strapp(s,adrstr(p->offset,chp_cast i));
		strcpy(s,INDLB);
		break;
	case EXT:
		strcpy(s,adrstr(p->offset,i ? chp_cast i : EB));
		break;
	case ADDREXT:
		if (!i)
			i = int_cast EB;
	case CONS:
		*s++ = '$';
		strcpy(s,adrstr(p->offset,chp_cast i));
		break;
	case STK:
		return(POP);
	default:
		dump(p);
		fatal("bad fake-frame");
	}
	return(sb);
}

char *str1(ap) fake_t *ap; {
	static char sb[MAXSTRL];

	strcpy(sb,str(ap));
	return(sb);
}

char *adrstr(off,ind) char *ind; {
	register char *s;
	register no_name;
	static char sb[MAXSTRL];

	no_name=TRUE;
	s = sb;
	if(ind) {
		s = strapp(s,ind);
		if (off)
			*s++ = '+';
		no_name = FALSE;
	}
	if(off || no_name)
		strcpy(s,int8(off));
	return(sb);
}

char *autinc (n) int n; {
	register char *s;

	s = "(rx)+";
	s[2] = '0'+ n;
	return(s);
}

char *autdec (n) int n; {
	register char *s;

	s = "-(rx)";
	s[3] = '0' + n;
	return(s);
}

char *indstk (off) int off; {
	register char *s;
	static char sb[MAXSTRL];

	s = sb;
	if (off)
		s = strapp(s,int8(off));
	strcpy(s,INDSPX);
	return(sb);
}

char *adrext (n) int n; {
	register char *s;
	static char sb[MAXSTRL];

	s = sb;
	*s++ = '$';
	s = strapp(s,int8(n));
	*s++ = '+';
	strcpy(s,EB);
	return(sb);
}

char *indreg (off,ind) {
	register char *s;
	static char sb[MAXSTRL];

	s = sb;
	if (off)
		s = strapp(s,int8(off));
	strcpy(s,"(rx)");
	s[2] = '0' + ind;
	return(sb);
}

char *statreg (nr) {
	register char *s;

	s = "statd(rx)";
	s[7] = '0' + nr;
	return(s);
}

extsubr (s) char *s; {

	gen2(JSR,PC,s);
	if (prolookup(s,PRO_OCC) == NULL)
		;
}

extjump(s) char *s; {

	gen1(JMP,s);
	if (prolookup(s,PRO_OCC) == NULL)
		;
}

reg_frame (fp) fake_t *fp; {
	register fake_t *p;

	p=fp;
	p->type = REG;
	p->flags = INT;
	p->offset = 0;
	p->index = ANY;
}
