(*	SCANFILE - search through the whole of textfile printing
		all lines that match the pattern.
*)
procedure scanfile(pattern : patterntype; var textfile : text);
const
	maxline = 100;
type
	lineindextype = 0..maxline;
	(* line buffer *)
	linetype = record
			linechars : array[1..maxline] of char;
			linelen : lineindextype
		   end;
var
	textline : linetype;

	(* read line from textfile into line buffer *)
	procedure readline(var textfile : text; var line : linetype);
	begin
		with line do
		  begin
			linelen := 0;
			{ 0 <= linelen <= maxline }
			while not eoln(textfile) and (linelen <> maxline) do
			  begin
				linelen := linelen + 1;
				read(textfile,linechars[linelen])
			  end;
			{ eoln(textfile) or linelen = maxline }
			if not eoln(textfile) then
				message('line too long :', linechars)
		  end;
		readln(textfile)
	end (* readline *);

	(* WRITELINE - write line buffer to text file
	*)
	procedure writeline(var outfile : text; line : linetype);
	var
		i : 1 .. maxline;
	begin (* writeline *)
		with line do
			for i := 1 to linelen do
				write(outfile, linechars[i]);
		writeln(outfile)
	end (* writeline *);

#include "match.i"

begin (* scanfile *)
	while not eof(textfile) do
	  begin
		readline(textfile, textline);
		if match(pattern, textline) then
			writeline(output, textline)
	  end
end (* scanfile *);
