h26328
s 00002/00002/01231
d D 1.16 81/06/29 15:42:15 root 16 15
c minor local changes
e
s 00001/00001/01232
d D 1.15 80/05/22 14:18:28 bin 15 14
c Convert to using UNIX Edition 7 protection masks.
e
s 00001/00001/01232
d D 1.14 80/04/11 13:21:03 bin 14 13
c Change the name of the cross-reference program.
e
s 00028/00036/01205
d D 1.13 80/04/08 10:05:44 bin 13 12
c Convert to run under UNIX Edition 7.
e
s 00460/00008/00782
d D 1.12 79/07/20 15:59:41 sys 12 11
c Allow user programs to have overlay capability
e
s 00006/00000/00784
d D 1.11 79/07/20 15:50:34 sys 11 10
c Notice when the text,data or bss region overflows
e
s 00008/00000/00776
d D 1.10 79/07/20 15:45:35 sys 10 9
c Notify user when psects with the same name have different characteristics.
e
s 00002/00001/00774
d D 1.9 79/07/20 15:27:13 sys 9 8
c Fix a bug where the linker allocated more memory than necessary
c for a particular, much used, structure.
e
s 00001/00001/00774
d D 1.8 79/07/20 08:33:06 sys 8 7
c Change the permission to give a little more security
e
s 00004/00002/00771
d D 1.7 79/07/20 08:30:05 sys 7 6
c Change the declarations to something more natural or correct
e
s 00016/00001/00757
d D 1.6 79/07/20 08:27:04 sys 6 5
c Add '_' to the radix50 character set; allow entry of upper case
c alphabetics; do better checking for illegal characters.
e
s 00008/00003/00750
d D 1.5 79/07/20 08:23:31 sys 5 4
c Fix a bug in the handling of psects and the word boundary alignment problem.
e
s 00034/00001/00719
d D 1.4 79/07/20 08:19:30 sys 4 3
c Switches for debugger (odt & fdt) inclusion.
e
s 00023/00000/00697
d D 1.3 79/07/20 08:16:27 sys 3 2
c Allow non-zero start addresses
e
s 00018/00002/00679
d D 1.2 79/07/20 08:11:45 sys 2 1
c Addition of switch to allow library specification
c and change of suffix processing.
e
s 00681/00000/00000
d D 1.1 79/07/20 07:51:19 sys 1 0
e
u
U
t
T
I 1
#include	"link.h"
char	*fortlib	"/lib/f4";
I 4
char	odtfile[]	"/lib/odt.obj";
char	fdtfile[]	"/lib/fdt.obj";
E 4
I 2
char	lib[]		"/usr/lib/xxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
E 2
char	*digits		"0123456789";
I 12
char			*getcore();
E 12

main(argc,argv)
int	argc;
char	*argv[];
{
	register int i,j;
	register char *p;
	char *np,c;


	/* establish free core */

	memhigh = (memlow = sbrk(GOBBLE)) + GOBBLE;
	if(memlow == -1)
D 13
		ferror("Core exceeded.");
E 13
I 13
		lerror("Core exceeded.");
E 13


	/* treat initial switches */

	for(i=1;i<argc;i++) {
		p = argv[i];
		if(*p++ != '-')
			break;
		j = *p++;
		j =+ *p++<<8;

		switch(j) {
		
		case 'ls':	flags =| LS;
				break;
		case 'wr':	flags =| WR;
				break;
		case 'no':	flags =| NO;
				break;
		case 'p1':	flags =| P1;
				flags =& ~ID;
				break;
		case 'ns':	flags =| NS;
				break;
		case 'go':	flags =| GO;
				break;
		case 'o=':	objyes = p;
				break;
		case 'm=':	mapyes = p;
				flags =| LS;
				break;
		case 'cr':	flags =| CR | LS;
				crefstr = p;
				break;
		case 'id':	flags =| ID;
				flags =& ~P1;
				break;
		case 'nl':	flags =| NL;
				break;
I 4
		case 'od':	flags =| OD | P1;
				break;
I 12
		case 'ov':	flags =| OV | GO;
/*-------------------------------------------------??-----------*/
				break;
E 12
E 4
		default:	goto out;

		}
	}


	/* stash rest of args */

out:
I 12
	if ((flags & (OV|ID)) == (OV|ID))
D 13
		ferror("Illegal combination of switches");
E 13
I 13
		lerror("Illegal combination of switches");
E 13
E 12
	filec = argc - i;
	filev = &argv[i];
	for(i = 0; i < filec; i++) 
		if(*filev[i] != '-') {
			firstfile = filev[i];
I 12
			if (flags & OV)
				/*
				 * increment to enable comparison with wfile
				 * in opn_next()
				 *
				 * also, if not overlay, 0 can't match
				 */
				odfno = i+1;
E 12
			break;
		}
	if(firstfile == NIL)
		exit(0);

I 12
	nreg = 1;
	nseg = 1;
	if (flags & OV) {
		if ((odf = open(ext(firstfile, ".odf"), 0)) < 0)
			if ((odf = open(firstfile, 0)) < 0)
D 13
				ferror("Can't open odf");
E 13
I 13
				lerror("Can't open odf");
E 13
		/*
		 * check syntax of odf;
		 * find number of segments and regions
		 */
		checkodf();
E 12

I 12
		/* allocate tables etc. */

		if (nreg > 1) {
D 13
			(*psrtable) = getcore((nreg-1) * SREG);
			(*psstable) = getcore((nseg-1) * SSEG);
			(*segtadr) = ovslcode;
			(*auttadr) = ovslcode + (nseg-1)*SSEG;
E 13
I 13
			psrtable = getcore((nreg-1) * SREG);
			psstable = getcore((nseg-1) * SSEG);
			segtadr = ovslcode;
			auttadr = ovslcode + (nseg-1)*SSEG;
E 13
		}
	}
D 13
	(*segwk) = getcore(nseg * (sizeof (*segwk)[0]));
E 13
I 13
	segwk = getcore(nseg * (sizeof (*segwk)[0]));
E 13

E 12
	list_init();
	/* linker proper */

	pass1();
I 12
	pass++;
E 12
	pass2();
	load_map();
D 13
	flush();
E 13
I 13
	fflush(stdout);
E 13

	/*
	 *	if cross reference, close pipe to cref-er,
	 * then wait for it to complete
	 */

	if(flags&CR) {
		close(crfile);
		wait(&crfile);
	}

	if(errcnt) {
		if(flags & LS) {
			printf("Errors detected: %d\n",errcnt);
D 13
			flush();
			close(fout);
E 13
		}
D 13
		fout = 2;
		printf("Errors detected: %d\n",errcnt);
E 13
I 13
		fprintf(stderr,"Errors detected: %d\n",errcnt);
E 13
	}
D 13
	flush();
E 13
	exit(errcnt != 0);
}


list_init()
{
	register int outchan;
	register int i;
	int pargs[2];
	char *ss1,*ss2;

	ss1 = "x";
	ss2 = "x";

D 13
	fout = 1;
E 13
	if(flags&LS) {
D 8
		outchan = mapyes ? (*mapyes ? creat(mapyes,0644) : dup(1) ) : creat(ext(firstfile,".map"),0644);
E 8
I 8
D 15
		outchan = mapyes ? (*mapyes ? creat(mapyes,0600) : dup(1) ) : creat(ext(firstfile,".map"),0600);
E 15
I 15
D 16
		outchan = mapyes ? (*mapyes ? creat(mapyes,0666) : dup(1) ) : creat(ext(firstfile,".map"),0666);
E 16
I 16
		outchan = mapyes ? (*mapyes ? creat(mapyes,0660) : dup(1) ) : creat(ext(firstfile,".map"),0666);
E 16
E 15
E 8
		if(outchan == -1)
D 13
			ferror("Cannot create map file.");
		fout = outchan;
E 13
I 13
			lerror("Cannot create map file.");
		fclose(stdout);
		fdopen(outchan,"w");
E 13
	}

	if(flags&CR) {
		if((i = pipe(pargs)) == -1) {
			printf("Unable to cref?\n");
			flags =& ~CR;
			return;
		}
		switch(fork()) {

		case 0:	crfile = pargs[1];
			close(pargs[0]);
			break;
		
		case -1:	
			printf("Unable to fork?\n");
			flags =& ~CR;
			return;
	
		default:
			close(pargs[1]);
			*ss1 = digits[pargs[0]];
			*ss2 = digits[outchan];
D 14
			execl("/usr/bin/crefer","-",crefstr,ss1,ss2,0);
E 14
I 14
			execl("/usr/lib/linkcref","-",crefstr,ss1,ss2,0);
E 14
			exit(2);
		}
	}
}

char *ext(s1,s2)
char *s1,*s2;
{
	register char *r1,*r2,*r3;
	static char ss[60];
	char *w;

	w = NIL; r1 = s1; r2 = s2; r3 = ss;
	while(*r3 = *r1++) {
		if(*r3 == '/') w = NIL;
		if(*r3++ == '.') w = r3;
	}
	if(w) {r3 = w; --r3;}
	while(*r3++ = *r2++);
	return(ss);
}
D 13
ferror(s)
E 13
I 13
lerror(s)
E 13
char *s;
{
D 13
	flush();
	close(fout);
	fout = 2;
	printf("%s\n",s);
	flush();
E 13
I 13
	fprintf(stderr,"%s\n",s);
E 13
	exit(1);
}

/* pass 1 -
 *	read in all files, analyzing only the GSD sections
 *	set up library searches
 *	At the end of the pass, address are assigned.
I 12
 *************************????????????????????
E 12
 *	Also, since overlays are not implemented, the
 *	gbl/lcl distinction is ignored
 */

pass1()
{
	register int t;
	register *rr1,*rr2;
	int	libflag;
	int	radbuf[2];
	int	islib;
I 12
	unsigned int	j;
E 12


	libpnt = libuse;
	libflag = 0;
	islib = 0;

	init_in();

I 12
	(*segwk)[0].segreg = 0;		/* initialised to this anyway! */

E 12
	while(t=getrec())
	switch(t) {

	/* end of gsd.  skip file to EMOD,  and reset library flag */
	case ESD:
		slewto(EMOD);
		libflag = 0;
		break;

	/* library indicator. the remainder of the record is a list of
 	 * radix 50 names which this module claims to declare. If any of
	 * them are undefined,  the module is read in. Otherwise, it is
	 * skipped. 
	 */

	case LMOD:
		libflag++;
		islib++;
		while(t=movbyte(radbuf,4)) {
			rr2 = gsearch(radbuf);
			if(rr2 != NIL && (rr2->gflags&(DEF|EXC)) == 0)
				break;
		}
		if(t==0)
			break;
		libflag = 0;
		*libpnt++ = 1;
		slewto(GSD);

	/* fall through to GSD processor.  This is the main job during
	 * this pass. Each module has a string of psects which it
	 * declares. Each of these has a low limit and high limit for
	 * relocation purposes during pass ; right now the low-limit 
	 * is set to the offset from the start of the base psect,
	 * and the high limit to the size of the psect (in bytes).
	 * Each psect also has an associated string of global symbols
	 * which it declares. A list of undefined globals is also
	 * set up for library search.  Perhaps this list will eventually
	 * be optimized for a better search.
	 */

	case GSD:
		if(libflag) {
			libflag = 0;
			slewto(EMOD);
			*libpnt++ = 0;
			break;
		}

		while((t=getgsd())>=0)
		switch(t) {

		case MDN:
			rr1 = getcore(SMOD);
			if(curmod == NIL)
D 12
				curmod = modhead = rr1;
E 12
I 12
				(*segwk)[segment].segmod = rr1;
E 12
			else
				curmod->mpnt = rr1;
			curmod = rr1;

			rr1->mname[0] = gsdent.nm[0]; rr1->mname[1] = gsdent.nm[1];
			rr1->mversion[0] = 0; rr1->mversion[1] = 0;
			rr1->mislib = islib;
			islib = 0;
			break;

		case PVI:
			curmod->mversion[0] = gsdent.nm[0];
			curmod->mversion[1] = gsdent.nm[1];
			break;

		case CSN:
			if(gsdent.fbyte & REL) {
				if(gsdent.nm[0] == 0)
					gsdent.fbyte = DEF | REL;
				else
					gsdent.fbyte = DEF | REL | OVR | GBL;
			} else
				gsdent.fbyte = DEF | OVR | GBL;

			/* the default attributes have been set up.
			 * Now fall through & treat it as a psect
			 */

		case PSN:
I 5
			gsdent.val = (gsdent.val + 1) & ~1;
I 12
			if (segment>0 && !(gsdent.fbyte & (OVR|COM))) {
				gsdent.fbyte =& ~(SHR|INS|BSS);
				psectq = &(*segwk)[segment].segpsect;
			} else
				psectq = &psecthead;
E 12
E 5
			rr1 = psearch(gsdent.nm);
			if(rr1 == NIL) {
				rr1 = getcore(SPSECT);
				rr1->pname[0] = gsdent.nm[0];
				rr1->pname[1] = gsdent.nm[1];
				rr1->pflags = gsdent.fbyte & 0377;
I 12
/* rr1	psect	*/
/* rr2	psectl	*/
				if (psectq != &psecthead) {
					rr1->pflags =| OVLY;
					if (psecte == NIL)
						*psectq = rr1;
					else
						psecte->ppnt = rr1;
					psecte = rr1;
				} else {
E 12
				if(psecttail == NIL)
					psecthead = rr1;
				else
					psecttail->ppnt = rr1;
				psecttail = rr1;
I 12
				}
E 12
			}
I 10
			else if (t = (gsdent.fbyte ^ rr1->pflags) & (BSS|REL|OVR)) {
				printf("Warning: psect attributes vary in module <");
				radout(curmod->mname);
				printf(">, psect <");
				radout(rr1->pname);
				printf(">\n");
			}
E 10
			
			/* check for name already existing. If it is
			 * found, just fix length 
			 */
	
			for(rr2 = curmod->mpsl;rr2 != NIL;rr2 = rr2->pll)
				if(rr2->plp == rr1 ) 
					goto psn1;
	
			rr2 = curmod->mpsl;

			if(rr2 == NIL)
				rr2 = curmod->mpsl = getcore(SPSL);
			else {
				while(rr2->pll != NIL )
					rr2 = rr2->pll;
				rr2 = rr2->pll = getcore(SPSL);
			}
			rr2->plp = rr1;
		psn1:	if(rr1->pflags & OVR) {
				rr2->llimlow = 0;
				rr1->plimlow = max(rr1->plimlow,gsdent.val);
			} else {
				rr2->llimlow = rr1->plimlow;
				rr1->plimlow =+ gsdent.val;
			}
			if((rr1->pflags & BSS) && !(gsdent.fbyte & BSS))
				rr1->pflags =& ~BSS;
			rr1->pflags =| (gsdent.fbyte & COM);
			rr2->llimhigh = gsdent.val;
			cursec = rr2;
			break;

I 3
		case TRA:
			if (!(gsdent.val & 1)) {
				psectq = &psecthead;
				if (trmod != NIL) {
I 4
					if (odtyes) {
						odpsect = psearch(gsdent.nm);
						odadrs = gsdent.val;
						odmod = curmod;
						break;
					}
E 4
					printf("Mult. start address in <");
					radout(trmod->mname);
					printf("> & <");
					radout(curmod->mname);
					printf(">\n");
					errcnt++;
					break;		/* ignore it */
				}
				trpsect = psearch(gsdent.nm);
				tradrs = gsdent.val;
				trmod = curmod;
			}
			break;
E 3

		case GSN:
			rr2 = getglo(gsdent.nm);
			if( !(gsdent.fbyte & DEF)) {
				crefout(gsdent.nm,0);
I 12
				if (nseg > 1) {
					if (rr2->gflags & DEF) {
						if (rr2->gsegment!=0 && rr2->gsegment!=segment)
							autovec(rr2);
					} else if (rr2->gsegment == 0)
						rr2->gsegment = segment==0 ? -1 : segment;
					else if (rr2->gsegment != segment)
						rr2->gsegment = -1;
				}
E 12
				break;
			}
			if(rr2->gflags & DEF)
				if(!(gsdent.fbyte & COM)) if(
				(rr2->gpsectl->plp != cursec->plp ||
				 (rr2->gflags & REL) != (gsdent.fbyte & REL) ||
				 (rr2->gflags & REL) ?
					rr2->gvalue + rr2->gpsectl->llimlow != gsdent.val + cursec->llimlow :
					rr2->gvalue != gsdent.val)) {
				printf("Mult. def : <");
				radout(gsdent.nm);
				printf("> in <");
				radout(cursec->plp->pname);
				printf("> in <");
				radout(curmod->mname);
				printf(">\n");
				errcnt++;
				break;		/* ignore it */
			}
			if((rr2->gflags & DEF) && (gsdent.fbyte & COM))
				break;
			crefout(gsdent.nm,1);
			rr2->gflags = gsdent.fbyte & 0377;
			rr2->gvalue = gsdent.val;
			rr2->gpsectl = cursec;
I 12
			if (nseg > 1) {
				if (rr2->gflags & REL) {
					if (segment>0 && rr2->gsegment!=0 && rr2->gsegment!=segment)
						autovec(rr2);
					rr2->gsegment = segment;
				} else
					rr2->gsegment = 0;
			}
E 12
D 9
			(rr1 = getcore(SPSL))->gglp = cursec->plg;
E 9
I 9
			rr1 = getcore(SGLOBL);
			rr1->gglp = cursec->plg;
E 9
			cursec->plg = rr1;
			rr1->glp = rr2;
		
		}	/* end of GSD type switch */
	}		/* end of RECORD type switch */

I 12
	if (!(flags & NS))
		msym = nsym;		/* get it before "end" etc. get added */

	/*
	 * The root segment is actually segment 0, so
	 * make the listhead show it.
	 */
	(*segwk)[0].segpsect = psecthead;

	if (nseg > 1) {
		/*
		 * Allocate the auto-load vector
		 */
D 13
		(*autotab) = getcore(nauto * SLINK);
E 13
I 13
		autotab = (struct link *)getcore(nauto * SLINK);
E 13

		/*
		 * Position overlay startup and $load code
		 * at bottom of text region; also place the
		 * runtime segment table there.
		 */
		txtsize = ovslcode + ((nseg-1)*SSEG) + (nauto*SLINK);
	}

E 12
	/* a pass is now made through core resident
	 * data to define all addresses
	 */

	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt) {
		if((rr1->pflags & COM) && getglo(rr1->pname)->gpsectl->plp != rr1) {
			rr1->pflags =| CMX;
			rr1->plimlow = 0;
		}
		if(rr1->pflags&SHR) {
			t = rr1->plimlow;
			rr1->plimlow = txtsize;
D 5
			txtsize = (txtsize + t +1) &~1;
E 5
I 5
			txtsize =+ t;
E 5
			rr1->plimhigh = txtsize;
I 11
			if (rr1->plimhigh < rr1->plimlow)
D 13
				ferror("Text area overflow");
E 13
I 13
				lerror("Text area overflow");
E 13
E 11
		}
	}

	/* if there is no shareable segment,  the
	 * data segment begins at zero.  If the P1
	 * option is in effect,  the shr segment is
	 * really private,  and is immediately followed
	 * by data. Otherwise, the data segment is rounded
	 * up to the next 8K byte boundary
	 */

	if((flags&P1) || txtsize == 0)
		datstart = txtsize;
	else
		datstart = (txtsize + 017777) & ~017777;
	if(flags & ID)
		datstart = 0;

I 12
	if (nseg > 1)
		/*
		 * Position the r/w part of the overlay startup
		 * and $load code at bottom of data region.
		 */
		datsize = ovplcode;
E 12
	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt)
		if((rr1->pflags&(BSS|SHR|REL))==REL) {
			t = rr1->plimlow;
			rr1->plimlow = datstart + datsize;
D 5
			datsize = (datsize + t + 1)&~1;
E 5
I 5
			datsize =+ t;
E 5
			rr1->plimhigh = datstart + datsize;
I 11
			if (rr1->plimhigh < rr1->plimlow)
D 13
				ferror("Data area overflow");
E 13
I 13
				lerror("Data area overflow");
E 13
E 11
		}

D 12
	bssstart = datstart + datsize;
E 12
I 12
	ovrstart = datstart + datsize;
E 12

I 12
	if (nseg > 1)
		/*
		 * Relocate the overlay region part of the overlay
		 * segments.
		 */
		calcov1();

	bssstart = ovrstart + ovrsize;

E 12
	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt)
		if((rr1->pflags)&BSS) {
			t = rr1->plimlow;
			rr1->plimlow = bssstart + bsssize;
D 5
			bsssize = (bsssize + t + 1)&~1;
E 5
I 5
			bsssize =+ t;
E 5
			rr1->plimhigh = bssstart + bsssize;
I 11
			if (rr1->plimhigh < rr1->plimlow)
D 13
				ferror("BSS area overflow");
E 13
I 13
				lerror("BSS area overflow");
E 13
E 11
		}

	/* Now the psectl list is searched,  and the sub-psects
	 * are relocated.  Also,  absolute values are given
	 * to all relocatable global symbols
	 */

	for(rr1 = psecthead; rr1 != NIL; rr1 = rr1->ppnt)
		if(rr1->pflags & CMX) {
			rr2 = getglo(rr1->pname);
			rr1->pflags = (rr2->gpsectl->plp->pflags & (SHR|INS|BSS|DEF|REL)) | OVR | COM;
			rr1->plimhigh = rr1->plimlow = rr1->gflags & REL ?
				rr1->gvalue + rr1->gpsectl->llimlow :
				rr1->gvalue;
		}
D 12
	for(t = modhead; t != NIL; t = t->mpnt)
E 12
I 12
	for (j = 0; j < nseg; j++)
	for (t = (*segwk)[j].segmod; t != NIL; t = t->mpnt)
E 12
		for(rr2 = t->mpsl; rr2 != NIL; rr2 = rr2->pll) {
			rr2->llimlow =+ rr2->plp->plimlow;
			rr2->llimhigh =+ rr2->llimlow;
			for(rr1 = rr2->plg; rr1 != NIL; rr1 = rr1->gglp)
				if(rr1->glp->gflags&REL)
					rr1->glp->gvalue =+ rr2->llimlow;
		}
I 3
	if (trmod != NIL)
		for (rr1 = trmod->mpsl; rr1 != NIL; rr1 = rr1->pll)
			if (rr1->plp == trpsect) {
				tradrs =+ rr1->llimlow;
				break;
			}
I 4
	if (odtyes) {
		for (rr1 = odmod->mpsl; rr1 != NIL; rr1 = rr1->pll)
			if (rr1->plp == odpsect) {
				odadrs =+ rr1->llimlow;
				break;
			}
		radixin("o.link", radbuf);
		rr1 = getglo(radbuf);
		rr1->gflags = GBL|DEF;
		rr1->gvalue = tradrs;
		tradrs = odadrs;
	}
E 4
E 3

	radixin("end", radbuf);
	if( !((rr1 = getglo(radbuf))->gflags & DEF)) {
		rr1->gvalue = bssstart + bsssize;
		rr1->gflags =| DEF;
	}
	radixin("etext", radbuf);
	if( !((rr1 = getglo(radbuf))->gflags & DEF)) {
		rr1->gvalue = txtsize;
		rr1->gflags =| DEF;
	}
	radixin("edata", radbuf);
	if( !((rr1 = getglo(radbuf))->gflags & DEF)) {
		rr1->gvalue = datstart + datsize;
		rr1->gflags =| DEF;
	}
I 12

	if (nseg > 1) {
		/*
		 * Relocate the overlay routines and calculate
		 * the entry point address
		 */
		if (tradrs == 0)
			tradrs = ovslcode + ((nseg-1)*SSEG) + (nauto*SLINK);
		setovcode(0, datstart, tradrs);
		tradrs = 0;

		/*
		 * Fix up the auto-load table
		 */
		calcov2();
	}
E 12
}			/* end of pass1 */

I 12
/*
 * Enter another entry-point into the auto-load
 * list.
 */
autovec(gp)
register struct global	*gp;
{
	struct globall		*autn;

	if (!(gp->gflags & AUTO)) {
		gp->gflags =| AUTO;
		autn = getcore(SGLOBL);
		autn->glp = gp;
		autn->gglp = autolist;
		autolist = autn;
		nauto++;
	}
}

/*
 * Performs all calculations for addressing the overlay
 * regions: link time relocation; link time file addressing;
 * and runtime addressing.
 */
calcov1()
{
	register unsigned int		i;
	register struct psect		*pp;
	char				*base;
	unsigned int			bigseg;
	unsigned int			len;
	unsigned int			mlen;
	unsigned int			mmlen;
	unsigned int			l;
	unsigned int			regn;
	unsigned int			fofset;
	long				lfofset;
	extern long			itol();

	/*
	 * Find length of all overlay segments
	 * and maximum length of regions.
	 * Find size of overlay area of memory.
	 * Relocate all overlaid psects.
	 * Also, the number of the largest region.
	 */
	regn = 0;
	bigseg = 0;
	base = ovrstart;
	mlen = 0;
	mmlen = 0;
	for (i = 1; i < nseg; i++) {
		if ((*segwk)[i].segreg != regn) {
			base =+ mlen;
			ovrsize =+ mlen;
			mlen = 0;
			regn = (*segwk)[i].segreg;
			(*psrtable)[regn-1] = base;
		}
		len = 2;	/* leave room for segment table pointer */
		for (pp = (*segwk)[i].segpsect; pp != NIL; pp = pp->ppnt) {
			l = pp->plimlow;
			pp->plimlow = base + len;
			len =+ l;
			pp->plimhigh = base + len;
			if (pp->plimhigh < pp->plimlow)
D 13
				ferror("Overlay area overflow");
E 13
I 13
				lerror("Overlay area overflow");
E 13
		}
		(*psstable)[i-1].segsiz = len;
		if (len > mlen) {
			mlen = len;
			if (len > mmlen) {
				mmlen = len;
				bigseg = i;
			}
		}
	}
	ovrsize =+ mlen;

	/*
	 * Calculate the file addresses of the overlay
	 * segments; all offsets are rounded up to the
	 * next (2**ROUND) byte boundary and then divided
	 * by (2**ROUND).
	 */
	lfofset = 16;	/* size of header */
	lfofset =+ txtsize;
	lfofset =+ datsize;
	if (!(flags & NS))
		lfofset =+ msym*12;
	lfofset =+ ROUNDX;
	fofset = lfofset>>ROUND;
	for (i = 1; i < nseg; i++)
		if (i != bigseg) {
			(*psstable)[i-1].segfadr = fofset;
			fofset =+ ((*psstable)[i-1].segsiz + ROUNDX)>>ROUND;
		}
	/*
	 * Place largest segment last in file so as to
	 * reduce likelyhood of not being able to seek
	 * the beginning of any segment.
	 */
	(*psstable)[bigseg-1].segfadr = fofset;
	flast = fofset + (((*psstable)[bigseg-1].segsiz - 1) >> ROUND);
}

/*
 * Fix the auto-load vector table.
 */
calcov2()
{
	unsigned int		i;
	struct globall		*glp;
	struct global		*gp;
	struct link		*lnkp;

	for (i = 0, lnkp = (*autotab), glp = autolist; i < nauto; i++, lnkp++, glp = glp->gglp) {
		gp = glp->glp;
		lnkp->kjsr[0] = 04537;	/* jsr r5,*$x */
		lnkp->kjsr[1] = ovlink;	/* $load entry point */
		/* region */
		lnkp->kregadr = (*psrtable)[(*segwk)[gp->gsegment].segreg - 1];
		/* segment table entry */
		lnkp->ksegptr = &(*segtadr)[gp->gsegment-1];
		lnkp->kentry = gp->gvalue;	/* get value */
		gp->gvalue = i;
	}
}

E 12
radout(p)
int *p;
{
	char rasc[6];
	radcon(p,rasc);
	printf("%.6s",rasc);
}

max(a1,a2)
char *a1,*a2;
{
	return(a1 > a2 ? a1 : a2);
}
radixin(s,p)
char *s;
int *p;
{
	register int r50,cc;
	register char c;
	int w;
	w = 2;
	do {
		r50 = 0;
		cc = 3;
		do {
			if(c = *s)
				s++;
			r50 =* 050;
			if(c == ' ' || c == 0)
				continue;
			if(c >= 'a' && c <= 'z') {
				r50 =+ c - 'a' + 1;
				continue;
			}
			if(c == '$') {
				r50 =+ 27;
				continue;
			}
			if(c == '.') {
				r50 =+ 28;
				continue;
			}
D 6
			r50 =+ c - '0' + 30;
E 6
I 6
			if (c>='A' && c<='Z') {
				r50 =+ c - 'A' + 1;
				continue;
			}
			if (c == '_') {
				r50 =+ 29;
				continue;
			}
			if (c>='0' && c<='9') {
				r50 =+ c - '0' + 30;
				continue;
			}
			printf("illegal radix50 character : %c\n", c);
E 6
		} while(--cc);
		*p++ = r50;
	} while(--w);
I 6
	if (*s != '\0')
		printf("Warning: radix50 string too long\n");
/*	s is a load of rubbish at this point!! */
E 6
}


char *getcore(n)
int n;
{
	register char *w;
	while(memhigh - memlow <= n) {
		if(sbrk(GOBBLE) == -1)
D 13
			ferror("Core exceeded.");
E 13
I 13
			lerror("Core exceeded.");
E 13
		memhigh =+ GOBBLE;
	}
	w = memlow;
	memlow =+ n;
	return(w);
}



/* initialize input; called from both passes */

init_in()
{
I 12
	if (flags & OV) {
D 13
		seek(odf, 0, 0);
E 13
I 13
		lseek(odf, 0L, 0);
E 13
		peekc = 0;
	}
	region = 0;
	segment = 0;
E 12
	wfile = 0;
	opn_next();
}


getgsd()
{
	if(movbyte(&gsdent,sizeof gsdent))
		return(gsdent.gtype);
	return(-1);
}



struct psect *psearch(s)
int *s;
{
	register struct psect *rp;
D 12
	for(rp = psecthead; rp != NIL; rp = rp->ppnt)
E 12
I 12

	for (rp = *psectq; rp != NIL; rp = rp->ppnt)
E 12
		if(rp->pname[0] == s[0] && rp->pname[1] == s[1])
			return(rp);
	return(NIL);
}

load_map()
{
	register char *rr1,*rr2,*rr3;
D 7
	int ff, fg, tvec[2];
E 7
I 7
	int ff, fg;
	long tvec;
I 12
	unsigned int	j;
	long	lwork;
E 12
E 7

	if((flags&LS) == 0)
		return;

D 7
	time(tvec);
	printf("\n\nLoad map UNIX linker	%s\n",ctime(tvec));
E 7
I 7
	time(&tvec);
D 16
	printf("\n\nLoad map UNIX linker	%s\n",ctime(&tvec));
E 16
I 16
	printf("\n\nLoad map UNIX linker	%s\n",ctime(tvec));
E 16
E 7
	if(flags & ID)
		printf("I/D space separated\n");
	else if((flags&P1)|| (txtsize==0))
		printf("No shareable segment\n");

	printf("text limit: %6o",txtsize);
	if((flags & ID) == 0)
		printf(" (%6o)",datstart);
	printf("\n");
D 12
	printf("%s%6o\n%s%6o\n\n",
		"data limit: ",bssstart,
		"bss  limit: ",bssstart+bsssize);
E 12
I 12
	printf("data limit: %6o\n", ovrstart);
	if (nseg > 1)
		printf("ovly limit: %6o\n", bssstart);
	printf("bss  limit: %6o\n", bssstart+bsssize);
	if (nseg > 1) {
		printf("Overlay information:\tAddress\tSize\n");
		printf("  r/o handler\t\t%6o\t%6o\n", 0, ovslcode);
		printf("  r/w handler\t\t%6o\t%6o\n", datstart, ovplcode);
		printf("  Segment table\t\t%6o\t%6o\n", (*segtadr), (nseg-1)*SSEG);
		printf("  autoload vectors\t%6o\t%6o\n\n", (*auttadr), nauto*SLINK);
	}
E 12


D 12
	for(rr1 = modhead; rr1 != NIL; rr1 = rr1->mpnt) 
E 12
I 12
	for (j = 0; j < nseg; j++) {
		if (j > 0) {
			printf("<<<<<<<<<<<<<<<<<<<< Region %u., Segment %u. >>>>>>>>>>>>>>>>>>>>\n", (*segwk)[j].segreg, j);
			lwork = (*psstable)[j-1].segfadr;
			lwork =<< ROUND;
			printf("  [ File offset %D.; Size %u. ]\n", lwork, (*psstable)[j-1].segsiz);
		}
	for (rr1 = (*segwk)[j].segmod; rr1 != NIL; rr1 = rr1->mpnt)
E 12
	if(((flags&NL)==0) || (rr1->mislib == 0)) {
		printf("**********\nModule\t");
		radout(rr1->mname);
		putchar('\t');
		radout(rr1->mversion);
		putchar('\n');
		printf("Section\t\tAddress\tSize\n");
		for(rr2 = rr1->mpsl; rr2 != NIL; rr2 = rr2->pll) {
			rr3 = rr2->plp;
			putchar('<');
			radout(rr3->pname);
			printf(">\t%6o\t%6o\t",rr2->llimlow,rr2->llimhigh - rr2->llimlow);
			rr3 = rr3->pflags;
I 12
			if (rr3 & OVLY)
				printf("[overlay] ");
E 12
			printf("%s,%s,%s,%s\n",
				(rr3&SHR) ? "shr" : (rr3&BSS) ? "bss" : "prv" ,
				(rr3&REL) ? "rel" : "abs",
				(rr3&OVR) ? "ovr" : "con",
				(rr3&GBL) ? "gbl" : "lcl");
			ff = 3;
			for(rr3 = rr2->plg; rr3 != NIL; rr3 = rr3->gglp) {
				putchar('\t');
				radout(rr3->glp->gname);
I 12
				if (rr3->glp->gflags & AUTO) {
					fg = rr3->glp->gvalue;
					printf("\t%6.1o(%.1o)", &(*auttadr)[fg], (*autotab)[fg].kentry);
				} else
E 12
				printf("\t%6o\t",rr3->glp->gvalue);
				if(--ff == 0) {
					ff = 3;
					printf("\n");
				}
			}
			if(ff != 3)
				printf("\n");
		}
	}
I 12
	}
E 12
}


opn_next()
{
	register char *rp,*rq;
	register int j;
	char c;
	int k;
	char symnmm[6];
I 2
	char	*suf;
E 2

	objbuf.fildes = -1;
D 4
opn1:	if(wfile == filec)
E 4
I 4
opn1:	if (wfile > filec)
E 4
		return(0);
I 4
	if (wfile == filec)
		if (flags & OD) {
			rp = odtfile;
			wfile++;
			odtyes = 1;
			goto opn2;
		} else
			return(0);
E 4
	rp = rq = filev[wfile++];
	k = 0;
I 2
	suf = ".obj";
E 2
	if(*rq++ == '-') 
	switch(*rq++) {
	
	case 'f':	rp = fortlib;
I 4
			if (*rq == 'd')
				/* -fd[t] */
				rp = fdtfile;
E 4
			break;
	case 'e':	k = 1;
	case 'i':	if(*rq++ == ':') {
				j = 6;
				rp = symnmm;
				while(j && (c = *rq++)) {
					*rp++ = c;
					j--;
				}
				if(j)
					*rp++ = 0;
				radixin(symnmm,gsdent.nm);
				rp = getglo(gsdent.nm);
				if(k)
					rp->gflags =| EXC;
				else
					rp->gflags =& ~EXC;
				goto opn1;
			}
I 2
			goto dflt;
	case 'l':	if (*rq++ == ':') {
				for (rp = &lib[9]; (*rp++ = *rq++) != '\0';);
				suf = ".olb";
				rp = &lib[4];
				break;
			}
	dflt:
E 2
D 13
	default:	ferror("Bad switch");
E 13
I 13
	default:	lerror("Bad switch");
E 13

	}
I 12
	else if (wfile == odfno) {
		/* get next argument from odf if any left */
		if ((rq = getnext()) != NIL) {
			wfile--;
			rp = rq;
		} else
			goto opn1;	/* none left */
	}
E 12

D 2
	objbuf.fildes = open(rp,0);
E 2
I 2
opn2:
	objbuf.fildes = open(ext(rp,suf),0);
E 2
	if(objbuf.fildes == -1) {
D 2
		objbuf.fildes = open(ext(rp,".obj"),0);
E 2
I 2
		objbuf.fildes = open(rp,0);
E 2
		if(objbuf.fildes == -1) {
I 2
			if (rp == &lib[4]) {
				rp = lib;
				goto opn2;
			}
E 2
D 13
			printf(rp);
			ferror(" : cannot open object file.");
E 13
I 13
			fprintf(stderr,rp);
			lerror(" : cannot open object file.");
E 13
		}
	}
	objbuf.nonused = read(objbuf.fildes,objbuf.buff,512);
I 5
	if (objbuf.buff[0] != 1) {
D 13
		printf(rp);
		ferror(" : illegal format object file.");
E 13
I 13
		fprintf(stderr,rp);
		lerror(" : illegal format object file.");
E 13
	}
E 5
	objbuf.nxtfree = objbuf.buff;
	return(1);
}
I 12

/*
 * checks syntax of odf - fatal error if not ok
 */
checkodf()
{
	register int	i;
	register char	*s;

	/* check first line is .root */
	s = getname();
	if (strcmp(s, ".root")!=0 || peekc!='\n')
		badodf();
	if (checkline() != 0)
		badodf();	/* no root segment */
	i = checkline();
	while (i > 0) {
		nreg++;		/* another region */
		for (;;) {
			i = checkline();
			if (i != 0)
				break;
			nseg++;		/* another segment */
		}
	}
	if (i >= 0)
		badodf();	/* didn't get ".end" */
}

/*
 * read until '\n' - check for valid filenames
 */
checkline()
{
	register char	*s;

	s = getname();
	if (*s == '.') {
		if (peekc != '\n')
			badodf();	/* all keywords must be by themselves */
		if (strcmp(s, ".region") == 0)
			return(1);
		if (strcmp(s, ".end") == 0)
			return(-1);
		/* unknown keyword */
		badodf();
	}
	for (;;) {
		if (*s=='.' || *s=='\0')
			/* null filenames not acceptable */
			/* only commands may commence with '.' */
			badodf();
		if (peekc == '\n')
			return(0);
		s = getname();
	}
}


/*
 * reads one char from odf
 */
readc()
{
	static char	c;

	if (read(odf, &c, 1) <= 0)
		badodf();
	return(c);
}

badodf()
{
D 13
	ferror("bad overlay descriptor file.");
E 13
I 13
	lerror("bad overlay descriptor file.");
E 13
}

/*
 * Gets next file name from overlay descriptor file.
 * Returns pointer to filename if successful; NIL if no more.
 * Updates region and segment numbers.
 */
getnext()
{
	register char	*s;
	register char	c;

	c = peekc;
	s = getname();
	if (c == '-')
		/* still in same segment and region */
		return(s);

	psecte = NIL;
	if (c == '\n') {
		segment++;
		if (*s != '.') {
			/* 1st file in new segment */
			curmod = NIL;
			(*segwk)[segment].segreg = region;
			return(s);
		}
		if (region == 0)
			reroot = curmod;	/* save current position in list */
		if (s[1] == 'e') {
			/* .end */
			/* reset to 1st segment (root!) */
			region = 0;
			segment = 0;
			curmod = reroot;
			return(NIL);
		}
		/* must be .region */
		region++;
		curmod = NIL;
		(*segwk)[segment].segreg = region;
	}
		/* else must be .root */
	return(getname());
}

/*
 * Reads a filename from odf.
 * Acceptable characters for filenames are: a-z, A-Z, 0-9, '.' and '_'.
 * Blanks and tabs between filenames are ignored.
 * The only other characters accepted are '-' and '\n' which
 * are left in peekc after reading the name.
 */
getname()
{
	register char	c;
	register char	*s;
	static char	fname[50];

	s = fname;
	/* skip blanks and tabs */
	do {
		c = readc();
	} while (c==' ' || c=='\t' || c=='\n');
	for (;;) {
		if ((c<'a' || c>'z') && (c<'A' || c>'Z'))
			if (c<'0' || c>'9')
				if (c!='.' && c!='_')
					/* invalid character for name */
					break;
		*s++ = c;
		c = readc();
	}
	while (c==' ' || c=='\t')
		c = readc();
	if (c!='-' && c!='\n')
		badodf();
	peekc = c;
	*s = '\0';
	return(fname);
}

E 12
crefout(name,flag)
int	*name;
{
	register int *r1;
	int crstuff[5];

	if( (flags&CR) && ( ((flags&NL)==0) || (curmod->mislib==0 ))) {
		r1 = crstuff;
		*r1++ = name[0];
		*r1++ = name[1];
		*r1++ = curmod->mname[0];
		*r1++ = curmod->mname[1];
		*r1 = flag;
		write(crfile, crstuff, 10);
	}
}
E 1
