#
/* general nonsense overlay program
 * J. N. Rottman
 */

#include <stdio.h>
#undef	ferror

int	ofile;			/*overlay descriptor file */
int	ovfile;			/*overlay output file */
long	filpnt	=0;		/* current pointer in overlay file */
char	root[30];		/*name of root file (without extension) */
char	ovn[25][30];		/*overlay file names */

struct	otable	{
	long	oposn;
	int	ocnt;
} otable[25];

struct	otable	*opnt otable;

unsigned int	msize	0;		/* max size of overlay region */
int	rootsize;		/* size of root */
int	bflag 0;

main(argc,argv)
int argc;
char *argv[];
{
	int	i,nov;
	if(argc==3) {
		bflag++;
		argc--;
	}

	if(argc != 2)
		ferror("Arg count");
	ofile = open(argv[1],0);
	if(ofile == -1)
		ferror("Cannot open descriptor file");

	readln(root);

	nov = 0;

	while(readln(ovn[nov]))
		nov++;

	ovfile=creat("ov.out",0600);

	if(ovfile == -1)
		ferror("Cannot create output file");

	sizeroot();
	for(i = 0; i < nov; i++)
		linkit(i);

	maktab();

	close(ovfile);
	close(ofile);
}
ferror(s)
char *s;
{
	printf("%s\n",s);
	close(ovfile);
	unlink("ov.out");
	exit(1);
}

readln(s)
char *s;
{
	register char *s1;
	register int bc;
	char	cc;
	s1=s;
	while((bc=read(ofile,&cc,1)) && cc != '\n')
		*s1++ = cc;
	*s1 = '\0';
	return(bc);
}

linkit(i)
int i;
{
	register unsigned int size;
	int k,magic[8];

	callsys(2,"/bin/link",root,ovn[i]);

	k = open(ext(root,".out"),0);

	if(k == -1)
		ferror("Cannot open object");

	read(k,magic,16);
	if(magic[0] != 0407)
		ferror("Not magic");
	if(magic[1] != 0)
		ferror("Not null text");
	if(magic[3] != 0)
		ferror("Not null bss");

	/* set up descriptor in otable */


	size = magic[2] - rootsize;

	lseek(k,(long)rootsize,1);

	opnt->oposn = filpnt;
	opnt->ocnt = size;
	
	tran(k,ovfile,size);

	close(k);

	msize = max(size,msize);
	filpnt += size;
	if (bflag)
		filpnt = ((filpnt + 511) / 512)*512;
	opnt++;
}

tran(in,out,count)
unsigned int count;
{
	char	buffer[512];
	int	block,remn;

	block = count / 512;
	remn = count % 512;

	while(block--) {
		read(in,buffer,512);
		write(out,buffer,512);
	}
	if(remn) {
		read(in,buffer,remn);
		write(out,buffer,(bflag ? 512 : remn));
	}
}

ext(s1,s2)
char *s1,*s2;
{
	static	char	s3[50];
	register char	*r1,*r2,*r3;

	r1 = s1;
	r2 = s2;
	r3 = s3;

	while(*r3 = *r1++) r3++;
	while(*r3++ = *r2++);
	return(s3);
}

sizeroot()
{
	int	rfile,magic[8];
	callsys(1,"/bin/link",root);
	rfile = open(ext(root,".out"));
	if(rfile == -1)
		ferror("Cannot open root file");
	read(rfile,magic,16);
	if(magic[0] != 0407)
		ferror("Root not magic");
	if(magic[1] != 0)
		ferror("Non-null root text");
	if(magic[3])
		ferror("Non-null root bss");
	rootsize = magic[2];
	close(rfile);
}
callsys(n,s1,s2,s3)
int n;
char *s1,*s2,*s3;
{
	int	d;
	d = fork();
	if(d==0) {
		if(n=2)
			execl(s1,s1,s2,s3,0);
		else
			execl(s1,s1,s2,0);
		ferror("Bad fork");
	} else
		wait(&d);
}


max(a,b)
unsigned int a;
unsigned int b;
{
	return(a>b? a : b);
}

maktab()
{
	register	struct	otable	*op;
	register FILE *f;

	f = fopen("otable.m11", "w");
	if (f == NULL)
		ferror("Cannot create otable");
	fprintf(f, "\n\n\t.title\totable\n\t.psect\totable,ovr\n");
	
	for(op = otable; op < opnt; op++) 
		fprintf(f, "\t.word\t%o,%o,%o\n",
			op->oposn,	/* nasty - 2 arguments */
			op->ocnt);

	fprintf(f, "\n\n\t.psect\tobuff,con\n");
	fprintf(f, "\t.blkb\t%o\n",msize);
	fprintf(f, "\n\t.end\n");

	fclose(f);

	callsys(2,"/bin/macro","-xs:10","otable.m11");
	callsys(2,"/bin/link",root,"otable");
}
