; The use and distribution of the information
; contained herein may be restricted.
;
title	mad,<decimal math routines>,24,26-jun-74,mhb/jdm

subf:	jsr	pc,negf		;subtraction is really reverse addition
addf:	mov	(r1),-(sp)	;get sign of 1st floater
	bic	#077777,(sp)	;then save only the sign bit
	add	fltle2(r1),(sp)	;and accumulate sign bits
	ror	(sp)		;save carry and sign bits
	jsr	pc,addfs	;now add on r1 stack
	rol	(sp)+		;check for overflows
	bmi	1$		;if different signs then no possibilty
	mov	(r1),-(sp)	;if same sign, then check result sign
	ror	(sp)		;put old carry and sign into word
	asl	(sp)+		;now check for sign mathcing
	bvc	1$		;if same, then o.k.
	post,	pstflt		;else error
1$:	rts	pc		;and exit

; add r1 stack items

addfs:	mov	r1,r4		;copy r1 stack
	add	#fltle4,r1	;r1 to bottom of 2nd
	add	#fltle2,r4	;r1 to bottom of 1st

;addition routine - adds -(r4) to -(r1) and kills r3

addf0:	mov	#fltlen,r3	;get # words counter
addfd:	clc			;initial carry clear
1$:	adc	-(r1)		;add carry from before
	bcs	2$		;if more carry then check it
	add	-(r4),(r1)	;else add next element
3$:	sob	r3,1$		;if more, then go add any carry
	rts	pc		;else with with carry indicating

2$:	mov	-(r4),(r1)	;if carry from add carry the result
	br	3$		;was 0, so just move and continue
; float a fixed integer into a floater
; don't touch r0 or r4!

flt:	mov	(r1),-(sp)	;save sign of integer
	bpl	flt00		;+
	neg	(r1)		;if -, make it +
flt00:	clr	-(r1)		;make rest of floater 0
flt.02:	fltclr	-(r1)

; multiply by the factor of 10

fixf2:	mov	r4,-(sp)	;remember to save r4
	mov	r0,-(sp)	; and r0!
	mov	#6.,r0		;this is the correct power of ten
1$:	jsr	pc,m10		;multiply by 10.
	sob	r0,1$		;loop for all 6. multiplies
	mov	(sp)+,r0	;restore r0 and
	mov	(sp)+,r4	; r4...
	jmp	sgnext		;exit via extending sign if needed

; fix function

fixf:	jsr	r5,intfun	;get a floater
	args	faf
fixf1:	jsr	pc,absfsv	;make abs, but save sign
	fltclr	-(r1)		;now make into double
	fltclr	-(r1)		; floater
	jsr	pc,divcor	;and divide out correction factor (1.000000)
	fltpp	(r1)+		;junk all 0 high order words
	br	fixf2		;now go re-correct number and restore sign
; floating multiply

	.enabl	lsb

mulf:	jsr	pc,9$		;do common sign checking
1$:	jsr	pc,mult		;then multiply
	jsr	pc,divcor	;correct result (divide by 1.000000)
20$:	mov	(r1)+,-(sp)	;check for overflow
	bis	(r1)+,(sp)
	bis	(r1)+,(sp)
	bis	(r1)+,(sp)+	;final check
	bne	2$		;error
	tst	(r1)
	bpl	3$		;no error
2$:	post,	pstflt		;post the error
3$:	jmp	sgnext		;exit by extending sign if needed

9$:	mov	(sp),-(sp)	;move return address
	mov	(r1),2(sp)	;save 1st sign here
	bic	#077777,2(sp)	;but only the sign bit
	beq	10$		;and it is +
	jsr	pc,negf		;if -, then make it +
10$:	jsr	pc,fltest	;check for true 0
	bne	11$		;not 0
	add	#fltle2,r1	;dump 2nd floater also
	cmp	(sp),#1$	;mul or div?
	beq	12$		;if mul then o.k.
	post,	pstdv0		;else error
12$:	cmp	(sp)+,(sp)+	;dump return address and signs
	jmp	pushf0		;and exit with a 0

11$:	add	(r1),2(sp)	;form final sign of result
	tst	(r1)		;+ or -
	bpl	13$		;+
	jsr	pc,negf		;if -, make it +
13$:	jsr	pc,fltest	;0?
	beq	12$		;if 0, then answer is 0
	sub	#fltle4,r1	;back up r1 stack to top again
	rts	pc		;and exit with sign on sp stack
; division

divf:	jsr	pc,9$		;do common thing
	movflt	(r1)+,-(sp)	;save divisor on sp stack
	jsr	pc,pushf1	;push 1.000000
	jsr	pc,mult		;this shifts dividend by 10 power
	movflt	(sp)+,-(r1)	;restore divisor
	mov	#20$,-(sp)	;return to overflow check
	;jmp	div		;now go divide

	.dsabl	lsb
; division routine
; enter with double dividend and divisor on top

div:	mov	r5,-(sp)	;save possible ipc
	mov	r0,-(sp)	;save r0
	mov	#fltlen*2*16.+1,-(sp);set main counter
	mov	r1,r2		;copy r1 stack
	fltclr	-(r1)		;clear remainder area
	fltclr	-(r1)
	mov	r2,r4
	add	#fltle2,r4	;bottom+2 of divisor
	movflt	-(r4),-(r1)	;put divisor on top
	jsr	pc,negf		;and make negative
	sub	#fltle2,r4	;bottom+2 of -divisor
	add	#fltle4,r1	;bottom+2 of remainder
	add	#fltle4+fltle2,r2;bottom+2 of dividend
	clr	r0		;clear lasting carry
	clr	r5		;clear temp carry
	mov	r4,-(sp)	;save bottom+2 of -divisor
	br	4$		;do initial subtraction

1$:	rol	r0		;load carry
	mov	#fltle2,r0	;use r0 for counter (carry unchanged)
2$:	rol	-(r2)		;double rotate
	sob	r0,2$		;loop (doesn't change carry)
	ror	r0		;save carry in (by now) zero r0
	add	#fltle4,r2	;correct pointer
	rol	r0
	rol	-(r1)
	rol	-(r1)
	rol	-(r1)
	rol	-(r1)
	add	#fltle2,r1	;correct pointer
	tst	r5		;carry?
	beq	3$		;no
	clr	r5		;clear it
	br	4$
3$:	add	#fltle4,r4	;use + divisor
4$:	jsr	pc,addf0	;add
	adc	r5		;add to temp carry
	beq	5$		;none
	inc	-2(r2)
5$:	mov	(sp),r4		;restore
	add	#fltle2,r1	;correct
	dec	2(sp)		;again?
	bne	1$		;yes
	cmp	(sp)+,(sp)+
	add	#fltle2,r1	;correct
	mov	(sp)+,r0	;restore r0
	mov	(sp)+,r5	;get back possible ipc
	rts	pc		;exit
; common multiplication routine
; enter with 2 floaters, exit with 1 double floater

mult:	mov	r5,-(sp)	;save possible ipc
	mov	#fltle2,r2	;handy constant
	mov	r1,r4		;point r4 at bottom+2 of arg (after move)
	mov	r1,r3		;point r3 at bottom+2 of arg (for moving)
	add	r2,r1		;now go to bottom+2 of arg itself
40$:	mov	-(r1),-(r3)	;move arg up on stack and
	clr	(r1)		; clear high order words of double result
	cmp	r1,r4		;done all words yet?
	bhi	40$		;nope...
	mov	#fltlen*16.+1,r5;set main loop counter
30$:	mov	r2,r3		;pre-load a word counter
	tst	fltle4-2(r1)	;is whole last word zero?
	bne	31$		;nope, so no fast word shift possible
	cmp	r5,#16.		;yes, but are there a word's worth left??
	blt	31$		;no fast word shift is possible if not
	add	#fltle4,r1	;set up for a fast 16. bit shift (word)
32$:	mov	-4(r1),-(r1)	;move 1 word down 1 word
	sob	r3,32$		;do this for all words...
	clr	(r1)		;that last (top) word gets all zero in it
	sub	#16.,r5		;correct the main counter
	bgt	30$		;there is more to do
	br	23$		;all done!

31$:	tstb	fltle4-2(r1)	;is whole last byte zero?
	bne	20$		;nope, so no fast byte shift possible
	cmp	r5,#8.		;yes, but are there a byte's worth left??
	blt	20$		;no fast byte shift is possible if not
	add	#fltle4,r1	;set up for a fast 8. bit shift (byte)
33$:	swab	-(r1)		;bring high byte of word over word's low byte
	movb	-2(r1),1(r1)	;then bring low byte of next into this high byte
	sob	r3,33$		;do this for all words
	clrb	1(r1)		;that last (top) byte gets all zero in it
	sub	#8.,r5		;correct the main counter
	bgt	30$		;there is more to do
	br	23$		;all done!

20$:	clc			;clear that carry
21$:	ror	(r1)+		;shift result 1 bit to the right
	sob	r3,21$		;do this for all words
	mov	r4,r1		;reset r1 to top of result (carry unchanged)
	bcc	22$		;if no carry out then no add needed
	add	r2,r1		;else index for the addition to result
	jsr	pc,addf0	;add arg of high order of result
	mov	r1,r4		;reset r4 to bottom+2 of arg
22$:	sob	r5,30$		;main loop...
23$:	mov	(sp)+,r5	;restore possible ipc
	rts	pc		;and exit
; fix a floater

fix:	jsr	pc,absfsv	;make abs and save sign
	mov	r4,-(sp)	;save r4 for the world
	mov	r1,r4		;copy r1 stack pointer
	sub	#fltle2+2,r1	;make room for 1 floater + 1 integer
	mov	r1,r2		;copy that spot
	movflt	(r4)+,(r2)+	;put abs floater on top
	clr	(r2)+		;set +32768.00000 (1st = 0)
	mov	#7,(r2)+	; (2nd=000007)
	mov	#120440,(r2)+	;  (3rd=120440)
	clr	(r2)+		;   (4th=000000)
	clr	(r2)		;make trial integer a 0
	jsr	pc,cmpf		;compare abs floater with 32768.
	ble	1$		;if abs floater >= 32768. then error
	mov	#040000,-(sp)	;else set bit pattern on stack
4$:	asr	(r1)+		;divide 32768. by 2
	ror	(r1)+		;all
	ror	(r1)+		; 4
	ror	(r1)+		;  words of it
	mov	r1,r3		;save pointer to bottom+2 of it
	sub	#fltle4,r1	;back up to abs floater
	jsr	pc,cmpf		;compare abs floater with trial
	bgt	5$		;trial bigger than abs floater
	sub	#fltle2,r1	;back up to abs floater
	movflt	-(r3),-(r1)	;put trial value on r1 stack top
	jsr	pc,negf		;negate it
	jsr	pc,addfs	;and reduce abs floater quickly
	add	#fltle2,r1	;point r1 back to trial
	bis	(sp),(r2)	;and include bit in result
5$:	asr	(sp)		;next position for trial bit
	bne	4$		;continue until no bit left
	tst	(sp)+		;dump word of 0
3$:	mov	(sp)+,r4	;restore r4
	mov	r2,r1		;r1 has new r1 stack spot
	tst	(sp)+		;integer final sign check
	bpl	2$		;leave if +
	neg	(r1)		;make it -
2$:	rts	pc		;exit

1$:	post,	pstfix		;integer error
	br	3$		;now exit
; compare floating

cmpf:	mov	#077777,-(sp)	;set a + number first
	mov	r1,r4		;copy r1 stack pointer
	add	#fltle2,r1	;dump one number
	cmp	(r4)+,(r1)	;1st word check
	bgt	1$		;set -
	blt	2$		;keep +
	cmp	(r4)+,2(r1)	;rest of the checks
	bhi	1$
	blo	2$
	cmp	(r4)+,4(r1)	;next word
	bhi	1$
	blo	2$
	cmp	(r4)+,6(r1)	;last word
	bhi	1$
	blo	2$
	clr	(sp)		;the same!!
	br	2$

1$:	com	(sp)		;make -
2$:	tst	(sp)+		;set cc's
	rts	pc

bnt4:	mov	r1,-(sp)	;save current r1
	jsr	pc,duplf	;then duplicate floater
	jsr	pc,absf00	;and make it absolute
	tst	(r1)+		;1st word must be 0
	bne	5$		;no go
	cmp	(r1)+,#000007	;2nd word must be <=7
	bhi	5$		;no go
	blo	6$		;o.k.
	cmp	(r1)+,#120440	;3rd word must be <120440
	blo	6$		;o.k.
5$:	mov	#flotim,2(sp)	;change return address
6$:	mov	(sp)+,r1	;restore r1
	rts	pc		;and exit
; floater to ascii conversion

ftoatb:	.word	006740,133263,123544,000000	;1000000000000.000000
	.word	000543,042570,056612,000000	; 100000000000.000000
	.word	000043,103362,067701,000000	;  10000000000.000000
	.word	000003,106576,122306,100000	;   1000000000.000000
	.word	000000,055363,010172,040000	;    100000000.000000
	.word	000000,004430,047162,120000	;     10000000.000000
	.word	000000,000350,152245,010000	;      1000000.000000
	.word	000000,000027,044166,164000	;       100000.000000
	.word	000000,000002,052013,162000	;        10000.000000
	.word	000000,000000,035632,145000	;         1000.000000
	.word	000000,000000,002765,160400	;          100.000000
	.word	000000,000000,000230,113200	;           10.000000
	.word	000000,000000,000017,041100	;            1.000000
	.word	000000,000000,000001,103240	;             .100000
	.word	000000,000000,000000,023420	;             .010000
	.word	000000,000000,000000,001750	;             .001000
	.word	000000,000000,000000,000144	;             .000100
	.word	000000,000000,000000,000012	;             .000010
;	.word	000000,000000,000000,000001	;             .000001
ftoa:	jsr	pc,absfsv	;take abs and save sign
	mov	r1,r3		;copy stack pointer
	sub	#7*2,r1		;make room for digits
	mov	r1,r2		;save digit start point
	add	#fltle2,r3	;go to end+2 of floater
	mov	r3,-(sp)	;save that place
	movflt	-(r3),-(r1)	;move floater up top
	mov	#maxsig-1,-(sp)	;counter for table
	mov	#ftoatb-fltle2,r0;pointer into table
3$:	mov	#'0,-(sp)	;set base for a digit
	fltpp	(r0)+		;next table item please
5$:	jsr	pc,pushf2	;push it
	jsr	pc,negf		;negate it
	jsr	pc,addfs	;then add
	tst	(r1)		;check sign
	bmi	4$		;overflow
	inc	(sp)		;else bump digit
	br	5$		;and continue

4$:	jsr	pc,pushf2	;push it again
	jsr	pc,addfs	;this time add it back it
	movb	(sp)+,(r2)+	;and set the digit
	dec	(sp)		;again?
	bne	3$		;yes
	add	#fltle2-2,r1	;dump most of floater
	mov	(r1)+,(sp)	;get last digit
	add	#'0,(sp)	;make it ascii
	movb	(sp)+,(r2)+	;and then set last digit
	mov	(sp)+,r3	;restore final pointer
	mov	#maxsig-6.,-(r3);set scale factor
	clrb	-(r3)		;set + initially
	tst	(sp)+		;final sign check
	bpl	1$		;+
	movb	#'-,(r3)	;set - sign
1$:	rts	pc		;exit
; correct by dividing by 1.000000

; this uses the fact that 1,000,000. = 500,000. * 2.
; and that 500,000. = 524288. - 24288. = 2.^19. - 24288.

; assuming y is the answer and x is the dividend then---
;	y <- 0.
;  lp:	t <- x&(2.^19.-1.)
;	x <- x/(2.^19.)
;	y <- y + x
;	x <- x * 24288.
;	x <- x + t
;	if x>= 2.^19. then goto lp
;	if x>=500,000. then y <- y + 1.
;	y <- y/2.

divcor:	mov	r0,-(sp)	;save r0 and
	mov	r5,-(sp)	; possible ipc
	mov	r1,r0		;point to (to be) bottom+4 of dividend (x)
	add	#fltle4,r1	;point to bottom+2 of (currently) dividend
	clr	-(r0)		;clear the guard word (dividend bottom+2)
.nlist
.rept	fltle2
.list
	mov	-(r1),-(r0)	;move a dividend word up on stack
	clr	(r1)		; clearing the answer as we go
.nlist
.endr
.list
5$:	mov	r0,r4		;reset r4 to point to top of x (dividend)

; save x&(2.^19.-1.)

	add	#fltle4-4,r4	;point to x bottom -2
	mov	(r4)+,-(sp)	;save top 3 bits of x&(2.^19.-1.)
	bic	#-7-1,(sp)	; *but only top 3 bits*
	mov	(r4),-(sp)	;save bottom 16. bits of x&(2.^19.-1.)

; x <- x/(2.^19.)

	mov	#fltle2-1,r5	;do all words less last word
10$:	clr	r3		;clear lsb of double word to shift
	mov	-(r4),r2	;get msb of double word to shift
	ashc	#-19.+16.,r2	;now do the shift
	bic	#160000,r2	;'ashc' extends sign so clear any extended bits
	bis	r3,4(r4)	;or in top 3 bits of last word set
	mov	r2,2(r4)	;then set new word
	sob	r5,10$		;loop...
	clr	(r4)		;top word gets all zero

; y <- y + x

	add	#fltle4,r1	;go to bottom+2 of y
	add	#fltle4,r4	;go to bottom+2 of x
	mov	#fltle2,r3	;do addition on double percision
	jsr	pc,addfd	;do the addition via subroutine

; x <- x * 24,288.

	mov	#fltle2,r5	;# words to multiply
	add	#fltle4,r4	;go to bottom+2 of x
	clr	r2		;clear current carry initially
20$:	mov	r2,-(sp)	;save current carry
	mov	-(r4),r2	;get next to multiply
	beq	22$		;handle zero quickly
	bmi	23$		;special case ones >=32768.
	mul	#24288.,r2	;r2,r3 gets x*24288.
21$:	add	r3,(sp)		;add low order to current carry
	adc	r2		;if carry carries then carry
22$:	mov	(sp)+,(r4)	;set the resultant word
	sob	r5,20$		;loop...
	br	30$		;skip special code

23$:	bic	#100000,r2	;get x-32768.
	mul	#24288.,r2	;r2,r3 gets (x-32768.)*24288.
	add	#24288./2.,r2	;now add in 32768.*24288.
	br	21$		;and continue

; x <- x + saved x&(2.^19.-1.)

30$:	add	#fltle4,r4	;go to bottom+2 of x
	add	(sp)+,-(r4)	;add low 16. bits to x
	adc	(sp)		;catch any carry
	add	(sp)+,-(r4)	;add high 3 bits to x
31$:	adc	-(r4)		;watch that carry
	bcs	31$		;keep carrying...
	mov	r0,r4		;reset to top of x

; check for x being >=2.^19.

	mov	#fltle2-2,r5	;this many must be zero for <2.^19.
40$:	tst	(r4)+		;zero?
	bne	5$		;nope, around again
	sob	r5,40$		;loop...
	cmp	(r4)+,#7	;check some more
	bhi	5$		;around again...

; check for x being >=500,000.

	blo	50$		;x is < 500,000.
	cmp	(r4),#120440	;check low order (since high order is =)
	blo	50$		;x is < 500,000.
	mov	r1,r4		;point to answer top
	add	#fltle4,r4	;now to bottom+2
	sec			;set to increment answer
46$:	adc	-(r4)		;watch the carry
	bcs	46$		;keep going...

; y <- y/2.

50$:	mov	r1,r4		;point to answer top
	mov	#fltle2,r5	;and get a counter
	clc			;clear initial carry
51$:	ror	(r4)+		;now divide by 2
	sob	r5,51$		;quickly...

; all done

	mov	(sp)+,r5	;restore possible ipc and
	mov	(sp)+,r0	; r0...
	rts	pc		;done
	.end
